<?php
// Sumal Osiant Configuration
if (session_status() === PHP_SESSION_NONE) {
    session_start([
        'name' => 'SumalSession',
        'cookie_lifetime' => 86400,
        'cookie_httponly' => true
    ]);
}

// Paths
define('USERS_FILE', 'data/users.json');
define('ACTIVITY_FILE', 'data/activity.json');
define('HISTORY_FILE', 'data/history.json');
define('API_KEY', 'sachin');
define('API_URL', 'https://anishexploits.site/api/api.php');

// Functions
function isLoggedIn() {
    return isset($_SESSION['sumal_user_id']) && isset($_SESSION['sumal_username']);
}

function requireLogin() {
    if (!isLoggedIn()) {
        header('Location: login.php');
        exit;
    }
}

function sanitizeInput($data) {
    return htmlspecialchars(stripslashes(trim($data)));
}

function readJSON($file) {
    if (!file_exists($file)) return [];
    $content = file_get_contents($file);
    return json_decode($content, true) ?: [];
}

function writeJSON($file, $data) {
    $dir = dirname($file);
    if (!is_dir($dir)) mkdir($dir, 0755, true);
    file_put_contents($file, json_encode($data, JSON_PRETTY_PRINT));
}

function logActivity($user, $action) {
    $log = readJSON(ACTIVITY_FILE);
    $log[] = [
        'user' => $user,
        'action' => $action,
        'timestamp' => date('Y-m-d H:i:s'),
        'ip' => $_SERVER['REMOTE_ADDR'] ?? 'Unknown'
    ];
    writeJSON(ACTIVITY_FILE, array_slice($log, -1000));
}

function callSumalAPI($number) {
    $url = API_URL . '?key=' . API_KEY . '&num=' . urlencode($number);
    $ch = curl_init();
    curl_setopt_array($ch, [
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_SSL_VERIFYPEER => false,
        CURLOPT_TIMEOUT => 15,
        CURLOPT_USERAGENT => 'Sumal-Osiant-Lookup/1.0'
    ]);
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    
    return [
        'code' => $httpCode,
        'data' => json_decode($response, true)
    ];
}

function formatAddress($address) {
    if (empty($address)) return 'Not Available';
    $parts = explode('!!', $address);
    return implode('<br>', array_filter($parts));
}
?>