<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>Dashboard - Sumal Osiant</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="style.css">
    <style>
        /* Compact Dashboard Header */
        .dashboard-header {
            background: var(--sumal-gradient);
            color: white;
            padding: 15px 15px;
            border-radius: 0 0 20px 20px;
            margin-bottom: 15px;
            position: relative;
            overflow: hidden;
        }
        
        .dashboard-header:before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: linear-gradient(45deg, rgba(255,255,255,0.1) 0%, transparent 100%);
        }
        
        .user-info {
            display: flex;
            align-items: center;
            gap: 10px;
            margin-bottom: 15px;
        }
        
        .user-avatar {
            width: 45px;
            height: 45px;
            border-radius: 50%;
            background: rgba(255,255,255,0.2);
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 1.2rem;
            border: 2px solid white;
            flex-shrink: 0;
        }
        
        .user-info div h1 {
            font-size: 1.2rem;
            margin-bottom: 2px;
            white-space: nowrap;
            overflow: hidden;
            text-overflow: ellipsis;
        }
        
        .user-info div p {
            font-size: 0.8rem;
            opacity: 0.9;
        }
        
        /* Compact Stats Grid */
        .stats-grid {
            display: grid;
            grid-template-columns: repeat(3, 1fr);
            gap: 8px;
            margin: 15px 0;
        }
        
        .stat-box {
            background: rgba(255,255,255,0.1);
            padding: 12px 8px;
            border-radius: 12px;
            text-align: center;
            backdrop-filter: blur(10px);
            border: 1px solid rgba(255,255,255,0.2);
        }
        
        .stat-value {
            font-size: 1.3rem;
            font-weight: 700;
            margin-bottom: 3px;
        }
        
        .stat-label {
            font-size: 0.75rem;
            opacity: 0.9;
        }
        
        /* Compact Quick Actions */
        .quick-actions {
            display: flex;
            gap: 8px;
            margin-top: 10px;
            overflow-x: auto;
            padding-bottom: 5px;
            -webkit-overflow-scrolling: touch;
        }
        
        .quick-btn {
            padding: 8px 12px;
            background: white;
            border: 2px solid var(--sumal-border);
            border-radius: 10px;
            color: var(--sumal-dark);
            text-decoration: none;
            font-weight: 500;
            font-size: 0.85rem;
            white-space: nowrap;
            transition: all 0.3s ease;
            display: flex;
            align-items: center;
            gap: 5px;
            flex-shrink: 0;
        }
        
        /* Main Content Area - Adjusted */
        .container {
            padding-top: 5px;
        }
        
        .search-container {
            padding: 0 15px;
        }
        
        .search-box {
            background: white;
            border-radius: 16px;
            padding: 20px;
            box-shadow: var(--sumal-shadow);
            margin-bottom: 20px;
        }
        
        .search-title {
            font-size: 1.2rem;
            margin-bottom: 15px;
            color: var(--sumal-dark);
            display: flex;
            align-items: center;
            gap: 8px;
        }
        
        .results-container {
            padding: 0 15px;
            padding-bottom: 80px; /* Mobile nav के लिए space */
        }
        
        /* Mobile Navigation Adjustment */
        .mobile-nav {
            position: fixed;
            bottom: 0;
            left: 0;
            right: 0;
            background: white;
            display: flex;
            justify-content: space-around;
            padding: 10px 0;
            box-shadow: 0 -2px 10px rgba(0,0,0,0.1);
            z-index: 1000;
        }
        
        /* Remove unnecessary animations */
        .sumal-bg-animation {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100vh;
            z-index: -1;
            overflow: hidden;
        }
        
        /* Mobile Optimizations */
        @media (max-width: 768px) {
            .dashboard-header {
                padding: 12px 12px;
                border-radius: 0 0 15px 15px;
                margin-bottom: 10px;
            }
            
            .search-box {
                padding: 15px;
                margin-bottom: 15px;
            }
            
            .search-title {
                font-size: 1.1rem;
            }
            
            .sumal-input {
                padding: 12px 15px;
                font-size: 16px; /* Prevent iOS zoom */
            }
            
            .sumal-btn {
                padding: 12px 20px;
            }
            
            .result-item {
                padding: 10px 0;
            }
            
            .mobile-nav {
                padding: 8px 0;
            }
            
            .nav-item {
                font-size: 0.75rem;
            }
            
            .nav-item i {
                font-size: 1.1rem;
                margin-bottom: 3px;
            }
        }
        
        /* Very Small Screens */
        @media (max-width: 360px) {
            .user-avatar {
                width: 40px;
                height: 40px;
                font-size: 1rem;
            }
            
            .user-info div h1 {
                font-size: 1rem;
            }
            
            .stat-box {
                padding: 10px 5px;
            }
            
            .stat-value {
                font-size: 1.1rem;
            }
            
            .quick-btn {
                padding: 6px 10px;
                font-size: 0.8rem;
            }
            
            .search-box {
                padding: 12px;
            }
        }
        
        /* Prevent horizontal scrolling */
        * {
            max-width: 100%;
        }
        
        /* Ensure content stays within viewport */
        html, body {
            overflow-x: hidden;
            height: 100%;
        }
        
        /* Scrollbar styling */
        ::-webkit-scrollbar {
            width: 4px;
            height: 4px;
        }
        
        ::-webkit-scrollbar-thumb {
            background: var(--sumal-primary);
            border-radius: 2px;
        }
    </style>
</head>
<body>
    <!-- Floating Background -->
    <div class="sumal-bg-animation" id="particles"></div>
    
    <!-- Compact Dashboard Header -->
    <div class="dashboard-header">
        <div class="container">
            <div class="user-info">
                <div class="user-avatar">
                    <i class="fas fa-user"></i>
                </div>
                <div>
                    <h1>Welcome, <?php echo htmlspecialchars($username); ?>!</h1>
                    <p>Sumal Osiant Lookup</p>
                </div>
            </div>
            
            <div class="stats-grid">
                <div class="stat-box">
                    <div class="stat-value" id="totalSearches">0</div>
                    <div class="stat-label">Total</div>
                </div>
                <div class="stat-box">
                    <div class="stat-value" id="todaySearches">0</div>
                    <div class="stat-label">Today</div>
                </div>
                <div class="stat-box">
                    <div class="stat-value" id="successRate">100%</div>
                    <div class="stat-label">Success</div>
                </div>
            </div>
            
            <div class="quick-actions">
                <a href="history.php" class="quick-btn">
                    <i class="fas fa-history"></i> History
                </a>
                <a href="profile.php" class="quick-btn">
                    <i class="fas fa-user-cog"></i> Profile
                </a>
                <a href="logout.php" class="quick-btn" style="color: var(--sumal-danger);">
                    <i class="fas fa-sign-out-alt"></i> Logout
                </a>
            </div>
        </div>
    </div>
    
    <!-- Main Content - Now much higher up -->
    <div class="container">
        <!-- Search Box - Moved up -->
        <div class="search-container">
            <div class="search-box">
                <h2 class="search-title">
                    <i class="fas fa-search"></i>
                    Phone Lookup
                </h2>
                
                <?php if($error): ?>
                <div class="sumal-alert alert-error" style="margin-bottom: 15px; padding: 10px;">
                    <i class="fas fa-exclamation-circle"></i>
                    <span><?php echo $error; ?></span>
                </div>
                <?php endif; ?>
                
                <form method="POST" action="" id="searchForm">
                    <div style="margin-bottom: 15px;">
                        <input type="tel" 
                               name="number" 
                               class="sumal-input" 
                               placeholder="Enter 10-digit phone number" 
                               value="<?php echo $searched_number; ?>"
                               pattern="[0-9]{10}"
                               maxlength="10"
                               required
                               inputmode="numeric">
                    </div>
                    
                    <button type="submit" class="sumal-btn" style="width: 100%;" id="searchBtn">
                        <i class="fas fa-search"></i>
                        Search
                    </button>
                </form>
                
                <div style="margin-top: 15px; color: var(--sumal-gray); font-size: 0.8rem; text-align: center;">
                    <i class="fas fa-info-circle"></i>
                    Enter 10-digit Indian mobile number
                </div>
            </div>
        </div>
        
        <!-- Results Section -->
        <div class="results-container">
            <?php if($result && isset($result['result'])): ?>
                <?php if($result['success']): ?>
                    <h2 class="search-title" style="margin-bottom: 15px;">
                        <i class="fas fa-file-alt"></i>
                        Results
                        <span style="font-size: 0.8rem; color: var(--sumal-gray); margin-left: 8px;">
                            Found <?php echo count($result['result']); ?> record(s)
                        </span>
                    </h2>
                    
                    <div class="result-tabs" id="resultTabs" style="margin-bottom: 15px;">
                        <?php foreach($result['result'] as $index => $record): ?>
                            <button class="tab-btn <?php echo $index === 0 ? 'active' : ''; ?>" 
                                    data-tab="result-<?php echo $index; ?>"
                                    style="padding: 8px 12px; font-size: 0.85rem;">
                                Record <?php echo $index + 1; ?>
                            </button>
                        <?php endforeach; ?>
                    </div>
                    
                    <?php foreach($result['result'] as $index => $record): ?>
                        <div class="sumal-card result-card <?php echo $index === 0 ? '' : 'no-print'; ?>" 
                             id="result-<?php echo $index; ?>" 
                             style="<?php echo $index === 0 ? '' : 'display: none; margin-bottom: 15px; padding: 15px;'; ?>">
                            <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 15px;">
                                <h3 style="color: var(--sumal-primary); font-size: 1.1rem;">
                                    <i class="fas fa-user-circle"></i>
                                    Record <?php echo $index + 1; ?>
                                </h3>
                                <button class="sumal-btn" onclick="printResult(<?php echo $index; ?>)" style="padding: 8px 15px; font-size: 0.9rem;">
                                    <i class="fas fa-print"></i>
                                </button>
                            </div>
                            
                            <?php 
                            // Define display order
                            $display_order = ['name', 'father_name', 'mobile', 'alt_mobile', 'address', 'circle', 'id_number', 'email'];
                            ?>
                            
                            <?php foreach($display_order as $field): ?>
                                <?php if(isset($record[$field]) && !empty($record[$field])): ?>
                                    <div class="result-item" style="padding: 8px 0; border-bottom: 1px solid var(--sumal-border);">
                                        <div style="display: flex; align-items: flex-start; gap: 10px;">
                                            <div class="result-icon" style="width: 30px; height: 30px; min-width: 30px; font-size: 0.9rem;">
                                                <i class="<?php echo $field_icons[$field] ?? 'fas fa-info-circle'; ?>"></i>
                                            </div>
                                            <div style="flex: 1;">
                                                <span class="result-label" style="font-size: 0.8rem; color: var(--sumal-gray); display: block;">
                                                    <?php 
                                                    $labels = [
                                                        'name' => 'Full Name',
                                                        'father_name' => "Father's Name",
                                                        'mobile' => 'Mobile Number',
                                                        'alt_mobile' => 'Alternate Mobile',
                                                        'address' => 'Address',
                                                        'circle' => 'Telecom Circle',
                                                        'id_number' => 'ID Number',
                                                        'email' => 'Email Address'
                                                    ];
                                                    echo $labels[$field] ?? ucfirst(str_replace('_', ' ', $field));
                                                    ?>
                                                </span>
                                                <span class="result-value" style="font-size: 0.95rem; color: var(--sumal-dark); display: block; margin-top: 3px;">
                                                    <?php if($field === 'address'): ?>
                                                        <?php echo formatAddress($record[$field]); ?>
                                                    <?php elseif($field === 'mobile' || $field === 'alt_mobile'): ?>
                                                        <a href="tel:<?php echo $record[$field]; ?>" style="color: var(--sumal-primary); text-decoration: none;">
                                                            <?php echo $record[$field]; ?>
                                                        </a>
                                                    <?php elseif($field === 'email'): ?>
                                                        <a href="mailto:<?php echo $record[$field]; ?>" style="color: var(--sumal-primary); text-decoration: none;">
                                                            <?php echo $record[$field]; ?>
                                                        </a>
                                                    <?php else: ?>
                                                        <?php echo htmlspecialchars($record[$field]); ?>
                                                    <?php endif; ?>
                                                </span>
                                            </div>
                                        </div>
                                    </div>
                                <?php endif; ?>
                            <?php endforeach; ?>
                            
                            <div style="margin-top: 15px; padding-top: 15px; border-top: 1px solid var(--sumal-border);">
                                <div style="display: flex; align-items: center; gap: 10px;">
                                    <div class="result-icon" style="background: var(--sumal-secondary); width: 30px; height: 30px; font-size: 0.9rem;">
                                        <i class="fas fa-database"></i>
                                    </div>
                                    <div>
                                        <span style="font-size: 0.8rem; color: var(--sumal-gray);">Record ID</span>
                                        <span style="font-size: 0.9rem; color: var(--sumal-dark); display: block;">
                                            <?php echo $record['id']; ?>
                                        </span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; ?>
                    
                    <!-- Result Actions -->
                    <div class="sumal-card" style="margin-top: 15px; padding: 15px;">
                        <div style="display: flex; gap: 8px; flex-wrap: wrap;">
                            <button class="sumal-btn" onclick="saveResults()" style="flex: 1; padding: 10px; font-size: 0.9rem;">
                                <i class="fas fa-save"></i> Save
                            </button>
                            <button class="sumal-btn" onclick="shareResults()" style="flex: 1; background: var(--sumal-secondary); padding: 10px; font-size: 0.9rem;">
                                <i class="fas fa-share-alt"></i> Share
                            </button>
                            <button class="sumal-btn" onclick="window.print()" style="flex: 1; background: var(--sumal-warning); padding: 10px; font-size: 0.9rem;">
                                <i class="fas fa-print"></i> Print All
                            </button>
                        </div>
                    </div>
                    
                <?php else: ?>
                    <div class="empty-state" style="padding: 30px 15px;">
                        <i class="fas fa-search" style="font-size: 2.5rem;"></i>
                        <h3 style="margin: 10px 0;">No Results Found</h3>
                        <p style="font-size: 0.9rem;">No information found for this number</p>
                    </div>
                <?php endif; ?>
            <?php elseif($_SERVER['REQUEST_METHOD'] === 'POST'): ?>
                <div class="empty-state" style="padding: 30px 15px;">
                    <i class="fas fa-exclamation-triangle" style="font-size: 2.5rem;"></i>
                    <h3 style="margin: 10px 0;">Search Error</h3>
                    <p style="font-size: 0.9rem;">Unable to fetch data. Please try again.</p>
                </div>
            <?php else: ?>
                <div class="empty-state" style="padding: 30px 15px;">
                    <i class="fas fa-search-location" style="font-size: 2.5rem;"></i>
                    <h3 style="margin: 10px 0;">Ready to Search</h3>
                    <p style="font-size: 0.9rem;">Enter a phone number above to begin your lookup</p>
                </div>
            <?php endif; ?>
        </div>
    </div>
    
    <!-- Mobile Navigation -->
    <nav class="mobile-nav">
        <a href="dashboard.php" class="nav-item active">
            <i class="fas fa-search"></i>
            <span>Search</span>
        </a>
        <a href="history.php" class="nav-item">
            <i class="fas fa-history"></i>
            <span>History</span>
        </a>
        <a href="profile.php" class="nav-item">
            <i class="fas fa-user"></i>
            <span>Profile</span>
        </a>
        <a href="logout.php" class="nav-item">
            <i class="fas fa-sign-out-alt"></i>
            <span>Logout</span>
        </a>
    </nav>
    
    <!-- Footer - Hidden on mobile -->
    <div class="sumal-footer desktop-only" style="display: none;">
        <div class="copyright">© <?php echo date('Y'); ?> Sumal Osiant Lookup System v2.0</div>
        <div class="developer">Powered by <span>Sumal Osiant Technology</span></div>
    </div>
    
    <script>
        // Initialize particles
        function initParticles() {
            const container = document.getElementById('particles');
            for(let i = 0; i < 15; i++) {
                const particle = document.createElement('div');
                particle.className = 'sumal-particle';
                particle.style.width = Math.random() * 60 + 20 + 'px';
                particle.style.height = particle.style.width;
                particle.style.left = Math.random() * 100 + '%';
                particle.style.animationDelay = Math.random() * 15 + 's';
                particle.style.opacity = Math.random() * 0.08 + 0.02;
                container.appendChild(particle);
            }
        }
        
        // Tab switching
        document.querySelectorAll('.tab-btn').forEach(btn => {
            btn.addEventListener('click', function() {
                // Remove active from all tabs
                document.querySelectorAll('.tab-btn').forEach(t => t.classList.remove('active'));
                // Hide all results
                document.querySelectorAll('.result-card').forEach(card => card.style.display = 'none');
                // Activate clicked tab
                this.classList.add('active');
                // Show corresponding content
                const tabId = this.dataset.tab;
                document.getElementById(tabId).style.display = 'block';
            });
        });
        
        // Form submission
        document.getElementById('searchForm').addEventListener('submit', function(e) {
            const btn = document.getElementById('searchBtn');
            const originalHTML = btn.innerHTML;
            btn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Searching...';
            btn.disabled = true;
            
            // Auto-re-enable after 10 seconds
            setTimeout(() => {
                btn.innerHTML = originalHTML;
                btn.disabled = false;
            }, 10000);
        });
        
        // Print individual result
        function printResult(index) {
            const originalDisplay = document.getElementById('result-' + index).style.display;
            document.getElementById('result-' + index).style.display = 'block';
            const printContent = document.getElementById('result-' + index).outerHTML;
            document.getElementById('result-' + index).style.display = originalDisplay;
            
            const printWindow = window.open('', '_blank');
            printWindow.document.write(`
                <html>
                <head>
                    <title>Sumal Osiant Lookup Result</title>
                    <style>
                        body { font-family: Arial, sans-serif; padding: 15px; }
                        .result-item { margin: 10px 0; padding: 8px; border-bottom: 1px solid #eee; }
                        .result-label { font-weight: bold; color: #666; display: block; font-size: 12px; }
                        .result-value { color: #333; display: block; margin-top: 3px; font-size: 14px; }
                        .header { text-align: center; margin-bottom: 20px; border-bottom: 2px solid #6366f1; padding-bottom: 8px; }
                        .footer { margin-top: 20px; text-align: center; color: #666; font-size: 10px; }
                    </style>
                </head>
                <body>
                    <div class="header">
                        <h2 style="margin: 0; font-size: 18px;">Sumal Osiant Lookup Result</h2>
                        <p style="margin: 5px 0; font-size: 12px;">Generated on ${new Date().toLocaleString()}</p>
                    </div>
                    ${printContent}
                    <div class="footer">
                        © ${new Date().getFullYear()} Sumal Osiant Lookup System
                    </div>
                </body>
                </html>
            `);
            printWindow.document.close();
            printWindow.print();
        }
        
        // Save results
        function saveResults() {
            const data = {
                searched: '<?php echo $searched_number; ?>',
                timestamp: new Date().toISOString(),
                results: <?php echo json_encode($result['result'] ?? []); ?>
            };
            
            const blob = new Blob([JSON.stringify(data, null, 2)], {type: 'application/json'});
            const url = URL.createObjectURL(blob);
            const a = document.createElement('a');
            a.href = url;
            a.download = `sumal-lookup-${'<?php echo $searched_number; ?>'}-${Date.now()}.json`;
            document.body.appendChild(a);
            a.click();
            document.body.removeChild(a);
            URL.revokeObjectURL(url);
            
            // Show notification
            alert('Results saved successfully!');
        }
        
        // Share results
        function shareResults() {
            if (navigator.share) {
                navigator.share({
                    title: 'Sumal Osiant Lookup Results',
                    text: `Lookup results for number: <?php echo $searched_number; ?>`,
                    url: window.location.href
                });
            } else {
                navigator.clipboard.writeText(window.location.href);
                alert('Link copied to clipboard!');
            }
        }
        
        // Load stats
        function loadStats() {
            // Simulate stats loading
            setTimeout(() => {
                document.getElementById('totalSearches').textContent = '24';
                document.getElementById('todaySearches').textContent = '3';
            }, 500);
        }
        
        // Initialize
        document.addEventListener('DOMContentLoaded', function() {
            initParticles();
            loadStats();
            
            // Auto-format phone number
            const phoneInput = document.querySelector('input[name="number"]');
            phoneInput.addEventListener('input', function(e) {
                let value = e.target.value.replace(/\D/g, '');
                if (value.length > 10) value = value.substring(0, 10);
                e.target.value = value;
            });
            
            // Focus on input field on page load
            if(phoneInput.value === '') {
                phoneInput.focus();
            }
        });
        
        // Prevent form resubmission on refresh
        if (window.history.replaceState) {
            window.history.replaceState(null, null, window.location.href);
        }
    </script>
</body>
</html>