<?php
require_once 'config.php';
requireLogin();

$username = $_SESSION['sumal_username'];
$history = array_reverse(readJSON(HISTORY_FILE));
$user_history = array_filter($history, function($item) use ($username) {
    return $item['user'] === $username;
});
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>History - Sumal Osiant</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="style.css">
    <style>
        .history-container { padding: 20px; }
        .history-item {
            background: white;
            border-radius: 16px;
            padding: 20px;
            margin-bottom: 15px;
            border-left: 4px solid var(--sumal-primary);
            animation: slide-in 0.3s ease;
        }
        .history-number { 
            font-weight: 600; 
            color: var(--sumal-primary);
            font-size: 1.1rem;
        }
        .history-time { 
            color: var(--sumal-gray); 
            font-size: 0.9rem;
            margin-top: 5px;
        }
        .empty-history {
            text-align: center;
            padding: 60px 20px;
            color: var(--sumal-gray);
        }
    </style>
</head>
<body>
    <div class="dashboard-header">
        <div class="container">
            <a href="dashboard.php" style="color: white; text-decoration: none; display: flex; align-items: center; gap: 10px;">
                <i class="fas fa-arrow-left"></i>
                <span>Back</span>
            </a>
            <h1 style="margin-top: 20px; font-size: 1.8rem;">Search History</h1>
        </div>
    </div>
    
    <div class="container">
        <div class="history-container">
            <?php if(empty($user_history)): ?>
                <div class="empty-history">
                    <i class="fas fa-history" style="font-size: 3rem; opacity: 0.3;"></i>
                    <h3>No Search History</h3>
                    <p>Your search history will appear here</p>
                </div>
            <?php else: ?>
                <?php foreach($user_history as $item): ?>
                    <div class="history-item">
                        <div class="history-number">
                            <i class="fas fa-phone"></i>
                            <?php echo htmlspecialchars($item['number']); ?>
                        </div>
                        <div class="history-time">
                            <i class="fas fa-clock"></i>
                            <?php echo date('M d, Y - h:i A', strtotime($item['timestamp'])); ?>
                        </div>
                        <div style="margin-top: 10px; font-size: 0.9rem;">
                            <span style="background: var(--sumal-light); padding: 4px 10px; border-radius: 20px;">
                                <?php echo $item['results_count']; ?> records found
                            </span>
                        </div>
                    </div>
                <?php endforeach; ?>
            <?php endif; ?>
        </div>
    </div>
    
    <!-- Mobile Navigation -->
    <nav class="mobile-nav">
        <a href="dashboard.php" class="nav-item">
            <i class="fas fa-search"></i>
            <span>Search</span>
        </a>
        <a href="history.php" class="nav-item active">
            <i class="fas fa-history"></i>
            <span>History</span>
        </a>
        <a href="profile.php" class="nav-item">
            <i class="fas fa-user"></i>
            <span>Profile</span>
        </a>
        <a href="logout.php" class="nav-item">
            <i class="fas fa-sign-out-alt"></i>
            <span>Logout</span>
        </a>
    </nav>
</body>
</html>