<?php 
require_once 'config.php';

// If not logged in, redirect to login page
if (!isLoggedIn()) {
    header('Location: login.php');
    exit;
}

// Only logged in users can see this page
$username = $_SESSION['username'];
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Number Info Lookup - Home</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="style.css">
</head>
<body>
    <!-- Navbar -->
    <nav class="navbar">
        <div class="nav-container">
            <a href="index.php" class="logo">
                <i class="fas fa-search"></i> NumberLookup
            </a>
            <div class="nav-links">
                <a href="index.php"><i class="fas fa-home"></i> Home</a>
                <a href="dashboard.php"><i class="fas fa-tachometer-alt"></i> Dashboard</a>
                <a href="#features"><i class="fas fa-star"></i> Features</a>
                <span class="welcome-user">
                    <i class="fas fa-user-circle"></i> <?php echo htmlspecialchars($username); ?>
                </span>
                <a href="logout.php" class="btn-nav-logout"><i class="fas fa-sign-out-alt"></i> Logout</a>
            </div>
            <button class="mobile-menu-btn">
                <i class="fas fa-bars"></i>
            </button>
        </div>
    </nav>

    <!-- Hero Section -->
    <div class="hero">
        <div class="hero-bg-shapes">
            <div class="shape shape-1"></div>
            <div class="shape shape-2"></div>
            <div class="shape shape-3"></div>
        </div>
        <div class="container">
            <div class="hero-content">
                <div class="hero-badge">
                    <i class="fas fa-bolt"></i> Fast & Secure Lookup
                </div>
                <h1>
                    Welcome Back, 
                    <span class="gradient-text"><?php echo htmlspecialchars($username); ?>!</span>
                </h1>
                <p class="subtitle">
                    Search any phone number to get detailed information including name, 
                    location, carrier, and more.
                </p>
                
                <!-- Main Search Box -->
                <div class="main-search">
                    <form action="dashboard.php" method="POST" class="search-form hero-search">
                        <div class="input-group">
                            <i class="fas fa-phone input-icon"></i>
                            <input type="text" name="number" placeholder="Enter phone number to search..." required>
                            <button type="submit" class="btn-search">
                                <i class="fas fa-search"></i> Lookup
                            </button>
                        </div>
                    </form>
                    <p class="search-hint">
                        <i class="fas fa-info-circle"></i> 
                        Enter number with country code for best results (e.g., +91 9876543210)
                    </p>
                </div>

                <!-- Quick Stats -->
                <div class="trust-badges">
                    <div class="trust-item">
                        <i class="fas fa-shield-alt"></i>
                        <span>100% Secure</span>
                    </div>
                    <div class="trust-item">
                        <i class="fas fa-bolt"></i>
                        <span>Instant Results</span>
                    </div>
                    <div class="trust-item">
                        <i class="fas fa-clock"></i>
                        <span>24/7 Available</span>
                    </div>
                </div>
            </div>
            
            <!-- Phone Mockup -->
            <div class="hero-image">
                <div class="phone-mockup">
                    <div class="phone-screen">
                        <div class="result-preview">
                            <div class="preview-header">
                                <i class="fas fa-user-circle"></i>
                                <span>Search Result</span>
                            </div>
                            <div class="preview-item">
                                <span class="label">📱 Number</span>
                                <span class="value">+91 98765*****</span>
                            </div>
                            <div class="preview-item">
                                <span class="label">👤 Name</span>
                                <span class="value">John D***</span>
                            </div>
                            <div class="preview-item">
                                <span class="label">📍 Location</span>
                                <span class="value">Mumbai, MH</span>
                            </div>
                            <div class="preview-item">
                                <span class="label">📡 Carrier</span>
                                <span class="value">Jio</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Features Section -->
    <section id="features" class="features-section">
        <div class="container">
            <div class="section-header">
                <h2><i class="fas fa-star"></i> Features</h2>
                <p>What you can do with NumberLookup</p>
            </div>
            <div class="features-grid">
                <div class="feature-card">
                    <div class="feature-icon">
                        <i class="fas fa-phone-alt"></i>
                    </div>
                    <h3>Phone Lookup</h3>
                    <p>Get carrier, location, and line type information for any phone number.</p>
                </div>
                <div class="feature-card featured">
                    <div class="featured-badge">Popular</div>
                    <div class="feature-icon">
                        <i class="fas fa-user-secret"></i>
                    </div>
                    <h3>Identity Lookup</h3>
                    <p>Find name, address, and other details linked to a phone number.</p>
                </div>
                <div class="feature-card">
                    <div class="feature-icon">
                        <i class="fas fa-history"></i>
                    </div>
                    <h3>Search History</h3>
                    <p>All your searches are saved and can be accessed anytime.</p>
                </div>
            </div>
        </div>
    </section>

    <!-- Quick Actions -->
    <section class="quick-actions-section">
        <div class="container">
            <div class="section-header">
                <h2><i class="fas fa-rocket"></i> Quick Actions</h2>
                <p>Get started quickly</p>
            </div>
            <div class="quick-actions-grid">
                <a href="dashboard.php" class="quick-action-card">
                    <div class="action-icon">
                        <i class="fas fa-search"></i>
                    </div>
                    <h3>New Search</h3>
                    <p>Start a new number lookup</p>
                </a>
                <a href="dashboard.php" class="quick-action-card">
                    <div class="action-icon">
                        <i class="fas fa-history"></i>
                    </div>
                    <h3>View History</h3>
                    <p>See your past searches</p>
                </a>
                <a href="dashboard.php" class="quick-action-card">
                    <div class="action-icon">
                        <i class="fas fa-user-cog"></i>
                    </div>
                    <h3>My Account</h3>
                    <p>Manage your profile</p>
                </a>
            </div>
        </div>
    </section>

    <!-- Footer -->
    <footer class="footer">
        <div class="container">
            <div class="footer-simple">
                <p>&copy; 2024 NumberLookup. All rights reserved. | Logged in as: <?php echo htmlspecialchars($username); ?></p>
            </div>
        </div>
    </footer>

    <!-- Back to Top -->
    <button id="backToTop" class="back-to-top">
        <i class="fas fa-arrow-up"></i>
    </button>

    <script>
        // Mobile Menu Toggle
        document.querySelector('.mobile-menu-btn').addEventListener('click', function() {
            document.querySelector('.nav-links').classList.toggle('active');
        });

        // Back to Top Button
        const backToTop = document.getElementById('backToTop');
        window.addEventListener('scroll', () => {
            if (window.scrollY > 300) {
                backToTop.classList.add('visible');
            } else {
                backToTop.classList.remove('visible');
            }
        });
        backToTop.addEventListener('click', () => {
            window.scrollTo({ top: 0, behavior: 'smooth' });
        });

        // Smooth Scroll
        document.querySelectorAll('a[href^="#"]').forEach(anchor => {
            anchor.addEventListener('click', function(e) {
                e.preventDefault();
                const target = document.querySelector(this.getAttribute('href'));
                if (target) {
                    target.scrollIntoView({ behavior: 'smooth' });
                }
            });
        });
    </script>
</body>
</html>