<?php
require_once 'config.php';

if (isLoggedIn()) {
    header('Location: dashboard.php');
    exit;
}

$error = '';
$success = isset($_GET['registered']) ? 'Registration successful! Please login.' : '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = sanitizeInput($_POST['username']);
    $password = $_POST['password'];
    
    if (empty($username) || empty($password)) {
        $error = 'Please fill all fields';
    } else {
        $users = readJSON(USERS_FILE);
        foreach ($users as $user) {
            if ($user['username'] === $username && password_verify($password, $user['password'])) {
                $_SESSION['sumal_user_id'] = $user['id'];
                $_SESSION['sumal_username'] = $user['username'];
                logActivity($username, "User logged in");
                header('Location: dashboard.php');
                exit;
            }
        }
        $error = 'Invalid credentials';
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>Login - Sumal Osiant Lookup</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="style.css">
    <style>
        .login-container {
            min-height: 100vh;
            display: flex;
            flex-direction: column;
            padding: 20px;
            background: var(--sumal-gradient);
            position: relative;
            overflow: hidden;
        }
        
        .login-header {
            text-align: center;
            padding: 40px 0 20px;
            animation: fade-down 0.8s ease;
        }
        
        .login-form-container {
            background: rgba(255,255,255,0.95);
            backdrop-filter: blur(20px);
            border-radius: 24px;
            padding: 30px;
            margin: auto;
            width: 100%;
            max-width: 400px;
            animation: slide-up 0.6s ease;
            box-shadow: 0 20px 60px rgba(0,0,0,0.1);
        }
        
        @keyframes fade-down {
            from { opacity: 0; transform: translateY(-30px); }
            to { opacity: 1; transform: translateY(0); }
        }
        
        @keyframes slide-up {
            from { opacity: 0; transform: translateY(30px); }
            to { opacity: 1; transform: translateY(0); }
        }
        
        .form-group {
            margin-bottom: 24px;
        }
        
        .form-label {
            display: block;
            margin-bottom: 8px;
            color: var(--sumal-dark);
            font-weight: 500;
        }
        
        .password-wrapper {
            position: relative;
        }
        
        .toggle-password {
            position: absolute;
            right: 15px;
            top: 50%;
            transform: translateY(-50%);
            background: none;
            border: none;
            color: var(--sumal-gray);
            cursor: pointer;
            padding: 5px;
        }
        
        .forgot-link {
            display: block;
            text-align: center;
            color: var(--sumal-primary);
            text-decoration: none;
            margin: 20px 0;
            font-size: 0.9rem;
        }
        
        .register-link {
            text-align: center;
            margin-top: 30px;
            color: var(--sumal-gray);
            font-size: 0.9rem;
        }
        
        .register-link a {
            color: var(--sumal-primary);
            text-decoration: none;
            font-weight: 500;
        }
    </style>
</head>
<body>
    <div class="login-container">
        <div class="sumal-bg-animation" id="particles"></div>
        
        <div class="login-header">
            <div class="sumal-logo">
                <i class="fas fa-search-location"></i>
                <span>Sumal Osiant</span>
            </div>
            <p style="color: white; margin-top: 10px; opacity: 0.9;">Secure Number Lookup System</p>
        </div>
        
        <div class="login-form-container">
            <h2 style="text-align: center; margin-bottom: 30px; color: var(--sumal-dark);">Welcome Back</h2>
            
            <?php if($error): ?>
            <div class="sumal-alert alert-error">
                <i class="fas fa-exclamation-circle"></i>
                <span><?php echo $error; ?></span>
            </div>
            <?php endif; ?>
            
            <?php if($success): ?>
            <div class="sumal-alert alert-success">
                <i class="fas fa-check-circle"></i>
                <span><?php echo $success; ?></span>
            </div>
            <?php endif; ?>
            
            <form method="POST" action="">
                <div class="form-group">
                    <label class="form-label">
                        <i class="fas fa-user" style="margin-right: 8px;"></i>
                        Username
                    </label>
                    <input type="text" name="username" class="sumal-input" 
                           placeholder="Enter your username" required>
                </div>
                
                <div class="form-group">
                    <label class="form-label">
                        <i class="fas fa-lock" style="margin-right: 8px;"></i>
                        Password
                    </label>
                    <div class="password-wrapper">
                        <input type="password" name="password" id="password" 
                               class="sumal-input" placeholder="Enter your password" required>
                        <button type="button" class="toggle-password" onclick="togglePassword()">
                            <i class="fas fa-eye"></i>
                        </button>
                    </div>
                </div>
                
                <button type="submit" class="sumal-btn" style="width: 100%;">
                    <i class="fas fa-sign-in-alt"></i>
                    Sign In
                </button>
            </form>
            
            <a href="register.php" class="forgot-link">
                <i class="fas fa-user-plus"></i>
                Create New Account
            </a>
            
            <div class="register-link">
                Don't have an account? <a href="register.php">Register here</a>
            </div>
        </div>
        
        <div class="sumal-footer">
            <div class="copyright">© <?php echo date('Y'); ?> Sumal Osiant Lookup System</div>
            <div class="developer">Developed by <span>Sumal Osiant</span></div>
        </div>
    </div>
    
    <script>
        // Create floating particles
        function createParticles() {
            const container = document.getElementById('particles');
            for(let i = 0; i < 15; i++) {
                const particle = document.createElement('div');
                particle.className = 'sumal-particle';
                particle.style.width = Math.random() * 100 + 50 + 'px';
                particle.style.height = particle.style.width;
                particle.style.left = Math.random() * 100 + '%';
                particle.style.top = Math.random() * 100 + '%';
                particle.style.animationDelay = Math.random() * 20 + 's';
                particle.style.opacity = Math.random() * 0.1 + 0.05;
                container.appendChild(particle);
            }
        }
        
        // Toggle password visibility
        function togglePassword() {
            const password = document.getElementById('password');
            const icon = document.querySelector('.toggle-password i');
            if(password.type === 'password') {
                password.type = 'text';
                icon.className = 'fas fa-eye-slash';
            } else {
                password.type = 'password';
                icon.className = 'fas fa-eye';
            }
        }
        
        // Form submission animation
        document.querySelector('form').addEventListener('submit', function(e) {
            const btn = this.querySelector('.sumal-btn');
            const originalHTML = btn.innerHTML;
            btn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Authenticating...';
            btn.disabled = true;
            
            setTimeout(() => {
                btn.innerHTML = originalHTML;
                btn.disabled = false;
            }, 3000);
        });
        
        // Initialize
        document.addEventListener('DOMContentLoaded', function() {
            createParticles();
            document.querySelector('input[name="username"]').focus();
        });
    </script>
</body>
</html>