<?php
require_once 'config.php';
requireLogin();

$username = $_SESSION['sumal_username'];
$error = '';
$success = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action'])) {
    if ($_POST['action'] === 'change_password') {
        $current = $_POST['current_password'];
        $new = $_POST['new_password'];
        $confirm = $_POST['confirm_password'];
        
        if (empty($current) || empty($new)) {
            $error = 'All password fields are required';
        } elseif ($new !== $confirm) {
            $error = 'New passwords do not match';
        } elseif (strlen($new) < 6) {
            $error = 'New password must be at least 6 characters';
        } else {
            $users = readJSON(USERS_FILE);
            $updated = false;
            
            foreach ($users as &$user) {
                if ($user['username'] === $username && password_verify($current, $user['password'])) {
                    $user['password'] = password_hash($new, PASSWORD_DEFAULT);
                    $updated = true;
                    break;
                }
            }
            
            if ($updated) {
                writeJSON(USERS_FILE, $users);
                logActivity($username, "Password changed");
                $success = 'Password changed successfully';
            } else {
                $error = 'Current password is incorrect';
            }
        }
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Profile - Sumal Osiant</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="style.css">
</head>
<body>
    <div class="dashboard-header">
        <div class="container">
            <a href="dashboard.php" style="color: white; text-decoration: none; display: flex; align-items: center; gap: 10px;">
                <i class="fas fa-arrow-left"></i>
                <span>Back</span>
            </a>
            <h1 style="margin-top: 20px; font-size: 1.8rem;">My Profile</h1>
        </div>
    </div>
    
    <div class="container">
        <div class="sumal-card" style="margin: 20px;">
            <div class="user-info" style="margin-bottom: 30px;">
                <div class="user-avatar" style="background: var(--sumal-gradient);">
                    <i class="fas fa-user"></i>
                </div>
                <div>
                    <h2 style="font-size: 1.5rem;"><?php echo htmlspecialchars($username); ?></h2>
                    <p style="color: var(--sumal-gray);">Premium Member</p>
                </div>
            </div>
            
            <?php if($error): ?>
            <div class="sumal-alert alert-error">
                <i class="fas fa-exclamation-circle"></i>
                <span><?php echo $error; ?></span>
            </div>
            <?php endif; ?>
            
            <?php if($success): ?>
            <div class="sumal-alert alert-success">
                <i class="fas fa-check-circle"></i>
                <span><?php echo $success; ?></span>
            </div>
            <?php endif; ?>
            
            <h3 style="margin-bottom: 20px; color: var(--sumal-dark);">
                <i class="fas fa-lock"></i> Change Password
            </h3>
            
            <form method="POST" action="">
                <input type="hidden" name="action" value="change_password">
                
                <div style="margin-bottom: 20px;">
                    <input type="password" name="current_password" class="sumal-input" 
                           placeholder="Current Password" required>
                </div>
                
                <div style="margin-bottom: 20px;">
                    <input type="password" name="new_password" class="sumal-input" 
                           placeholder="New Password" required>
                </div>
                
                <div style="margin-bottom: 25px;">
                    <input type="password" name="confirm_password" class="sumal-input" 
                           placeholder="Confirm New Password" required>
                </div>
                
                <button type="submit" class="sumal-btn">
                    <i class="fas fa-key"></i>
                    Update Password
                </button>
            </form>
        </div>
        
        <div class="sumal-card" style="margin: 20px;">
            <h3 style="margin-bottom: 20px; color: var(--sumal-dark);">
                <i class="fas fa-info-circle"></i> Account Information
            </h3>
            
            <div class="result-item">
                <div class="result-icon">
                    <i class="fas fa-user"></i>
                </div>
                <div class="result-content">
                    <span class="result-label">Username</span>
                    <span class="result-value"><?php echo htmlspecialchars($username); ?></span>
                </div>
            </div>
            
            <div class="result-item">
                <div class="result-icon">
                    <i class="fas fa-calendar"></i>
                </div>
                <div class="result-content">
                    <span class="result-label">Member Since</span>
                    <span class="result-value"><?php echo date('F Y'); ?></span>
                </div>
            </div>
            
            <div class="result-item">
                <div class="result-icon">
                    <i class="fas fa-shield-alt"></i>
                </div>
                <div class="result-content">
                    <span class="result-label">Account Type</span>
                    <span class="result-value">Premium</span>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Mobile Navigation -->
    <nav class="mobile-nav">
        <a href="dashboard.php" class="nav-item">
            <i class="fas fa-search"></i>
            <span>Search</span>
        </a>
        <a href="history.php" class="nav-item">
            <i class="fas fa-history"></i>
            <span>History</span>
        </a>
        <a href="profile.php" class="nav-item active">
            <i class="fas fa-user"></i>
            <span>Profile</span>
        </a>
        <a href="logout.php" class="nav-item">
            <i class="fas fa-sign-out-alt"></i>
            <span>Logout</span>
        </a>
    </nav>
</body>
</html>