<?php
// VIP Premium Lookup Bot v4.6 FIXED - API ERROR RESOLVED
declare(strict_types=1);
error_reporting(E_ALL);
ini_set('display_errors', '0');
ini_set('log_errors', '1');
ini_set('error_log', __DIR__ . '/php_errors.log');
ini_set('memory_limit', '256M');
date_default_timezone_set('Asia/Kolkata');
set_time_limit(0);
ignore_user_abort(true);

### ==================== CONFIGURATION ====================
define('BOT_TOKEN', '8207164765:AAHRec9w761VzYOvdQKvB3vRANuy3BlpyfE');
define('API_URL', 'https://anishexploits.site/api/api.php?key=anish&num=');
define('DEVELOPER', '@am_i_agent');
define('SUPPORT_USER', '@Hababia');
define('SUPPORT_USER_2', '@Giftait');
define('COPYRIGHT', '© 2024 Sumal Dev. All Rights Reserved.');
define('YOUR_UPI_ID', 'sumal.somu@ptyes');
define('UPI_NAME', 'SOMU SUMAL');
define('QR_CODE_IMAGE', 'https://files.catbox.moe/lmal2k.jpg');
define('RATE_PER_RUPEE', 1);
define('MIN_PAYMENT', 10);
define('FREE_LOOKUPS', 3);
define('REFERRAL_BONUS', 10);
define('BACKUP_CHANNEL', '@numberseinformation');
define('BROADCAST_BATCH_SIZE', 25);
define('BROADCAST_DELAY_MS', 40);
define('ADMIN_IDS', [8137611408]);

// Broadcast file paths
define('BROADCAST_QUEUE_FILE', __DIR__ . '/broadcast_queue.json');
define('BROADCAST_LOCK_FILE', __DIR__ . '/broadcast.lock');
define('BROADCAST_PROGRESS_FILE', __DIR__ . '/broadcast_progress.json');

### ==================== DATABASE ====================
$dbFile = __DIR__ . '/vip_bot.db';
try {
    $pdo = new PDO('sqlite:' . $dbFile, null, null, [
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
        PDO::ATTR_PERSISTENT => true
    ]);
    $pdo->exec("PRAGMA journal_mode = WAL");
    $pdo->exec("PRAGMA synchronous = NORMAL");
    $pdo->exec("PRAGMA cache_size = 10000");
} catch (PDOException $e) {
    log_debug("DB Error: " . $e->getMessage());
    http_response_code(200);
    exit;
}

// Initialize Tables
$initSql = [
    "CREATE TABLE IF NOT EXISTS users (
        user_id INTEGER PRIMARY KEY,
        username TEXT,
        first_name TEXT,
        join_date DATETIME DEFAULT CURRENT_TIMESTAMP,
        free_used INTEGER DEFAULT 0,
        premium_balance INTEGER DEFAULT 0,
        referral_code TEXT UNIQUE,
        referred_by TEXT,
        referrals INTEGER DEFAULT 0,
        is_banned INTEGER DEFAULT 0
    )",
    "CREATE TABLE IF NOT EXISTS lookups (
        id INTEGER PRIMARY KEY AUTOINCREMENT,
        user_id INTEGER,
        phone_number TEXT,
        timestamp DATETIME DEFAULT CURRENT_TIMESTAMP
    )",
    "CREATE TABLE IF NOT EXISTS payments (
        id INTEGER PRIMARY KEY AUTOINCREMENT,
        user_id INTEGER,
        username TEXT,
        amount INTEGER,
        lookups INTEGER,
        utr_number TEXT,
        screenshot_file_id TEXT,
        status TEXT DEFAULT 'pending',
        admin_note TEXT,
        created_at DATETIME DEFAULT CURRENT_TIMESTAMP,
        processed_at DATETIME,
        processed_by INTEGER
    )",
    "CREATE TABLE IF NOT EXISTS referrals (
        id INTEGER PRIMARY KEY AUTOINCREMENT,
        referrer_id INTEGER,
        referred_id INTEGER,
        rewarded INTEGER DEFAULT 0,
        timestamp DATETIME DEFAULT CURRENT_TIMESTAMP
    )",
    "CREATE TABLE IF NOT EXISTS sessions (
        user_id INTEGER PRIMARY KEY,
        step TEXT,
        data TEXT,
        updated_at DATETIME DEFAULT CURRENT_TIMESTAMP
    )",
    "CREATE TABLE IF NOT EXISTS processed_updates (
        update_id INTEGER PRIMARY KEY,
        processed_at DATETIME DEFAULT CURRENT_TIMESTAMP
    )",
    "CREATE INDEX IF NOT EXISTS idx_users_referral ON users(referral_code)",
    "CREATE INDEX IF NOT EXISTS idx_payments_status ON payments(status)",
    "CREATE INDEX IF NOT EXISTS idx_lookups_user ON lookups(user_id)"
];

foreach ($initSql as $sql) {
    try {
        $pdo->exec($sql);
    } catch (PDOException $e) {}
}

// Periodic cleanup
if (mt_rand(1, 100) === 1) {
    try {
        $pdo->exec("DELETE FROM processed_updates WHERE processed_at < datetime('now', '-3 days')");
        $pdo->exec("DELETE FROM sessions WHERE updated_at < datetime('now', '-2 hours')");
    } catch (Exception $e) {}
}

### ==================== USER CACHE ====================
$userCache = [];

function clearUserCache($user_id = null) {
    global $userCache;
    if ($user_id === null) {
        $userCache = [];
    } else {
        unset($userCache[$user_id]);
    }
}

### ==================== HELPER FUNCTIONS ====================
function log_debug($msg) {
    @file_put_contents(__DIR__ . '/bot_debug.log', date('[Y-m-d H:i:s] ') . $msg . PHP_EOL, FILE_APPEND | LOCK_EX);
}

function escapeMarkdown($text) {
    return str_replace(['_', '*', '`', '['], ['\\_', '\\*', '\\`', '\\['], $text ?? '');
}

function apiRequest($method, $params = []) {
    $url = "https://api.telegram.org/bot" . BOT_TOKEN . "/" . $method;
    $ch = curl_init();
    curl_setopt_array($ch, [
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_CONNECTTIMEOUT => 5,
        CURLOPT_TIMEOUT => 30,
        CURLOPT_SSL_VERIFYPEER => true,
        CURLOPT_HTTPHEADER => ['Content-Type: application/json'],
        CURLOPT_POSTFIELDS => json_encode($params),
        CURLOPT_ENCODING => 'gzip'
    ]);
    $res = curl_exec($ch);
    $err = curl_error($ch);
    curl_close($ch);
    
    if ($res === false) {
        log_debug("CURL Error [{$method}]: $err");
        return ['ok' => false, 'error' => $err];
    }
    return json_decode($res, true) ?: ['ok' => false];
}

function sendMessage($chat_id, $text, $extra = []) {
    $params = array_merge([
        'chat_id' => $chat_id,
        'text' => $text,
        'parse_mode' => 'Markdown',
        'disable_web_page_preview' => true
    ], $extra);
    return apiRequest('sendMessage', $params);
}

function sendBroadcastMessage($chat_id, $text) {
    $params = [
        'chat_id' => $chat_id,
        'text' => $text,
        'disable_web_page_preview' => true
    ];
    return apiRequest('sendMessage', $params);
}

function sendPhoto($chat_id, $photo, $caption = null, $reply_markup = null) {
    $params = ['chat_id' => $chat_id, 'photo' => $photo, 'parse_mode' => 'Markdown'];
    if ($caption) $params['caption'] = $caption;
    if ($reply_markup) $params['reply_markup'] = $reply_markup;
    return apiRequest('sendPhoto', $params);
}

function answerCallback($id, $text = null, $alert = false) {
    $params = ['callback_query_id' => $id, 'show_alert' => $alert];
    if ($text) $params['text'] = $text;
    return apiRequest('answerCallbackQuery', $params);
}

function editMessageText($chat_id, $msg_id, $text, $markup = null) {
    $params = ['chat_id' => $chat_id, 'message_id' => $msg_id, 'text' => $text, 'parse_mode' => 'Markdown'];
    if ($markup) $params['reply_markup'] = $markup;
    return apiRequest('editMessageText', $params);
}

function editMessageCaption($chat_id, $msg_id, $caption, $markup = null) {
    $params = ['chat_id' => $chat_id, 'message_id' => $msg_id, 'caption' => $caption, 'parse_mode' => 'Markdown'];
    if ($markup) $params['reply_markup'] = $markup;
    return apiRequest('editMessageCaption', $params);
}

function isAdmin($user_id) {
    return in_array(intval($user_id), ADMIN_IDS, true);
}

function generateReferralCode($len = 8) {
    return substr(str_shuffle('ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789'), 0, $len);
}

### ==================== BROADCAST SYSTEM ====================

function acquireBroadcastLock($admin_id) {
    $lockFile = BROADCAST_LOCK_FILE;
    
    if (file_exists($lockFile)) {
        $lockData = @json_decode(file_get_contents($lockFile), true);
        if ($lockData && isset($lockData['time'])) {
            $lockAge = time() - $lockData['time'];
            if ($lockAge < 300) {
                return false;
            }
        }
        @unlink($lockFile);
    }
    
    $data = ['admin_id' => $admin_id, 'time' => time()];
    return file_put_contents($lockFile, json_encode($data), LOCK_EX) !== false;
}

function releaseBroadcastLock() {
    @unlink(BROADCAST_LOCK_FILE);
}

function isBroadcastLocked() {
    if (!file_exists(BROADCAST_LOCK_FILE)) {
        return false;
    }
    $lockData = @json_decode(file_get_contents(BROADCAST_LOCK_FILE), true);
    if (!$lockData || !isset($lockData['time'])) {
        return false;
    }
    return (time() - $lockData['time']) < 300;
}

function queueBroadcast($pdo, $admin_id, $message, $chat_id) {
    $users = $pdo->query("SELECT user_id FROM users WHERE is_banned = 0")->fetchAll(PDO::FETCH_COLUMN);
    $total = count($users);
    
    if ($total === 0) {
        sendMessage($chat_id, "❌ No users to broadcast");
        return false;
    }
    
    $queueData = [
        'admin_id' => $admin_id,
        'chat_id' => $chat_id,
        'message' => $message,
        'users' => $users,
        'total' => $total,
        'current_index' => 0,
        'success' => 0,
        'failed' => 0,
        'blocked' => 0,
        'start_time' => time(),
        'status_msg_id' => null,
        'created_at' => date('Y-m-d H:i:s')
    ];
    
    if (file_put_contents(BROADCAST_QUEUE_FILE, json_encode($queueData), LOCK_EX) === false) {
        sendMessage($chat_id, "❌ Failed to create broadcast queue");
        return false;
    }
    
    $status = sendMessage($chat_id, "━━━━━━━━━━━━━━━━━━━━━\n📢 *BROADCAST QUEUED*\n━━━━━━━━━━━━━━━━━━━━━\n\n👥 Total: {$total} users\n⏳ Starting...\n\n━━━━━━━━━━━━━━━━━━━━━");
    
    if ($status['ok'] ?? false) {
        $queueData['status_msg_id'] = $status['result']['message_id'];
        file_put_contents(BROADCAST_QUEUE_FILE, json_encode($queueData), LOCK_EX);
    }
    
    log_debug("BROADCAST QUEUED: {$total} users by admin {$admin_id}");
    return true;
}

function getBroadcastProgress() {
    if (!file_exists(BROADCAST_QUEUE_FILE)) {
        return null;
    }
    return @json_decode(file_get_contents(BROADCAST_QUEUE_FILE), true);
}

function updateBroadcastProgress($data) {
    return file_put_contents(BROADCAST_QUEUE_FILE, json_encode($data), LOCK_EX) !== false;
}

function processBroadcastBatch() {
    $progress = getBroadcastProgress();
    if (!$progress) {
        releaseBroadcastLock();
        return false;
    }
    
    if (!acquireBroadcastLock($progress['admin_id'])) {
        log_debug("BROADCAST: Could not acquire lock");
        return false;
    }
    
    $progress = getBroadcastProgress();
    if (!$progress) {
        releaseBroadcastLock();
        return false;
    }
    
    $users = $progress['users'];
    $total = $progress['total'];
    $currentIndex = $progress['current_index'];
    $message = $progress['message'];
    $chatId = $progress['chat_id'];
    $msgId = $progress['status_msg_id'];
    
    if ($currentIndex >= $total) {
        finishBroadcast($progress);
        return true;
    }
    
    $batchEnd = min($currentIndex + BROADCAST_BATCH_SIZE, $total);
    $batchStart = $currentIndex;
    
    log_debug("BROADCAST BATCH: Processing {$batchStart} to {$batchEnd} of {$total}");
    
    for ($i = $currentIndex; $i < $batchEnd; $i++) {
        $uid = $users[$i];
        
        try {
            $result = sendBroadcastMessage($uid, $message);
            
            if ($result['ok'] ?? false) {
                $progress['success']++;
            } else {
                $err = $result['description'] ?? '';
                if (stripos($err, 'blocked') !== false || 
                    stripos($err, 'deactivated') !== false || 
                    stripos($err, 'not found') !== false ||
                    stripos($err, 'user is deactivated') !== false) {
                    $progress['blocked']++;
                } else {
                    $progress['failed']++;
                }
            }
        } catch (Exception $e) {
            $progress['failed']++;
        }
        
        $progress['current_index'] = $i + 1;
        usleep(BROADCAST_DELAY_MS * 1000);
    }
    
    updateBroadcastProgress($progress);
    
    $processed = $progress['current_index'];
    $pct = round(($processed / $total) * 100, 1);
    $bar = str_repeat("▓", (int)($pct / 5)) . str_repeat("░", 20 - (int)($pct / 5));
    $elapsed = time() - $progress['start_time'];
    $rate = $processed > 0 ? $processed / max($elapsed, 1) : 0;
    $eta = $rate > 0 ? (int)(($total - $processed) / $rate) : 0;
    
    $statusText = "━━━━━━━━━━━━━━━━━━━━━\n📢 *BROADCASTING...*\n━━━━━━━━━━━━━━━━━━━━━\n\n";
    $statusText .= "📊 Progress: {$pct}%\n`{$bar}`\n\n";
    $statusText .= "👥 Total: {$total}\n";
    $statusText .= "✅ Success: {$progress['success']}\n";
    $statusText .= "❌ Failed: {$progress['failed']}\n";
    $statusText .= "🚫 Blocked: {$progress['blocked']}\n\n";
    $statusText .= "⏱️ ETA: {$eta}s | Rate: " . round($rate, 1) . "/s\n\n━━━━━━━━━━━━━━━━━━━━━";
    
    if ($msgId) {
        editMessageText($chatId, $msgId, $statusText);
    }
    
    if ($progress['current_index'] >= $total) {
        finishBroadcast($progress);
        return true;
    }
    
    releaseBroadcastLock();
    return true;
}

function finishBroadcast($progress) {
    $total = $progress['total'];
    $success = $progress['success'];
    $failed = $progress['failed'];
    $blocked = $progress['blocked'];
    $chatId = $progress['chat_id'];
    $msgId = $progress['status_msg_id'];
    $elapsed = time() - $progress['start_time'];
    $successRate = $total > 0 ? round(($success / $total) * 100, 1) : 0;
    
    $report = "━━━━━━━━━━━━━━━━━━━━━\n✅ *BROADCAST COMPLETE*\n━━━━━━━━━━━━━━━━━━━━━\n\n";
    $report .= "📊 *FINAL STATS*\n\n";
    $report .= "👥 Total: {$total}\n";
    $report .= "✅ Delivered: {$success}\n";
    $report .= "❌ Failed: {$failed}\n";
    $report .= "🚫 Blocked: {$blocked}\n\n";
    $report .= "📈 Success Rate: {$successRate}%\n";
    $report .= "⏱️ Time: {$elapsed}s\n\n━━━━━━━━━━━━━━━━━━━━━\n\n📅 " . date('d M Y, h:i A');
    
    if ($msgId) {
        editMessageText($chatId, $msgId, $report);
    } else {
        sendMessage($chatId, $report);
    }
    
    @unlink(BROADCAST_QUEUE_FILE);
    releaseBroadcastLock();
    
    log_debug("BROADCAST COMPLETED: {$total} users, {$success} success, {$failed} failed, {$blocked} blocked, {$elapsed}s");
}

function checkPendingBroadcast() {
    $progress = getBroadcastProgress();
    if (!$progress) {
        return false;
    }
    
    $lastActivity = $progress['start_time'];
    if (isset($progress['last_activity'])) {
        $lastActivity = $progress['last_activity'];
    }
    
    if ((time() - $lastActivity) > 600) {
        log_debug("BROADCAST: Stale broadcast detected, cleaning up");
        @unlink(BROADCAST_QUEUE_FILE);
        releaseBroadcastLock();
        return false;
    }
    
    return processBroadcastBatch();
}

function cancelBroadcast($chat_id) {
    $progress = getBroadcastProgress();
    
    if (!$progress) {
        sendMessage($chat_id, "❌ No broadcast in progress");
        return;
    }
    
    $processed = $progress['current_index'];
    $total = $progress['total'];
    $success = $progress['success'];
    
    @unlink(BROADCAST_QUEUE_FILE);
    releaseBroadcastLock();
    
    sendMessage($chat_id, "━━━━━━━━━━━━━━━━━━━━━\n⛔ *BROADCAST CANCELLED*\n━━━━━━━━━━━━━━━━━━━━━\n\n📊 Processed: {$processed}/{$total}\n✅ Delivered: {$success}");
}

function getBroadcastStatus($chat_id) {
    $progress = getBroadcastProgress();
    
    if (!$progress) {
        sendMessage($chat_id, "ℹ️ No broadcast in progress");
        return;
    }
    
    $processed = $progress['current_index'];
    $total = $progress['total'];
    $success = $progress['success'];
    $failed = $progress['failed'];
    $blocked = $progress['blocked'];
    $pct = round(($processed / $total) * 100, 1);
    
    sendMessage($chat_id, "━━━━━━━━━━━━━━━━━━━━━\n📢 *BROADCAST STATUS*\n━━━━━━━━━━━━━━━━━━━━━\n\n📊 Progress: {$pct}%\n👥 Processed: {$processed}/{$total}\n✅ Success: {$success}\n❌ Failed: {$failed}\n🚫 Blocked: {$blocked}");
}

### ==================== DATABASE FUNCTIONS ====================
function getUser($pdo, $user_id, $fresh = false) {
    global $userCache;
    if (!$fresh && isset($userCache[$user_id])) {
        return $userCache[$user_id];
    }
    $stmt = $pdo->prepare("SELECT * FROM users WHERE user_id = ?");
    $stmt->execute([$user_id]);
    $result = $stmt->fetch();
    $userCache[$user_id] = $result ?: null;
    return $userCache[$user_id];
}

function createUser($pdo, $user_id, $username, $first_name) {
    global $userCache;
    $exists = getUser($pdo, $user_id, true);
    if ($exists) {
        $pdo->prepare("UPDATE users SET username = ?, first_name = ? WHERE user_id = ?")
            ->execute([$username, $first_name, $user_id]);
        clearUserCache($user_id);
        return $exists['referral_code'];
    }
    $code = generateReferralCode();
    $pdo->prepare("INSERT INTO users (user_id, username, first_name, referral_code) VALUES (?,?,?,?)")
        ->execute([$user_id, $username, $first_name, $code]);
    clearUserCache($user_id);
    return $code;
}

function getAvailableLookups($pdo, $user_id) {
    $u = getUser($pdo, $user_id, true);
    if (!$u) return 0;
    return max(0, FREE_LOOKUPS - intval($u['free_used'])) + intval($u['premium_balance']);
}

function useLookup($pdo, $user_id, $phone) {
    $u = getUser($pdo, $user_id, true);
    if (!$u || $u['is_banned'] == 1 || getAvailableLookups($pdo, $user_id) <= 0) return false;
    
    $pdo->beginTransaction();
    try {
        $pdo->prepare("INSERT INTO lookups (user_id, phone_number) VALUES (?,?)")->execute([$user_id, $phone]);
        
        if (intval($u['free_used']) < FREE_LOOKUPS) {
            $pdo->prepare("UPDATE users SET free_used = free_used + 1 WHERE user_id = ?")->execute([$user_id]);
        } else {
            $pdo->prepare("UPDATE users SET premium_balance = premium_balance - 1 WHERE user_id = ?")->execute([$user_id]);
        }
        
        $pdo->commit();
        clearUserCache($user_id);
        return true;
    } catch (Exception $e) {
        $pdo->rollBack();
        return false;
    }
}

function addPremium($pdo, $user_id, $lookups) {
    global $userCache;
    $user = getUser($pdo, $user_id, true);
    if (!$user) return false;
    $stmt = $pdo->prepare("UPDATE users SET premium_balance = premium_balance + ? WHERE user_id = ?");
    $stmt->execute([$lookups, $user_id]);
    clearUserCache($user_id);
    return $stmt->rowCount() > 0;
}

function removePremium($pdo, $user_id, $lookups) {
    global $userCache;
    $user = getUser($pdo, $user_id, true);
    if (!$user || intval($user['premium_balance']) < $lookups) return false;
    $stmt = $pdo->prepare("UPDATE users SET premium_balance = premium_balance - ? WHERE user_id = ?");
    $stmt->execute([$lookups, $user_id]);
    clearUserCache($user_id);
    return $stmt->rowCount() > 0;
}

function createPayment($pdo, $user_id, $username, $amount, $lookups, $utr, $screenshot) {
    $stmt = $pdo->prepare("INSERT INTO payments (user_id, username, amount, lookups, utr_number, screenshot_file_id) VALUES (?,?,?,?,?,?)");
    $stmt->execute([$user_id, $username, $amount, $lookups, $utr, $screenshot]);
    return (int)$pdo->lastInsertId();
}

function getPendingPayments($pdo) {
    return $pdo->query("SELECT * FROM payments WHERE status = 'pending' ORDER BY created_at DESC")->fetchAll();
}

function getPayment($pdo, $id) {
    $stmt = $pdo->prepare("SELECT * FROM payments WHERE id = ?");
    $stmt->execute([$id]);
    return $stmt->fetch();
}

function approvePayment($pdo, $payment_id, $admin_id, $custom = null) {
    $p = getPayment($pdo, $payment_id);
    if (!$p || $p['status'] !== 'pending') return null;
    
    $final = $custom !== null ? intval($custom) : intval($p['lookups']);
    
    $pdo->beginTransaction();
    try {
        $pdo->prepare("UPDATE payments SET status='approved', lookups=?, processed_at=CURRENT_TIMESTAMP, processed_by=? WHERE id=?")
            ->execute([$final, $admin_id, $payment_id]);
        
        $pdo->prepare("UPDATE users SET premium_balance = premium_balance + ? WHERE user_id = ?")
            ->execute([$final, intval($p['user_id'])]);
        
        $pdo->commit();
        clearUserCache(intval($p['user_id']));
        
        $p['lookups'] = $final;
        $p['status'] = 'approved';
        return $p;
    } catch (Exception $e) {
        $pdo->rollBack();
        return null;
    }
}

function rejectPayment($pdo, $payment_id, $admin_id, $reason = '') {
    $p = getPayment($pdo, $payment_id);
    if (!$p || $p['status'] !== 'pending') return null;
    
    $pdo->prepare("UPDATE payments SET status='rejected', admin_note=?, processed_at=CURRENT_TIMESTAMP, processed_by=? WHERE id=?")
        ->execute([$reason, $admin_id, $payment_id]);
    
    $p['status'] = 'rejected';
    return $p;
}

function addReferral($pdo, $referrer_id, $referred_id) {
    global $userCache;
    
    $stmt = $pdo->prepare("SELECT 1 FROM referrals WHERE referrer_id=? AND referred_id=?");
    $stmt->execute([$referrer_id, $referred_id]);
    if ($stmt->fetch()) return false;
    
    $stmt = $pdo->prepare("SELECT referred_by FROM users WHERE user_id = ?");
    $stmt->execute([$referred_id]);
    $row = $stmt->fetch();
    if ($row && !empty($row['referred_by'])) return false;
    
    $pdo->beginTransaction();
    try {
        $pdo->prepare("INSERT INTO referrals (referrer_id, referred_id, rewarded) VALUES (?,?,1)")
            ->execute([$referrer_id, $referred_id]);
        
        $pdo->prepare("UPDATE users SET referrals = referrals + 1, premium_balance = premium_balance + ? WHERE user_id = ?")
            ->execute([REFERRAL_BONUS, $referrer_id]);
        
        $pdo->prepare("UPDATE users SET referred_by = ? WHERE user_id = ?")
            ->execute([$referrer_id, $referred_id]);
        
        $pdo->commit();
        clearUserCache($referrer_id);
        clearUserCache($referred_id);
        return true;
    } catch (Exception $e) {
        $pdo->rollBack();
        return false;
    }
}

function getAllUsers($pdo) {
    return $pdo->query("SELECT user_id FROM users WHERE is_banned = 0")->fetchAll(PDO::FETCH_COLUMN);
}

function getTotalUsers($pdo) {
    return (int)$pdo->query("SELECT COUNT(*) FROM users")->fetchColumn();
}

function getTotalLookups($pdo) {
    return (int)$pdo->query("SELECT COUNT(*) FROM lookups")->fetchColumn();
}

function banUser($pdo, $id) {
    $pdo->prepare("UPDATE users SET is_banned = 1 WHERE user_id = ?")->execute([$id]);
    clearUserCache($id);
}

function unbanUser($pdo, $id) {
    $pdo->prepare("UPDATE users SET is_banned = 0 WHERE user_id = ?")->execute([$id]);
    clearUserCache($id);
}

function getUserLookupCount($pdo, $user_id) {
    $stmt = $pdo->prepare("SELECT COUNT(*) FROM lookups WHERE user_id = ?");
    $stmt->execute([$user_id]);
    return (int)$stmt->fetchColumn();
}

function getUserPaymentStats($pdo, $user_id) {
    $stmt = $pdo->prepare("SELECT COUNT(*) as count, COALESCE(SUM(amount), 0) as total FROM payments WHERE user_id = ? AND status = 'approved'");
    $stmt->execute([$user_id]);
    return $stmt->fetch();
}

function markUpdateProcessed($pdo, $update_id) {
    try {
        $stmt = $pdo->prepare("INSERT OR IGNORE INTO processed_updates (update_id) VALUES (?)");
        $stmt->execute([$update_id]);
        return $stmt->rowCount() > 0;
    } catch (Exception $e) {
        return false;
    }
}

### ==================== PHONE LOOKUP - FIXED ====================
function validateNumber($s) {
    $clean = preg_replace('/\D/', '', $s);
    return strlen($clean) === 10 || (strlen($clean) === 12 && substr($clean, 0, 2) === '91');
}

function cleanNumber($s) {
    $clean = preg_replace('/\D/', '', $s);
    return strlen($clean) === 12 && substr($clean, 0, 2) === '91' ? substr($clean, 2) : substr($clean, 0, 10);
}

function fetchNumberInfo($num) {
    $clean = cleanNumber($num);
    if (strlen($clean) !== 10) {
        log_debug("API: Invalid number length - " . strlen($clean));
        return ['error' => 'Invalid number'];
    }
    
    $url = API_URL . urlencode($clean);
    log_debug("API Request: " . $url);
    
    // Try CURL first (more reliable)
    if (function_exists('curl_init')) {
        $ch = curl_init();
        curl_setopt_array($ch, [
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_CONNECTTIMEOUT => 10,
            CURLOPT_SSL_VERIFYPEER => false,
            CURLOPT_SSL_VERIFYHOST => false,
            CURLOPT_USERAGENT => 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36'
        ]);
        
        $res = curl_exec($ch);
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        $curlError = curl_error($ch);
        curl_close($ch);
        
        if ($res === false) {
            log_debug("CURL Error: " . $curlError);
            return ['error' => 'Connection failed'];
        }
        
        log_debug("API Response Code: " . $httpCode);
        log_debug("API Raw Response: " . substr($res, 0, 500));
        
        if ($httpCode !== 200) {
            log_debug("API HTTP Error: " . $httpCode);
            return ['error' => "API returned code {$httpCode}"];
        }
    } else {
        // Fallback to file_get_contents
        $ctx = stream_context_create([
            'http' => [
                'timeout' => 30,
                'method' => 'GET',
                'ignore_errors' => true,
                'user_agent' => 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36'
            ],
            'ssl' => [
                'verify_peer' => false,
                'verify_peer_name' => false
            ]
        ]);
        
        $res = @file_get_contents($url, false, $ctx);
        
        if ($res === false) {
            log_debug("file_get_contents failed");
            return ['error' => 'Connection failed'];
        }
        
        log_debug("API Raw Response: " . substr($res, 0, 500));
    }
    
    if (empty($res)) {
        log_debug("API: Empty response");
        return ['error' => 'Empty response from API'];
    }
    
    $j = json_decode($res, true);
    
    if ($j === null) {
        log_debug("JSON Decode Error: " . json_last_error_msg());
        log_debug("Response was: " . substr($res, 0, 200));
        return ['error' => 'Invalid JSON response'];
    }
    
    log_debug("API Parsed: " . print_r($j, true));
    
    // Handle different API response formats
    // Format 1: {"result": [...]}
    if (isset($j['result']) && is_array($j['result'])) {
        unset($j['credit']);
        return $j;
    }
    
    // Format 2: {"status": "success", "data": [...]}
    if (isset($j['status']) && $j['status'] === 'success' && isset($j['data'])) {
        return ['result' => is_array($j['data']) ? $j['data'] : [$j['data']]];
    }
    
    // Format 3: {"data": [...]}
    if (isset($j['data'])) {
        return ['result' => is_array($j['data']) ? $j['data'] : [$j['data']]];
    }
    
    // Format 4: Direct array
    if (isset($j[0]) && is_array($j[0])) {
        return ['result' => $j];
    }
    
    // Format 5: {"error": "..."} or {"message": "..."}
    if (isset($j['error'])) {
        log_debug("API Error: " . $j['error']);
        return ['error' => $j['error']];
    }
    
    if (isset($j['message'])) {
        log_debug("API Message: " . $j['message']);
        return ['error' => $j['message']];
    }
    
    // Unknown format
    log_debug("Unknown API format: " . print_r($j, true));
    return ['error' => 'Unknown API response format'];
}

function formatResult($results) {
    if (!$results || !is_array($results) || count($results) === 0) {
        return "📭 *No Data Found*";
    }
    
    $output = "━━━━━━━━━━━━━━━━━━━━━\n🔍 *LOOKUP RESULTS*\n━━━━━━━━━━━━━━━━━━━━━\n\n";
    $fields = ['mobile'=>'📱','name'=>'👤','father_name'=>'👨‍👦','address'=>'🏠','alt_mobile'=>'📞','circle'=>'📍','id_number'=>'🆔','email'=>'📧'];
    
    $counter = 0;
    foreach ($results as $r) {
        if ($counter > 0) {
            $output .= "\n┅┅┅┅┅┅┅┅┅┅┅┅┅┅┅┅┅┅┅┅┅\n\n";
        }
        $counter++;
        $output .= "📊 *Result #{$counter}*\n\n";
        
        foreach ($fields as $k => $e) {
            if (isset($r[$k]) && !empty($r[$k])) {
                $output .= "{$e} `{$r[$k]}`\n";
            }
        }
    }
    
    return $output . "\n━━━━━━━━━━━━━━━━━━━━━";
}

### ==================== SESSION ====================
function sessionSet($pdo, $user_id, $step, $data = []) {
    $pdo->prepare("INSERT OR REPLACE INTO sessions (user_id, step, data, updated_at) VALUES (?,?,?,CURRENT_TIMESTAMP)")
        ->execute([$user_id, $step, json_encode($data)]);
}

function sessionGet($pdo, $user_id) {
    $stmt = $pdo->prepare("SELECT step, data FROM sessions WHERE user_id = ?");
    $stmt->execute([$user_id]);
    $r = $stmt->fetch();
    return $r ? ['step' => $r['step'], 'data' => json_decode($r['data'], true) ?: []] : null;
}

function sessionClear($pdo, $user_id) {
    $pdo->prepare("DELETE FROM sessions WHERE user_id = ?")->execute([$user_id]);
}

### ==================== KEYBOARDS ====================
function getMainMenuKeyboard() {
    return ['inline_keyboard' => [
        [['text' => '🔍 Start Lookup', 'callback_data' => 'lookup_now'], ['text' => '💎 Buy Credits', 'callback_data' => 'buy_menu']],
        [['text' => '💰 Balance', 'callback_data' => 'my_balance'], ['text' => '👥 Refer & Earn', 'callback_data' => 'referral_menu']],
        [['text' => '📊 Profile', 'callback_data' => 'my_profile'], ['text' => '❓ Help', 'callback_data' => 'help_menu']]
    ]];
}

function getBuyKeyboard() {
    return ['inline_keyboard' => [
        [['text' => '💵 ₹25 = 25 Lookups', 'callback_data' => 'quick_25']],
        [['text' => '💰 ₹50 = 50 Lookups', 'callback_data' => 'quick_50']],
        [['text' => '💎 ₹100 = 100 Lookups', 'callback_data' => 'quick_100']],
        [['text' => '⭐ ₹450 = 500 Lookups (BEST)', 'callback_data' => 'quick_450']],
        [['text' => '📝 Custom Amount', 'callback_data' => 'pay_custom']],
        [['text' => '🔙 Back', 'callback_data' => 'main_menu']]
    ]];
}

function getAdminKeyboard() {
    return ['inline_keyboard' => [
        [['text' => '📊 Stats', 'callback_data' => 'admin_stats'], ['text' => '⏳ Pending', 'callback_data' => 'admin_pending']],
        [['text' => '📢 Broadcast', 'callback_data' => 'admin_broadcast']],
        [['text' => '📋 BC Status', 'callback_data' => 'admin_bc_status']],
        [['text' => '🔙 Main Menu', 'callback_data' => 'main_menu']]
    ]];
}

function getLookupResultKeyboard() {
    return ['inline_keyboard' => [
        [['text' => '🔍 Another Lookup', 'callback_data' => 'lookup_now'], ['text' => '💎 Buy More', 'callback_data' => 'buy_menu']],
        [['text' => '🏠 Main Menu', 'callback_data' => 'main_menu']]
    ]];
}

### ==================== UI FUNCTIONS ====================
function sendStartMsg($pdo, $user_id, $chat_id) {
    $u = getUser($pdo, $user_id, true);
    if (!$u) {
        $u = ['first_name' => 'User', 'username' => '', 'free_used' => 0, 'premium_balance' => 0];
    }
    
    $avail = getAvailableLookups($pdo, $user_id);
    $name = $u['first_name'] ?: ($u['username'] ? "@{$u['username']}" : 'User');
    $free = max(0, FREE_LOOKUPS - intval($u['free_used']));
    $premium = intval($u['premium_balance']);
    
    $text = "━━━━━━━━━━━━━━━━━━━━━\n👋 *Welcome, {$name}!*\n━━━━━━━━━━━━━━━━━━━━━\n\n";
    $text .= "🤖 *VIP Number Lookup Bot*\n🔍 Get instant phone details\n\n";
    $text .= "━━━━━━━━━━━━━━━━━━━━━\n\n💰 *YOUR BALANCE*\n\n🆓 Free: {$free}/" . FREE_LOOKUPS . "\n💎 Premium: {$premium}\n📊 Total: *{$avail}*\n\n";
    $text .= "━━━━━━━━━━━━━━━━━━━━━\n\nUse buttons below 👇\n\n" . COPYRIGHT;
    
    sendMessage($chat_id, $text, ['reply_markup' => getMainMenuKeyboard()]);
}

function sendBuyMenu($chat_id) {
    $text = "━━━━━━━━━━━━━━━━━━━━━\n💎 *BUY PREMIUM LOOKUPS*\n━━━━━━━━━━━━━━━━━━━━━\n\n";
    $text .= "🎯 *Pricing*\n\n💵 Rate: ₹1 = 1 Lookup\n💰 Minimum: ₹" . MIN_PAYMENT . "\n⭐ Special: ₹450 = 500 🔥\n\n";
    $text .= "━━━━━━━━━━━━━━━━━━━━━\n\n💳 *Payment Method*\n\n🆔 UPI: `" . YOUR_UPI_ID . "`\n👤 Name: " . UPI_NAME . "\n\n━━━━━━━━━━━━━━━━━━━━━\n\nSelect package 👇";
    
    sendMessage($chat_id, $text, ['reply_markup' => getBuyKeyboard()]);
}

function sendBalance($pdo, $user_id, $chat_id) {
    $u = getUser($pdo, $user_id, true);
    if (!$u) {
        $u = ['free_used' => 0, 'premium_balance' => 0, 'referrals' => 0];
    }
    
    $free = max(0, FREE_LOOKUPS - intval($u['free_used']));
    $premium = intval($u['premium_balance']);
    $refs = intval($u['referrals'] ?? 0);
    
    $text = "━━━━━━━━━━━━━━━━━━━━━\n💰 *YOUR BALANCE*\n━━━━━━━━━━━━━━━━━━━━━\n\n";
    $text .= "🆓 Free: {$free}/" . FREE_LOOKUPS . "\n💎 Premium: {$premium}\n📊 Total: *" . ($free + $premium) . "*\n\n";
    $text .= "━━━━━━━━━━━━━━━━━━━━━\n\n👥 *REFERRALS*\n\n👤 Invited: {$refs}\n🎁 Earned: " . ($refs * REFERRAL_BONUS) . " Lookups\n\n━━━━━━━━━━━━━━━━━━━━━\n\n" . COPYRIGHT;
    
    $kb = ['inline_keyboard' => [
        [['text' => '💎 Buy More', 'callback_data' => 'buy_menu'], ['text' => '🔍 Lookup', 'callback_data' => 'lookup_now']],
        [['text' => '👥 Invite Friends', 'callback_data' => 'referral_menu']],
        [['text' => '🔙 Main Menu', 'callback_data' => 'main_menu']]
    ]];
    
    sendMessage($chat_id, $text, ['reply_markup' => $kb]);
}

function sendProfile($pdo, $user_id, $chat_id) {
    $u = getUser($pdo, $user_id, true);
    if (!$u) {
        sendMessage($chat_id, "❌ Profile not found. Please send /start first.");
        return;
    }
    
    $lookupCount = getUserLookupCount($pdo, $user_id);
    $paymentStats = getUserPaymentStats($pdo, $user_id);
    $paymentCount = (int)($paymentStats['count'] ?? 0);
    $totalSpent = (int)($paymentStats['total'] ?? 0);
    
    $freeLeft = max(0, FREE_LOOKUPS - intval($u['free_used']));
    $premium = intval($u['premium_balance']);
    $referrals = intval($u['referrals'] ?? 0);
    $earnedFromRefs = $referrals * REFERRAL_BONUS;
    
    $safeUsername = escapeMarkdown($u['username'] ?? '');
    
    $text = "━━━━━━━━━━━━━━━━━━━━━\n📊 *MY PROFILE*\n━━━━━━━━━━━━━━━━━━━━━\n\n";
    $text .= "👤 *Name:* {$u['first_name']}\n📝 *Username:* @{$safeUsername}\n🆔 *ID:* `{$user_id}`\n📅 *Joined:* {$u['join_date']}\n\n";
    $text .= "━━━━━━━━━━━━━━━━━━━━━\n\n💰 *BALANCE*\n\n🆓 Free: {$freeLeft}/" . FREE_LOOKUPS . "\n💎 Premium: {$premium}\n📊 Total: *" . ($freeLeft + $premium) . "*\n\n";
    $text .= "━━━━━━━━━━━━━━━━━━━━━\n\n📈 *STATS*\n\n🔍 Lookups: {$lookupCount}\n💳 Payments: {$paymentCount}\n💰 Spent: ₹{$totalSpent}\n👥 Referrals: {$referrals}\n🎁 Earned: {$earnedFromRefs}\n\n🔗 Code: `{$u['referral_code']}`";
    
    $kb = ['inline_keyboard' => [
        [['text' => '🔍 Lookup', 'callback_data' => 'lookup_now'], ['text' => '💎 Buy', 'callback_data' => 'buy_menu']],
        [['text' => '👥 Refer & Earn', 'callback_data' => 'referral_menu']],
        [['text' => '💳 Payment History', 'callback_data' => 'payment_history']],
        [['text' => '🔙 Main Menu', 'callback_data' => 'main_menu']]
    ]];
    
    sendMessage($chat_id, $text, ['reply_markup' => $kb]);
}

function sendReferralMenu($pdo, $user_id, $chat_id) {
    $u = getUser($pdo, $user_id, true);
    $code = $u['referral_code'] ?? 'ERROR';
    $refs = intval($u['referrals'] ?? 0);
    
    $me = apiRequest('getMe', []);
    $bot = $me['result']['username'] ?? 'bot';
    $link = "https://t.me/{$bot}?start={$code}";
    
    $text = "━━━━━━━━━━━━━━━━━━━━━\n👥 *REFER & EARN*\n━━━━━━━━━━━━━━━━━━━━━\n\n";
    $text .= "🎁 Earn FREE lookups!\n\n1️⃣ Share your link\n2️⃣ Friend joins\n3️⃣ You get +" . REFERRAL_BONUS . " lookups!\n\n";
    $text .= "🔗 *Your Link*\n`{$link}`\n\n🔢 Code: `{$code}`\n\n📊 Referrals: {$refs}\n🎁 Earned: " . ($refs * REFERRAL_BONUS);
    
    $kb = ['inline_keyboard' => [
        [['text' => '📤 Share Link', 'url' => "https://t.me/share/url?url=" . urlencode($link) . "&text=" . urlencode("🔍 Get FREE phone lookups!")]],
        [['text' => '🔙 Back', 'callback_data' => 'main_menu']]
    ]];
    
    sendMessage($chat_id, $text, ['reply_markup' => $kb]);
}

function sendHelpMenu($chat_id) {
    $text = "━━━━━━━━━━━━━━━━━━━━━\n❓ *HELP & SUPPORT*\n━━━━━━━━━━━━━━━━━━━━━\n\n";
    $text .= "📱 *How to use:*\n\n1️⃣ Click 'Start Lookup'\n2️⃣ Send 10-digit number\n3️⃣ Get instant results!\n\n";
    $text .= "💡 *Features:*\n\n🆓 " . FREE_LOOKUPS . " Free Lookups\n💎 Buy Credits\n👥 Refer & Earn\n⚡ Instant Results\n\n";
    $text .= "📞 *Support:*\n\n👨‍💼 " . SUPPORT_USER . "\n👨‍💼 " . SUPPORT_USER_2 . "\n\n" . COPYRIGHT;
    
    $kb = ['inline_keyboard' => [
        [['text' => '💬 Contact ' . SUPPORT_USER, 'url' => 'https://t.me/' . ltrim(SUPPORT_USER, '@')]],
        [['text' => '📢 Join Channel', 'url' => 'https://t.me/' . ltrim(BACKUP_CHANNEL, '@')]],
        [['text' => '🔙 Main Menu', 'callback_data' => 'main_menu']]
    ]];
    
    sendMessage($chat_id, $text, ['reply_markup' => $kb]);
}

function showPaymentHistory($pdo, $user_id, $chat_id) {
    $stmt = $pdo->prepare("SELECT * FROM payments WHERE user_id = ? ORDER BY created_at DESC LIMIT 10");
    $stmt->execute([$user_id]);
    $payments = $stmt->fetchAll();
    
    if (!$payments) {
        sendMessage($chat_id, "━━━━━━━━━━━━━━━━━━━━━\n💳 *PAYMENT HISTORY*\n━━━━━━━━━━━━━━━━━━━━━\n\n📭 No payments yet", 
            ['reply_markup' => ['inline_keyboard' => [[['text' => '💎 Buy Now', 'callback_data' => 'buy_menu']], [['text' => '🔙 Back', 'callback_data' => 'my_balance']]]]]);
        return;
    }
    
    $text = "━━━━━━━━━━━━━━━━━━━━━\n💳 *PAYMENT HISTORY*\n━━━━━━━━━━━━━━━━━━━━━\n\n";
    foreach ($payments as $p) {
        $emoji = $p['status'] === 'approved' ? '✅' : ($p['status'] === 'rejected' ? '❌' : '⏳');
        $text .= "🎫 #{$p['id']} {$emoji} " . strtoupper($p['status']) . "\n💰 ₹{$p['amount']} → 💎 {$p['lookups']}\n📅 {$p['created_at']}\n┅┅┅┅┅┅┅┅┅┅┅┅┅┅┅┅┅┅┅┅┅\n";
    }
    
    sendMessage($chat_id, $text, ['reply_markup' => ['inline_keyboard' => [[['text' => '💎 Buy More', 'callback_data' => 'buy_menu']], [['text' => '🔙 Main Menu', 'callback_data' => 'main_menu']]]]]);
}

function sendAdminPanel($chat_id) {
    $text = "━━━━━━━━━━━━━━━━━━━━━\n⚙️ *ADMIN PANEL*\n━━━━━━━━━━━━━━━━━━━━━\n\n";
    $text .= "/stats - Statistics\n/pending - Pending payments\n/broadcast - Send broadcast\n/bcstatus - Broadcast status\n/bccancel - Cancel broadcast\n";
    $text .= "/look [id] - View user\n/addlookup [id] [amt] - Add\n/remove [id] [amt] - Remove\n/ban [id] - Ban\n/unban [id] - Unban\n/testapi [number] - Test API";
    
    sendMessage($chat_id, $text, ['reply_markup' => getAdminKeyboard()]);
}

function sendAdminStats($pdo, $chat_id) {
    $users = getTotalUsers($pdo);
    $lookups = getTotalLookups($pdo);
    $pending = count(getPendingPayments($pdo));
    $approved = (int)$pdo->query("SELECT COUNT(*) FROM payments WHERE status = 'approved'")->fetchColumn();
    $rejected = (int)$pdo->query("SELECT COUNT(*) FROM payments WHERE status = 'rejected'")->fetchColumn();
    $revenue = (int)$pdo->query("SELECT COALESCE(SUM(amount), 0) FROM payments WHERE status = 'approved'")->fetchColumn();
    
    $text = "━━━━━━━━━━━━━━━━━━━━━\n📊 *BOT STATS*\n━━━━━━━━━━━━━━━━━━━━━\n\n";
    $text .= "👥 Users: *{$users}*\n🔍 Lookups: *{$lookups}*\n\n";
    $text .= "💰 *PAYMENTS*\n\n⏳ Pending: *{$pending}*\n✅ Approved: *{$approved}*\n❌ Rejected: *{$rejected}*\n💵 Revenue: ₹*{$revenue}*\n\n📅 " . date('d M Y, h:i A');
    
    $kb = ['inline_keyboard' => [[['text' => '🔄 Refresh', 'callback_data' => 'admin_stats'], ['text' => '⏳ Pending', 'callback_data' => 'admin_pending']], [['text' => '🔙 Back', 'callback_data' => 'admin_panel']]]];
    sendMessage($chat_id, $text, ['reply_markup' => $kb]);
}

### ==================== FIXED PENDING PAYMENTS ====================
function showPendingPayments($pdo, $chat_id) {
    $pending = getPendingPayments($pdo);
    
    if (!$pending) {
        sendMessage($chat_id, "━━━━━━━━━━━━━━━━━━━━━\n✅ *ALL CLEAR!*\n━━━━━━━━━━━━━━━━━━━━━\n\nNo pending payments", 
            ['reply_markup' => ['inline_keyboard' => [[['text' => '🔄 Refresh', 'callback_data' => 'admin_pending']], [['text' => '🔙 Back', 'callback_data' => 'admin_panel']]]]]);
        return;
    }
    
    sendMessage($chat_id, "━━━━━━━━━━━━━━━━━━━━━\n⏳ *PENDING: " . count($pending) . "*\n━━━━━━━━━━━━━━━━━━━━━");
    
    foreach ($pending as $p) {
        $safeUsername = escapeMarkdown($p['username'] ?? 'Unknown');
        
        $text = "💳 *Payment #{$p['id']}*\n\n";
        $text .= "👤 User: @{$safeUsername}\n";
        $text .= "🆔 ID: `{$p['user_id']}`\n";
        $text .= "💰 Amount: ₹*{$p['amount']}*\n";
        $text .= "💎 Lookups: {$p['lookups']}\n";
        $text .= "📝 UTR: `{$p['utr_number']}`\n";
        $text .= "📅 Date: {$p['created_at']}";
        
        $kb = ['inline_keyboard' => [
            [
                ['text' => '✅ Approve', 'callback_data' => "approve_{$p['id']}"],
                ['text' => '❌ Reject', 'callback_data' => "reject_{$p['id']}"]
            ]
        ]];
        
        if (!empty($p['screenshot_file_id'])) {
            sendPhoto($chat_id, $p['screenshot_file_id'], $text, $kb);
        } else {
            sendMessage($chat_id, $text, ['reply_markup' => $kb]);
        }
        usleep(100000);
    }
}

### ==================== LOOKUP FUNCTION ====================
function doLookupFlow($pdo, $user_id, $chat_id, $number) {
    $session = sessionGet($pdo, $user_id);
    if ($session && $session['step'] === 'processing_lookup') {
        return;
    }
    sessionSet($pdo, $user_id, 'processing_lookup', ['number' => $number]);
    
    if (!validateNumber($number)) {
        sessionClear($pdo, $user_id);
        sendMessage($chat_id, "❌ Invalid format\n\n📱 Send 10-digit number\n\n📝 Example: `9876543210`");
        return;
    }
    
    $clean = cleanNumber($number);
    $avail = getAvailableLookups($pdo, $user_id);
    
    if ($avail <= 0) {
        sessionClear($pdo, $user_id);
        sendMessage($chat_id, "⚠️ *NO LOOKUPS!*\n\n💎 Buy now to continue", ['reply_markup' => getBuyKeyboard()]);
        return;
    }
    
    sendMessage($chat_id, "🔍 *SEARCHING...*\n\n📱 `{$clean}`\n\n⏳ Please wait...");
    
    $data = fetchNumberInfo($number);
    sessionClear($pdo, $user_id);
    
    if (isset($data['error'])) {
        sendMessage($chat_id, "❌ *Error:* {$data['error']}\n\n💬 Contact: " . SUPPORT_USER . "\n\nTry again or contact support if issue persists.");
        return;
    }
    
    $results = isset($data['result']) && is_array($data['result']) ? $data['result'] : [];
    
    if (empty($results)) {
        sendMessage($chat_id, "📭 *NO DATA FOUND*\n\n📱 `{$clean}`\n\n💡 *No lookup deducted*\n\n💎 Balance: {$avail}", ['reply_markup' => getLookupResultKeyboard()]);
        return;
    }
    
    if (!useLookup($pdo, $user_id, $clean)) {
        sendMessage($chat_id, "❌ Lookup failed\n\nContact: " . SUPPORT_USER);
        return;
    }
    
    $remaining = getAvailableLookups($pdo, $user_id);
    $txt = formatResult($results) . "\n\n💎 Remaining: *{$remaining}*\n\n" . COPYRIGHT;
    sendMessage($chat_id, $txt, ['reply_markup' => getLookupResultKeyboard()]);
}

function notifyAdmins($pdo, $payment_id) {
    $p = getPayment($pdo, $payment_id);
    if (!$p) return false;
    
    $safeUsername = escapeMarkdown($p['username'] ?? 'Unknown');
    
    $text = "🔔 *NEW PAYMENT*\n\n🎫 *#{$p['id']}*\n👤 @{$safeUsername}\n🆔 `{$p['user_id']}`\n💰 ₹*{$p['amount']}*\n💎 {$p['lookups']}\n📝 UTR: `{$p['utr_number']}`";
    
    $kb = ['inline_keyboard' => [[['text' => '✅ Approve', 'callback_data' => "approve_{$p['id']}"], ['text' => '❌ Reject', 'callback_data' => "reject_{$p['id']}"]]]];
    
    foreach (ADMIN_IDS as $aid) {
        if (!empty($p['screenshot_file_id'])) {
            sendPhoto($aid, $p['screenshot_file_id'], $text, $kb);
        } else {
            sendMessage($aid, $text, ['reply_markup' => $kb]);
        }
        usleep(50000);
    }
    
    @sendMessage(BACKUP_CHANNEL, "🔔 Payment #{$p['id']}\n👤 @{$safeUsername}\n💰 ₹{$p['amount']}");
    return true;
}

### ==================== CALLBACK HANDLER ====================
function handleCallback($cb, $pdo) {
    $data = $cb['data'] ?? '';
    $user_id = $cb['from']['id'];
    $chat_id = $cb['message']['chat']['id'] ?? $user_id;
    $msg_id = $cb['message']['message_id'] ?? null;
    $username = $cb['from']['username'] ?? '';
    $first_name = $cb['from']['first_name'] ?? '';
    
    answerCallback($cb['id']);
    
    createUser($pdo, $user_id, $username, $first_name);
    $u = getUser($pdo, $user_id, true);
    
    if ($u && $u['is_banned'] && !isAdmin($user_id)) {
        sendMessage($chat_id, "🚫 You are banned.\n\n💬 Contact: " . SUPPORT_USER);
        return;
    }
    
    switch ($data) {
        case 'lookup_now':
            $avail = getAvailableLookups($pdo, $user_id);
            sendMessage($chat_id, "🔍 *NUMBER LOOKUP*\n\n📱 Send 10-digit number\n\n💎 Available: *{$avail}*", ['reply_markup' => ['inline_keyboard' => [[['text' => '💎 Buy Credits', 'callback_data' => 'buy_menu']], [['text' => '🔙 Main Menu', 'callback_data' => 'main_menu']]]]]);
            break;
            
        case 'buy_menu': sendBuyMenu($chat_id); break;
        case 'my_balance': sendBalance($pdo, $user_id, $chat_id); break;
        case 'my_profile': sendProfile($pdo, $user_id, $chat_id); break;
        case 'main_menu': sendStartMsg($pdo, $user_id, $chat_id); break;
        case 'referral_menu': sendReferralMenu($pdo, $user_id, $chat_id); break;
        case 'help_menu': sendHelpMenu($chat_id); break;
        case 'payment_history': showPaymentHistory($pdo, $user_id, $chat_id); break;
        case 'cancel_payment': sessionClear($pdo, $user_id); sendMessage($chat_id, "✅ Cancelled"); break;
        case 'admin_panel': if (isAdmin($user_id)) sendAdminPanel($chat_id); break;
        case 'admin_stats': if (isAdmin($user_id)) sendAdminStats($pdo, $chat_id); break;
        case 'admin_pending': if (isAdmin($user_id)) showPendingPayments($pdo, $chat_id); break;
        
        case 'admin_broadcast':
            if (isAdmin($user_id)) {
                if (isBroadcastLocked() || getBroadcastProgress()) {
                    sendMessage($chat_id, "⚠️ Broadcast already in progress\n\nUse /bcstatus to check\nUse /bccancel to cancel");
                    return;
                }
                sessionSet($pdo, $user_id, 'await_broadcast', []);
                sendMessage($chat_id, "📢 *BROADCAST MODE*\n\n📝 Send your message\n\n❌ /cancel to abort");
            }
            break;
            
        case 'admin_bc_status':
            if (isAdmin($user_id)) {
                getBroadcastStatus($chat_id);
            }
            break;
            
        case 'pay_custom':
            sessionSet($pdo, $user_id, 'await_custom_amount', []);
            sendMessage($chat_id, "💳 *CUSTOM PAYMENT*\n\n💰 Send amount (Min ₹" . MIN_PAYMENT . ")\n💎 Rate: ₹1 = 1 Lookup", ['reply_markup' => ['inline_keyboard' => [[['text' => '❌ Cancel', 'callback_data' => 'cancel_payment']]]]]);
            break;
            
        default:
            // Quick payment
            if (strpos($data, 'quick_') === 0) {
                $preset = substr($data, 6);
                $amount = $preset === '450' ? 450 : intval($preset);
                $lookups = $preset === '450' ? 500 : $amount;
                
                sessionSet($pdo, $user_id, 'await_screenshot', ['amount' => $amount, 'lookups' => $lookups]);
                
                $caption = "💳 *PAYMENT*\n\n💰 Amount: *₹{$amount}*\n💎 Lookups: *{$lookups}*\n\n💳 UPI: `" . YOUR_UPI_ID . "`\n👤 " . UPI_NAME . "\n\n📸 Send screenshot ⬇️";
                sendPhoto($chat_id, QR_CODE_IMAGE, $caption, ['inline_keyboard' => [[['text' => '❌ Cancel', 'callback_data' => 'cancel_payment']]]]);
                return;
            }
            
            // Approve/Reject
            if (isAdmin($user_id)) {
                if (strpos($data, 'approve_') === 0) {
                    $pid = intval(substr($data, 8));
                    $p = approvePayment($pdo, $pid, $user_id);
                    
                    if (!$p) {
                        sendMessage($chat_id, "❌ Already processed or not found");
                        return;
                    }
                    
                    $safeUsername = escapeMarkdown($p['username'] ?? 'Unknown');
                    $txt = "✅ *APPROVED*\n\n🎫 #{$pid}\n👤 @{$safeUsername}\n💰 ₹{$p['amount']}\n💎 {$p['lookups']}";
                    
                    $hasPhoto = isset($cb['message']['photo']) || isset($cb['message']['caption']);
                    
                    if ($msg_id && $hasPhoto) {
                        editMessageCaption($chat_id, $msg_id, $txt);
                    } elseif ($msg_id) {
                        editMessageText($chat_id, $msg_id, $txt);
                    } else {
                        sendMessage($chat_id, $txt);
                    }
                    
                    sendMessage($p['user_id'], "🎉 *PAYMENT APPROVED!*\n\n✅ Verified\n💰 ₹{$p['amount']}\n💎 +{$p['lookups']} lookups\n\n🙏 Thank you!", ['reply_markup' => getLookupResultKeyboard()]);
                    return;
                }
                
                if (strpos($data, 'reject_') === 0) {
                    $pid = intval(substr($data, 7));
                    $p = rejectPayment($pdo, $pid, $user_id, 'Rejected by admin');
                    
                    if (!$p) {
                        sendMessage($chat_id, "❌ Already processed or not found");
                        return;
                    }
                    
                    $safeUsername = escapeMarkdown($p['username'] ?? 'Unknown');
                    $txt = "❌ *REJECTED*\n\n🎫 #{$pid}\n👤 @{$safeUsername}";
                    
                    $hasPhoto = isset($cb['message']['photo']) || isset($cb['message']['caption']);
                    
                    if ($msg_id && $hasPhoto) {
                        editMessageCaption($chat_id, $msg_id, $txt);
                    } elseif ($msg_id) {
                        editMessageText($chat_id, $msg_id, $txt);
                    } else {
                        sendMessage($chat_id, $txt);
                    }
                    
                    sendMessage($p['user_id'], "❌ *PAYMENT REJECTED*\n\n💬 Contact: " . SUPPORT_USER, ['reply_markup' => ['inline_keyboard' => [[['text' => '💬 Support', 'url' => 'https://t.me/' . ltrim(SUPPORT_USER, '@')]], [['text' => '💎 Try Again', 'callback_data' => 'buy_menu']]]]]);
                    return;
                }
            }
    }
}

### ==================== MESSAGE HANDLER ====================
function handleMessage($msg, $pdo) {
    $chat_id = $msg['chat']['id'];
    $user_id = $msg['from']['id'];
    $msgText = $msg['text'] ?? null;
    $username = $msg['from']['username'] ?? '';
    $first_name = $msg['from']['first_name'] ?? '';
    
    // Cancel
    if ($msgText && strtolower(trim($msgText)) === '/cancel') {
        sessionClear($pdo, $user_id);
        createUser($pdo, $user_id, $username, $first_name);
        sendMessage($chat_id, "✅ *Cancelled*");
        sendStartMsg($pdo, $user_id, $chat_id);
        return;
    }
    
    // Start with referral
    if ($msgText && preg_match('/^\/start(\s+(.+))?/i', $msgText, $m)) {
        createUser($pdo, $user_id, $username, $first_name);
        
        if (isset($m[2]) && !empty(trim($m[2]))) {
            $code = trim($m[2]);
            $stmt = $pdo->prepare("SELECT user_id FROM users WHERE referral_code = ?");
            $stmt->execute([$code]);
            $r = $stmt->fetch();
            
            if ($r && $r['user_id'] != $user_id) {
                if (addReferral($pdo, intval($r['user_id']), $user_id)) {
                    sendMessage($chat_id, "🎉 *WELCOME!*\n\n✨ Referred by a friend!\n🎁 Your friend got bonus!", ['reply_markup' => getLookupResultKeyboard()]);
                    $referrerBalance = getAvailableLookups($pdo, intval($r['user_id']));
                    sendMessage($r['user_id'], "🎁 *NEW REFERRAL!*\n\n💎 +" . REFERRAL_BONUS . " lookups\n💰 Balance: *{$referrerBalance}*");
                }
            }
        }
        
        sendStartMsg($pdo, $user_id, $chat_id);
        return;
    }
    
    createUser($pdo, $user_id, $username, $first_name);
    $u = getUser($pdo, $user_id, true);
    
    if ($u && $u['is_banned'] && !isAdmin($user_id)) {
        sendMessage($chat_id, "🚫 You are banned.\n\n💬 Contact: " . SUPPORT_USER);
        return;
    }
    
    // Session handling
    $session = sessionGet($pdo, $user_id);
    
    if ($session) {
        $step = $session['step'];
        $data = $session['data'];
        
        // Broadcast
        if ($step === 'await_broadcast' && isAdmin($user_id) && $msgText) {
            sessionClear($pdo, $user_id);
            
            if (isBroadcastLocked() || getBroadcastProgress()) {
                sendMessage($chat_id, "⚠️ Broadcast already in progress");
                return;
            }
            
            if (queueBroadcast($pdo, $user_id, $msgText, $chat_id)) {
                processBroadcastBatch();
            }
            return;
        }
        
        // Custom amount
        if ($step === 'await_custom_amount' && $msgText) {
            $num = preg_replace('/\D/', '', $msgText);
            if (!$num || intval($num) < MIN_PAYMENT) {
                sendMessage($chat_id, "❌ Min ₹" . MIN_PAYMENT . "\n\n/cancel");
                return;
            }
            
            $amount = intval($num);
            $lookups = $amount * RATE_PER_RUPEE;
            sessionSet($pdo, $user_id, 'await_screenshot', ['amount' => $amount, 'lookups' => $lookups]);
            
            $caption = "💳 *PAYMENT*\n\n💰 ₹{$amount}\n💎 {$lookups} lookups\n\n💳 UPI: `" . YOUR_UPI_ID . "`\n👤 " . UPI_NAME . "\n\n📸 Send screenshot ⬇️";
            sendPhoto($chat_id, QR_CODE_IMAGE, $caption, ['inline_keyboard' => [[['text' => '❌ Cancel', 'callback_data' => 'cancel_payment']]]]);
            return;
        }
        
        // Screenshot wait
        if ($step === 'await_screenshot' && $msgText && !isset($msg['photo'])) {
            sendMessage($chat_id, "📸 Send screenshot (image)\n\n❌ /cancel");
            return;
        }
        
        // Amount confirmation
        if ($step === 'await_amount' && $msgText) {
            $num = preg_replace('/\D/', '', $msgText);
            if (!$num || intval($num) < MIN_PAYMENT) {
                sendMessage($chat_id, "❌ Invalid\n\n/cancel");
                return;
            }
            
            $data['confirmed_amount'] = intval($num);
            sessionSet($pdo, $user_id, 'await_utr', $data);
            sendMessage($chat_id, "✅ Amount: ₹{$num}\n\n📝 Send UTR/Transaction ID");
            return;
        }
        
        // UTR
        if ($step === 'await_utr' && $msgText) {
            $utr = preg_replace('/\s/', '', $msgText);
            if (strlen($utr) < 6) {
                sendMessage($chat_id, "❌ UTR too short\n\n/cancel");
                return;
            }
            
            if (empty($data['screenshot']) || empty($data['amount'])) {
                sendMessage($chat_id, "❌ Error. Restart payment");
                sessionClear($pdo, $user_id);
                return;
            }
            
            $pid = createPayment($pdo, $user_id, $username ?: $first_name ?: 'Unknown', $data['amount'], $data['lookups'], $utr, $data['screenshot']);
            notifyAdmins($pdo, $pid);
            
            sendMessage($chat_id, "✅ *SUBMITTED*\n\n🎫 #{$pid}\n💰 ₹{$data['amount']}\n💎 {$data['lookups']}\n📝 UTR: `{$utr}`\n\n⏳ Verifying...", ['reply_markup' => ['inline_keyboard' => [[['text' => '💳 History', 'callback_data' => 'payment_history']], [['text' => '🏠 Menu', 'callback_data' => 'main_menu']]]]]);
            sessionClear($pdo, $user_id);
            return;
        }
    }
    
    // Photo handler
    if (isset($msg['photo'])) {
        $photo = end($msg['photo']);
        $session = sessionGet($pdo, $user_id);
        
        if ($session && $session['step'] === 'await_screenshot') {
            $data = $session['data'];
            $data['screenshot'] = $photo['file_id'];
            sessionSet($pdo, $user_id, 'await_amount', $data);
            sendMessage($chat_id, "✅ Screenshot received!\n\n💰 Send exact amount paid");
            return;
        }
        
        sendMessage($chat_id, "📸 Use menu to make payment");
        return;
    }
    
    // Admin commands
    if ($msgText && isAdmin($user_id)) {
        if (preg_match('/^\/admin\b/i', $msgText)) { sendAdminPanel($chat_id); return; }
        if (preg_match('/^\/stats\b/i', $msgText)) { sendAdminStats($pdo, $chat_id); return; }
        if (preg_match('/^\/pending\b/i', $msgText)) { showPendingPayments($pdo, $chat_id); return; }
        
        // Broadcast commands
        if (preg_match('/^\/broadcast\b/i', $msgText)) {
            if (isBroadcastLocked() || getBroadcastProgress()) {
                sendMessage($chat_id, "⚠️ Broadcast in progress\n\n/bcstatus - Check status\n/bccancel - Cancel");
                return;
            }
            sessionSet($pdo, $user_id, 'await_broadcast', []);
            sendMessage($chat_id, "📢 *BROADCAST MODE*\n\n📝 Send your message (will be sent EXACTLY as you type)\n\n❌ /cancel to abort");
            return;
        }
        
        if (preg_match('/^\/bcstatus\b/i', $msgText)) {
            getBroadcastStatus($chat_id);
            return;
        }
        
        if (preg_match('/^\/bccancel\b/i', $msgText)) {
            cancelBroadcast($chat_id);
            return;
        }
        
        // Test API
        if (preg_match('/^\/testapi\s+(\d+)/i', $msgText, $m)) {
            $testNum = $m[1];
            sendMessage($chat_id, "🧪 Testing API with: {$testNum}");
            
            $result = fetchNumberInfo($testNum);
            
            $debugText = "━━━━━━━━━━━━━━━━━━━━━\n🧪 *API TEST RESULT*\n━━━━━━━━━━━━━━━━━━━━━\n\n";
            $debugText .= "📱 Number: `{$testNum}`\n\n";
            $debugText .= "📊 *Response:*\n```\n" . json_encode($result, JSON_PRETTY_PRINT) . "\n```\n\n";
            
            if (isset($result['error'])) {
                $debugText .= "❌ Error: {$result['error']}\n\n";
            } else {
                $debugText .= "✅ Success!\n\n";
            }
            
            $debugText .= "💡 Check `bot_debug.log` for details";
            
            sendMessage($chat_id, $debugText);
            return;
        }
        
        // /look [id]
        if (preg_match('/^\/look\s+(\d+)/i', $msgText, $m)) {
            $targetId = intval($m[1]);
            $targetUser = getUser($pdo, $targetId, true);
            
            if (!$targetUser) {
                sendMessage($chat_id, "❌ User {$targetId} not found");
                return;
            }
            
            $lookupCount = getUserLookupCount($pdo, $targetId);
            $paymentStats = getUserPaymentStats($pdo, $targetId);
            $freeLeft = max(0, FREE_LOOKUPS - intval($targetUser['free_used']));
            $premium = intval($targetUser['premium_balance']);
            
            $safeUsername = escapeMarkdown($targetUser['username'] ?? '');
            
            $text = "👤 *USER #{$targetId}*\n\n";
            $text .= "👤 {$targetUser['first_name']}\n📝 @{$safeUsername}\n📅 {$targetUser['join_date']}\n";
            $text .= "🚫 Banned: " . ($targetUser['is_banned'] ? 'YES' : 'NO') . "\n\n";
            $text .= "💰 Free: {$freeLeft}/" . FREE_LOOKUPS . "\n💎 Premium: {$premium}\n📊 Total: " . ($freeLeft + $premium) . "\n\n";
            $text .= "🔍 Lookups: {$lookupCount}\n💳 Payments: {$paymentStats['count']}\n💰 Spent: ₹{$paymentStats['total']}\n👥 Refs: {$targetUser['referrals']}\n🔗 Code: `{$targetUser['referral_code']}`";
            
            sendMessage($chat_id, $text);
            return;
        }
        
        // /addlookup [id] [amount]
        if (preg_match('/^\/addlookup\s+(\d+)\s+(\d+)/i', $msgText, $m)) {
            $targetId = intval($m[1]);
            $addAmount = intval($m[2]);
            
            if (!getUser($pdo, $targetId, true)) {
                sendMessage($chat_id, "❌ User {$targetId} not found");
                return;
            }
            
            addPremium($pdo, $targetId, $addAmount);
            $newBalance = getAvailableLookups($pdo, $targetId);
            sendMessage($chat_id, "✅ Added {$addAmount} to user {$targetId}\n💰 Balance: {$newBalance}");
            @sendMessage($targetId, "🎁 +{$addAmount} lookups\n💰 Balance: *{$newBalance}*");
            return;
        }
        
        // /remove [id] [amount]
        if (preg_match('/^\/remove\s+(\d+)\s+(\d+)/i', $msgText, $m)) {
            $targetId = intval($m[1]);
            $removeAmount = intval($m[2]);
            
            $targetUser = getUser($pdo, $targetId, true);
            if (!$targetUser) {
                sendMessage($chat_id, "❌ User {$targetId} not found");
                return;
            }
            
            if (intval($targetUser['premium_balance']) < $removeAmount) {
                sendMessage($chat_id, "❌ Insufficient balance ({$targetUser['premium_balance']})");
                return;
            }
            
            removePremium($pdo, $targetId, $removeAmount);
            $newBalance = getAvailableLookups($pdo, $targetId);
            sendMessage($chat_id, "✅ Removed {$removeAmount} from {$targetId}\n💰 Balance: {$newBalance}");
            @sendMessage($targetId, "⚠️ -{$removeAmount} lookups\n💰 Balance: *{$newBalance}*");
            return;
        }
        
        // /ban [id]
        if (preg_match('/^\/ban\s+(\d+)/i', $msgText, $m)) {
            banUser($pdo, intval($m[1]));
            sendMessage($chat_id, "✅ User {$m[1]} banned");
            @sendMessage(intval($m[1]), "🚫 You are banned\n\n💬 " . SUPPORT_USER);
            return;
        }
        
        // /unban [id]
        if (preg_match('/^\/unban\s+(\d+)/i', $msgText, $m)) {
            unbanUser($pdo, intval($m[1]));
            sendMessage($chat_id, "✅ User {$m[1]} unbanned");
            @sendMessage(intval($m[1]), "✅ You are unbanned!");
            return;
        }
    }
    
    // Phone lookup
    if ($msgText && validateNumber($msgText)) {
        doLookupFlow($pdo, $user_id, $chat_id, $msgText);
        return;
    }
    
    // Default
    if ($msgText) {
        sendMessage($chat_id, "❓ Send phone number or use menu");
        sendStartMsg($pdo, $user_id, $chat_id);
    }
}

### ==================== TEST ENDPOINT ====================
// Visit: https://yourdomain.com/bot.php?test=9876543210
if (isset($_GET['test'])) {
    header('Content-Type: application/json');
    
    $testNum = $_GET['test'] ?? '9876543210';
    $result = fetchNumberInfo($testNum);
    
    echo json_encode([
        'test_number' => $testNum,
        'api_url' => API_URL . urlencode(cleanNumber($testNum)),
        'result' => $result,
        'timestamp' => date('Y-m-d H:i:s'),
        'check_log' => 'See bot_debug.log for detailed logs'
    ], JSON_PRETTY_PRINT);
    exit;
}

### ==================== MAIN WEBHOOK ====================
$raw = file_get_contents('php://input');
if (!$raw) {
    if (getBroadcastProgress()) {
        processBroadcastBatch();
    }
    http_response_code(200);
    exit;
}

$update = json_decode($raw, true);
if (!$update || !isset($update['update_id'])) {
    http_response_code(200);
    exit;
}

$update_id = $update['update_id'];

if (!markUpdateProcessed($pdo, $update_id)) {
    http_response_code(200);
    exit;
}

try {
    if (isset($update['callback_query'])) {
        handleCallback($update['callback_query'], $pdo);
    } elseif (isset($update['message'])) {
        handleMessage($update['message'], $pdo);
    }
} catch (Exception $e) {
    log_debug("FATAL: " . $e->getMessage());
}

// Continue broadcast processing after handling current update
if (getBroadcastProgress()) {
    if (function_exists('fastcgi_finish_request')) {
        http_response_code(200);
        fastcgi_finish_request();
    }
    processBroadcastBatch();
}

http_response_code(200);
exit;