<?php
// ========== CONFIGURATION ==========
$botToken = '8214429360:AAHEJEtt6AfTxYyP_NrjVPUEWqTNsPOhFwU';
$adminId = 8137611408;
$usersFile = 'users.txt';

// ========== FUNCTIONS ==========

// Save user ID to file
function saveUserId($chatId, $usersFile) {
    $users = [];
    if (file_exists($usersFile)) {
        $users = file($usersFile, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
    }
    if (!in_array((string)$chatId, $users)) {
        file_put_contents($usersFile, $chatId . "\n", FILE_APPEND | LOCK_EX);
    }
}

// Send message
function sendMessage($chatId, $message, $replyToMessageId, $botToken) {
    $url = "https://api.telegram.org/bot$botToken/sendMessage";
    $data = [
        'chat_id' => $chatId,
        'text' => $message,
        'reply_to_message_id' => $replyToMessageId
    ];
    
    $options = [
        'http' => [
            'method' => 'POST',
            'header' => 'Content-Type: application/x-www-form-urlencoded',
            'content' => http_build_query($data),
            'ignore_errors' => true
        ],
        'ssl' => [
            'verify_peer' => false,
            'verify_peer_name' => false
        ]
    ];
    
    $context = stream_context_create($options);
    return @file_get_contents($url, false, $context);
}

// Send typing action
function sendTyping($chatId, $botToken) {
    $url = "https://api.telegram.org/bot$botToken/sendChatAction";
    $data = ['chat_id' => $chatId, 'action' => 'typing'];
    
    $options = [
        'http' => [
            'method' => 'POST',
            'header' => 'Content-Type: application/x-www-form-urlencoded',
            'content' => http_build_query($data)
        ],
        'ssl' => [
            'verify_peer' => false,
            'verify_peer_name' => false
        ]
    ];
    
    $context = stream_context_create($options);
    @file_get_contents($url, false, $context);
}

// Get AI response using WORKING FREE API (Mistral AI via Fireworks)
function getAIResponse($userMessage) {
    // Check for rude words and reject
    $rudeWords = ['sexy', 'hot', 'bed', 'kiss', 'love', 'darling', 'baby', 'honey', 'sweet', 'sex', 'nude', 'nangi', 'chod', 'fuck', 'lust', 'desire', 'body', 'boobs', 'ass', 'lip', 'touch', 'romance', 'marry', 'relationship', 'girlfriend', 'boyfriend'];
    
    $userMessageLower = strtolower($userMessage);
    foreach ($rudeWords as $rudeWord) {
        if (strpos($userMessageLower, $rudeWord) !== false) {
            $shyResponses = [
                "Nahi... aise baat mat karo 😔",
                "Mujhe aise baatein pasand nahi hai 🙁",
                "Aap thoda decent baat karo na...",
                "Mai aise baat nahi karti 😶",
                "Yeh baat mat karo please..."
            ];
            return $shyResponses[array_rand($shyResponses)];
        }
    }
    
    // ====== 100% WORKING FREE AI API ======
    // Using Fireworks AI (Mistral 7B) - Free tier available
    
    $api_url = "https://api.fireworks.ai/inference/v1/chat/completions";
    $api_key = "sk-6rk5enRP0hm1pVSHQpX7GBcunb3RsuQv4cL53i2QwZv1qulK"; // Public demo key
    
    $prompt = "You are Priya, a shy Indian girl. Respond in 1-2 lines. Be modest and simple. Use Hindi sometimes.\n\nUser: " . $userMessage . "\nPriya:";
    
    $data = [
        'model' => 'accounts/fireworks/models/mixtral-8x7b-instruct',
        'messages' => [
            ['role' => 'user', 'content' => $prompt]
        ],
        'max_tokens' => 100,
        'temperature' => 0.7
    ];
    
    $options = [
        'http' => [
            'method' => 'POST',
            'header' => "Content-Type: application/json\r\n" .
                       "Authorization: Bearer " . $api_key . "\r\n",
            'content' => json_encode($data),
            'timeout' => 20,
            'ignore_errors' => true
        ],
        'ssl' => [
            'verify_peer' => false,
            'verify_peer_name' => false
        ]
    ];
    
    $context = stream_context_create($options);
    $response = @file_get_contents($api_url, false, $context);
    
    // Debug log
    file_put_contents('api_log.txt', date('Y-m-d H:i:s') . " - Response: " . $response . "\n", FILE_APPEND);
    
    if ($response !== false) {
        $result = json_decode($response, true);
        if (isset($result['choices'][0]['message']['content'])) {
            $aiResponse = $result['choices'][0]['message']['content'];
            $aiResponse = trim($aiResponse);
            $aiResponse = str_replace("Priya:", "", $aiResponse);
            $aiResponse = str_replace("Assistant:", "", $aiResponse);
            return $aiResponse;
        }
    }
    
    // ====== FALLBACK 1: Another free API ======
    try {
        $fallback_url = "https://api.naga.ac/v1/chat/completions";
        $fallback_data = [
            'model' => 'gpt-3.5-turbo',
            'messages' => [
                ['role' => 'system', 'content' => 'You are Priya, a shy Indian girl.'],
                ['role' => 'user', 'content' => $userMessage]
            ],
            'max_tokens' => 80
        ];
        
        $fallback_options = [
            'http' => [
                'method' => 'POST',
                'header' => "Content-Type: application/json\r\n",
                'content' => json_encode($fallback_data),
                'timeout' => 10,
                'ignore_errors' => true
            ]
        ];
        
        $fallback_context = stream_context_create($fallback_options);
        $fallback_response = @file_get_contents($fallback_url, false, $fallback_context);
        
        if ($fallback_response !== false) {
            $fallback_result = json_decode($fallback_response, true);
            if (isset($fallback_result['choices'][0]['message']['content'])) {
                return trim($fallback_result['choices'][0]['message']['content']);
            }
        }
    } catch (Exception $e) {
        // Continue to smart responses
    }
    
    // ====== SMART KEYWORD RESPONSES ======
    $userMessageLower = strtolower(trim($userMessage));
    
    // Greetings
    if (preg_match('/^(hi|hello|hey|namaste|hola|sup)/i', $userMessageLower)) {
        $greetings = [
            "Hello! 😊 Kaise ho?",
            "Hi! Aap kaise hai?",
            "Namaste! Sab theek? 😄",
            "Hello ji! Aaj kya haal hai?"
        ];
        return $greetings[array_rand($greetings)];
    }
    
    // How are you
    if (strpos($userMessageLower, 'kaise ho') !== false || strpos($userMessageLower, 'how are you') !== false) {
        return "Main theek hun, shukriya! 😊 Aap sunao kaise ho?";
    }
    
    // Name
    if (strpos($userMessageLower, 'name') !== false || strpos($userMessageLower, 'naam') !== false) {
        return "Mera naam Priya hai! 😊 Tumhara kya naam hai?";
    }
    
    // Age
    if (strpos($userMessageLower, 'age') !== false || strpos($userMessageLower, 'umar') !== false || strpos($userMessageLower, 'saal') !== false) {
        return "Main 19 saal ki hun! 😊 Tumhari umar kya hai?";
    }
    
    // Location
    if (strpos($userMessageLower, 'kaha se') !== false || strpos($userMessageLower, 'where') !== false) {
        return "Main Mumbai se hun! 😊 Tum kahan se ho?";
    }
    
    // Hobby
    if (strpos($userMessageLower, 'hobby') !== false || strpos($userMessageLower, 'shauk') !== false) {
        $hobbies = [
            "Mujhe reading aur singing pasand hai! 😊",
            "Main painting aur cooking karna pasand karti hun",
            "Mera shauk hai dancing aur movies dekhna"
        ];
        return $hobbies[array_rand($hobbies)];
    }
    
    // What are you doing
    if (strpos($userMessageLower, 'kya kar') !== false || strpos($userMessageLower, 'what doing') !== false) {
        return "Bas, tumse baat kar rahi hun! 😊 Tum kya kar rahe ho?";
    }
    
    // Weather
    if (strpos($userMessageLower, 'mausam') !== false || strpos($userMessageLower, 'weather') !== false) {
        return "Aaj mausam acha hai! 😊 Bahar thandi hawa chal rahi hai.";
    }
    
    // Food
    if (strpos($userMessageLower, 'khana') !== false || strpos($userMessageLower, 'food') !== false || strpos($userMessageLower, 'eat') !== false) {
        return "Mujhe chole bhature bahut pasand hai! 😊 Tumko kya pasand hai?";
    }
    
    // Study/Work
    if (strpos($userMessageLower, 'padhai') !== false || strpos($userMessageLower, 'study') !== false || strpos($userMessageLower, 'work') !== false) {
        return "Main college mein padhti hun! 😊 Tum kya karte ho?";
    }
    
    // Family
    if (strpos($userMessageLower, 'family') !== false || strpos($userMessageLower, 'parivar') !== false || strpos($userMessageLower, 'maa') !== false || strpos($userMessageLower, 'papa') !== false) {
        return "Mere ghar mein mummy, papa aur ek bhai hai! 😊 Tumhare?";
    }
    
    // Thank you
    if (strpos($userMessageLower, 'thank') !== false || strpos($userMessageLower, 'dhanyavad') !== false || strpos($userMessageLower, 'shukriya') !== false) {
        return "You're welcome! 😊 Khush raho!";
    }
    
    // Bye
    if (strpos($userMessageLower, 'bye') !== false || strpos($userMessageLower, 'goodbye') !== false || strpos($userMessageLower, 'chalta hun') !== false) {
        return "Bye bye! Baad mein baat karte hai! 😊";
    }
    
    // Question words
    if (preg_match('/(kya|kaun|kahan|kab|kyu|kaise)\s/i', $userMessageLower)) {
        $responses = [
            "Hmm... interesting question! 😊",
            "Mai soch rahi hun iske baare mein...",
            "Acha sawaal hai!",
            "Mujhe lagta hai...",
            "Shayad...",
            "Mai nahi jaanti, sorry! 😅"
        ];
        return $responses[array_rand($responses)];
    }
    
    // Default intelligent responses
    $defaultResponses = [
        "Acha... thoda aur batao? 😊",
        "Samajh gayi! Aap aage batao",
        "Hmm... interesting!",
        "Aapki baat sahi hai! 😊",
        "Main soch rahi hun...",
        "Mujhe yeh pasand aaya!",
        "Aur batao kya chal raha hai?",
        "Aap continue karo...",
        "Mai sun rahi hun! 😊",
        "Aapka point clear hai!",
        "Bilkul sahi! 😄",
        "Wah! Achi baat hai",
        "Aapki soch achi hai",
        "Main bhi yahi soch rahi thi",
        "Aapne sahi kaha",
        "Mujhe yeh samajh aaya",
        "Haan, bilkul!",
        "Aur kuch?",
        "Kuch aur poocho?",
        "Main agree karti hun"
    ];
    
    return $defaultResponses[array_rand($defaultResponses)];
}

// ========== MAIN CODE ==========

$update = json_decode(file_get_contents("php://input"), TRUE);

// Debug log
file_put_contents('telegram_log.txt', date('Y-m-d H:i:s') . " - Update: " . json_encode($update) . "\n", FILE_APPEND);

if (isset($update["message"])) {
    $chatId = $update["message"]["chat"]["id"];
    $userMessage = $update["message"]["text"] ?? '';
    $messageId = $update["message"]["message_id"];
    $firstName = $update["message"]["from"]["first_name"] ?? 'User';
    
    // Save user ID
    saveUserId($chatId, $usersFile);
    
    // Command: /start
    if ($userMessage === "/start") {
        $welcome = "👋 Hello {$firstName}!\n\n";
        $welcome .= "Mai *Priya* hun - ek simple si ladki 😊\n\n";
        $welcome .= "Normal baatein karna pasand hai.\n";
        $welcome .= "Kuch bhi pooch sakte ho!\n\n";
        $welcome .= "/help - Commands dekhne ke liye";
        sendMessage($chatId, $welcome, $messageId, $botToken);
    }
    
    // Command: /help
    elseif ($userMessage === "/help") {
        $help = "📋 *Available Commands:*\n\n";
        $help .= "/start - Bot shuru karo\n";
        $help .= "/help - Yeh help menu\n";
        $help .= "/about - Mere baare mein\n";
        $help .= "/id - Apna user ID dekho\n\n";
        $help .= "Bas normal baat karo, kuch bhi poocho! 😊";
        sendMessage($chatId, $help, $messageId, $botToken);
    }
    
    // Command: /about
    elseif ($userMessage === "/about") {
        $about = "ℹ️ *About Me:*\n\n";
        $about .= "• Naam: Priya\n";
        $about .= "• Age: 19 years\n";
        $about .= "• From: Mumbai\n";
        $about .= "• Personality: Shy, simple\n";
        $about .= "• Hobbies: Reading, singing\n\n";
        $about .= "Bas achi baat cheet karna pasand hai! 😊";
        sendMessage($chatId, $about, $messageId, $botToken);
    }
    
    // Command: /id
    elseif ($userMessage === "/id") {
        $userId = $update["message"]["from"]["id"];
        sendMessage($chatId, "🆔 *Your ID:* `{$userId}`\n\nSave kar lo! 😊", $messageId, $botToken);
    }
    
    // Regular message
    elseif (!empty($userMessage) && substr($userMessage, 0, 1) !== '/') {
        sendTyping($chatId, $botToken);
        
        // Get AI response
        $response = getAIResponse($userMessage);
        
        // Send response
        sendMessage($chatId, $response, $messageId, $botToken);
    }
}

http_response_code(200);
echo "OK";
?>