<?php
// Universal Fast Video API (cPanel Ready)
// Usage: /api/download.php?url=VIDEO_URL

header("Content-Type: application/json");
header("Access-Control-Allow-Origin: *");

if (empty($_GET['url'])) {
    exit(json_encode([
        "status" => false,
        "error" => "Missing url"
    ]));
}

$url = trim($_GET['url']);
$url = strtok($url, "?");

// ---------------- INSTAGRAM ----------------
if (preg_match("#instagram\.com/(reel|p)/#i", $url)) {

    preg_match("#/(reel|p)/([^/]+)/#i", $url, $m);
    $code = $m[2] ?? null;

    if (!$code) {
        exit(json_encode(["status"=>false,"error"=>"Invalid Instagram link"]));
    }

    $api = "https://www.instagram.com/p/$code/?__a=1&__d=dis";

    $ch = curl_init();
    curl_setopt_array($ch, [
        CURLOPT_URL => $api,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_TIMEOUT => 8,
        CURLOPT_CONNECTTIMEOUT => 4,
        CURLOPT_SSL_VERIFYPEER => false,
        CURLOPT_HTTPHEADER => [
            "User-Agent: Mozilla/5.0 (Linux; Android 10)",
            "Accept: application/json"
        ]
    ]);

    $resp = curl_exec($ch);
    $http = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    if (!$resp || $http != 200) {
        exit(json_encode([
            "status" => false,
            "error" => "Instagram blocked request"
        ]));
    }

    $data = json_decode($resp, true);

    $video =
        $data['graphql']['shortcode_media']['video_url'] ??
        $data['items'][0]['video_versions'][0]['url'] ??
        null;

    if (!$video) {
        exit(json_encode([
            "status" => false,
            "error" => "Video not found / private"
        ]));
    }

    exit(json_encode([
        "status" => true,
        "platform" => "instagram",
        "type" => "video",
        "url" => $video
    ], JSON_UNESCAPED_SLASHES));
}

// ---------------- UNKNOWN PLATFORM ----------------
echo json_encode([
    "status" => false,
    "error" => "Platform not supported yet"
]);
