<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Sumal - Anime Glass Bio</title>
    <link href="https://fonts.googleapis.com/css2?family=Orbitron:wght@400;700;900&family=Poppins:wght@300;500;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

    <style>
        /* ===== 1. VARIABLES - ANIME THEME ===== */
        :root {
            --primary: #a855f7;
            --secondary: #ec4899;
            --accent: #06b6d4;
            --neon-glow: #f0abfc;
            --dark: #0c0015;
            --darker: #06000a;
            --glass-bg: rgba(255, 255, 255, 0.05);
            --glass-border: rgba(255, 255, 255, 0.1);
            --glass-strong: rgba(255, 255, 255, 0.08);
        }

        * { margin: 0; padding: 0; box-sizing: border-box; scroll-behavior: smooth; }

        body {
            font-family: 'Poppins', sans-serif;
            background: var(--darker);
            color: white;
            cursor: none;
            overflow-x: hidden;
        }

        ::selection { background: var(--primary); color: white; }
        a { text-decoration: none; color: inherit; }

        /* ===== EPIC LOADING SCREEN ===== */
        .loader {
            position: fixed;
            top: 0; left: 0;
            width: 100%; height: 100%;
            background: var(--darker);
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
            z-index: 100000;
            overflow: hidden;
        }
        
        .loader.hidden {
            animation: loaderExit 1.2s forwards;
        }
        
        @keyframes loaderExit {
            0% { 
                clip-path: circle(100% at 50% 50%);
            }
            100% { 
                clip-path: circle(0% at 50% 50%);
                visibility: hidden;
            }
        }

        /* Animated Background Grid */
        .loader-bg {
            position: absolute;
            width: 200%; height: 200%;
            background-image: 
                linear-gradient(rgba(168, 85, 247, 0.1) 1px, transparent 1px),
                linear-gradient(90deg, rgba(168, 85, 247, 0.1) 1px, transparent 1px);
            background-size: 40px 40px;
            animation: gridMove 20s linear infinite;
            transform: perspective(500px) rotateX(60deg);
            top: 50%;
        }
        
        @keyframes gridMove {
            0% { transform: perspective(500px) rotateX(60deg) translateY(0); }
            100% { transform: perspective(500px) rotateX(60deg) translateY(40px); }
        }

        /* Floating Particles in Loader */
        .loader-particles {
            position: absolute;
            width: 100%; height: 100%;
            overflow: hidden;
        }
        
        .l-particle {
            position: absolute;
            width: 4px; height: 4px;
            background: var(--primary);
            border-radius: 50%;
            animation: floatUp 3s infinite;
            box-shadow: 0 0 10px var(--primary);
        }
        
        @keyframes floatUp {
            0% { transform: translateY(100vh) scale(0); opacity: 0; }
            50% { opacity: 1; }
            100% { transform: translateY(-100vh) scale(1); opacity: 0; }
        }

        /* Main Loader Container */
        .loader-content {
            position: relative;
            display: flex;
            flex-direction: column;
            align-items: center;
            z-index: 10;
        }

        /* Anime Avatar with Energy Rings */
        .loader-avatar-container {
            position: relative;
            width: 200px; height: 200px;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .loader-anime {
            width: 120px; height: 120px;
            border-radius: 50%;
            background: url('https://i.pinimg.com/originals/f1/26/1d/f1261d89ea54801c4f59a0cf0c534c5a.gif') center/cover;
            border: 3px solid var(--primary);
            position: relative;
            z-index: 5;
            box-shadow: 
                0 0 30px var(--primary),
                0 0 60px rgba(168, 85, 247, 0.5),
                inset 0 0 30px rgba(168, 85, 247, 0.3);
            animation: avatarPulse 2s ease-in-out infinite;
        }
        
        @keyframes avatarPulse {
            0%, 100% { 
                transform: scale(1);
                box-shadow: 0 0 30px var(--primary), 0 0 60px rgba(168, 85, 247, 0.5);
            }
            50% { 
                transform: scale(1.05);
                box-shadow: 0 0 50px var(--secondary), 0 0 100px rgba(236, 72, 153, 0.5);
            }
        }

        /* Energy Rings */
        .energy-ring {
            position: absolute;
            border-radius: 50%;
            border: 2px solid transparent;
            animation: ringRotate 3s linear infinite;
        }
        
        .ring-1 {
            width: 150px; height: 150px;
            border-top-color: var(--primary);
            border-right-color: var(--primary);
            animation-duration: 2s;
        }
        
        .ring-2 {
            width: 170px; height: 170px;
            border-bottom-color: var(--secondary);
            border-left-color: var(--secondary);
            animation-duration: 2.5s;
            animation-direction: reverse;
        }
        
        .ring-3 {
            width: 190px; height: 190px;
            border-top-color: var(--accent);
            border-left-color: var(--accent);
            animation-duration: 3s;
        }
        
        @keyframes ringRotate {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }

        /* Orbiting Dots */
        .orbit-dot {
            position: absolute;
            width: 8px; height: 8px;
            background: var(--accent);
            border-radius: 50%;
            box-shadow: 0 0 15px var(--accent);
            animation: orbitDot 2s linear infinite;
        }
        
        .orbit-dot:nth-child(2) { animation-delay: -0.5s; }
        .orbit-dot:nth-child(3) { animation-delay: -1s; }
        .orbit-dot:nth-child(4) { animation-delay: -1.5s; }
        
        @keyframes orbitDot {
            0% { transform: rotate(0deg) translateX(95px) rotate(0deg); }
            100% { transform: rotate(360deg) translateX(95px) rotate(-360deg); }
        }

        /* Glitch Text Effect */
        .loader-text {
            margin-top: 40px;
            font-family: 'Orbitron', sans-serif;
            font-size: 2rem;
            font-weight: 900;
            letter-spacing: 8px;
            position: relative;
            color: white;
            text-shadow: 0 0 10px var(--primary);
        }
        
        .loader-text::before,
        .loader-text::after {
            content: 'SUMAL';
            position: absolute;
            top: 0; left: 0;
            width: 100%; height: 100%;
        }
        
        .loader-text::before {
            color: var(--secondary);
            animation: glitch1 0.3s infinite;
            clip-path: polygon(0 0, 100% 0, 100% 35%, 0 35%);
            transform: translate(-2px);
        }
        
        .loader-text::after {
            color: var(--accent);
            animation: glitch2 0.3s infinite;
            clip-path: polygon(0 65%, 100% 65%, 100% 100%, 0 100%);
            transform: translate(2px);
        }
        
        @keyframes glitch1 {
            0%, 100% { transform: translate(0); }
            20% { transform: translate(-3px, 3px); }
            40% { transform: translate(-3px, -3px); }
            60% { transform: translate(3px, 3px); }
            80% { transform: translate(3px, -3px); }
        }
        
        @keyframes glitch2 {
            0%, 100% { transform: translate(0); }
            20% { transform: translate(3px, -3px); }
            40% { transform: translate(3px, 3px); }
            60% { transform: translate(-3px, -3px); }
            80% { transform: translate(-3px, 3px); }
        }

        /* Status Text */
        .loader-status {
            margin-top: 15px;
            font-size: 0.8rem;
            color: rgba(255,255,255,0.5);
            letter-spacing: 3px;
            text-transform: uppercase;
            animation: statusBlink 1s infinite;
        }
        
        @keyframes statusBlink {
            0%, 50%, 100% { opacity: 1; }
            25%, 75% { opacity: 0.3; }
        }

        /* Progress Container */
        .loader-progress-container {
            margin-top: 30px;
            width: 280px;
            position: relative;
        }

        .loader-bar {
            width: 100%;
            height: 6px;
            background: rgba(255,255,255,0.1);
            border-radius: 10px;
            overflow: hidden;
            position: relative;
        }
        
        .loader-bar::before {
            content: '';
            position: absolute;
            top: 0; left: 0;
            width: 100%; height: 100%;
            background: repeating-linear-gradient(
                90deg,
                transparent,
                transparent 10px,
                rgba(255,255,255,0.05) 10px,
                rgba(255,255,255,0.05) 20px
            );
        }
        
        .loader-progress {
            height: 100%;
            background: linear-gradient(90deg, var(--primary), var(--secondary), var(--accent));
            border-radius: 10px;
            width: 0%;
            animation: loadProgress 2.5s ease-out forwards;
            box-shadow: 0 0 20px var(--primary), 0 0 40px var(--secondary);
            position: relative;
        }
        
        .loader-progress::after {
            content: '';
            position: absolute;
            top: 0; right: 0;
            width: 30px; height: 100%;
            background: linear-gradient(90deg, transparent, white);
            animation: shimmer 1s infinite;
        }
        
        @keyframes loadProgress {
            0% { width: 0%; }
            20% { width: 20%; }
            40% { width: 45%; }
            60% { width: 70%; }
            80% { width: 85%; }
            100% { width: 100%; }
        }
        
        @keyframes shimmer {
            0% { opacity: 0; }
            50% { opacity: 1; }
            100% { opacity: 0; }
        }

        /* Percentage Counter */
        .loader-percentage {
            position: absolute;
            right: 0;
            top: -25px;
            font-family: 'Orbitron', sans-serif;
            font-size: 0.9rem;
            color: var(--accent);
            text-shadow: 0 0 10px var(--accent);
        }

        /* Loading Tips */
        .loader-tips {
            margin-top: 50px;
            padding: 15px 30px;
            background: rgba(255,255,255,0.03);
            border: 1px solid var(--glass-border);
            border-radius: 10px;
            font-size: 0.85rem;
            color: rgba(255,255,255,0.6);
            max-width: 350px;
            text-align: center;
        }
        
        .loader-tips i {
            color: var(--primary);
            margin-right: 8px;
        }

        /* Corner Decorations */
        .loader-corner {
            position: absolute;
            width: 80px; height: 80px;
            border: 2px solid var(--primary);
            opacity: 0.3;
        }
        
        .corner-tl { top: 30px; left: 30px; border-right: none; border-bottom: none; }
        .corner-tr { top: 30px; right: 30px; border-left: none; border-bottom: none; }
        .corner-bl { bottom: 30px; left: 30px; border-right: none; border-top: none; }
        .corner-br { bottom: 30px; right: 30px; border-left: none; border-top: none; }

        /* Scan Line Effect */
        .scan-line {
            position: absolute;
            width: 100%;
            height: 4px;
            background: linear-gradient(90deg, transparent, var(--primary), transparent);
            opacity: 0.1;
            animation: scanLine 3s linear infinite;
        }
        
        @keyframes scanLine {
            0% { top: 0; }
            100% { top: 100%; }
        }

        /* ===== 2. CUSTOM CURSOR ===== */
        .cursor {
            width: 30px; height: 30px;
            border: 2px solid var(--secondary);
            border-radius: 50%;
            position: fixed;
            pointer-events: none;
            z-index: 99999;
            transition: transform 0.15s, background 0.2s;
            mix-blend-mode: difference;
        }
        .cursor-dot {
            width: 8px; height: 8px;
            background: var(--primary);
            border-radius: 50%;
            position: fixed;
            pointer-events: none;
            z-index: 99999;
            box-shadow: 0 0 20px var(--primary);
        }
        .cursor.hover { transform: scale(1.5); background: rgba(168, 85, 247, 0.3); }

        /* ===== CHERRY BLOSSOM PARTICLES ===== */
        .sakura {
            position: fixed;
            top: -10%;
            z-index: 1;
            pointer-events: none;
            animation: fall linear infinite;
            opacity: 0.8;
        }
        .sakura::before {
            content: '🌸';
            font-size: 20px;
        }
        @keyframes fall {
            to { transform: translateY(110vh) rotate(720deg); }
        }

        /* ===== ANIMATED BACKGROUND ===== */
        .bg-container {
            position: fixed;
            top: 0; left: 0;
            width: 100%; height: 100%;
            z-index: 0;
            overflow: hidden;
        }

        .orb {
            position: absolute;
            border-radius: 50%;
            filter: blur(80px);
            opacity: 0.5;
            animation: orbFloat 20s infinite;
        }
        .orb-1 {
            width: 600px; height: 600px;
            background: var(--primary);
            top: -20%; left: -10%;
        }
        .orb-2 {
            width: 500px; height: 500px;
            background: var(--secondary);
            bottom: -20%; right: -10%;
            animation-delay: -10s;
        }
        .orb-3 {
            width: 400px; height: 400px;
            background: var(--accent);
            top: 50%; left: 50%;
            animation-delay: -5s;
        }
        @keyframes orbFloat {
            0%, 100% { transform: translate(0, 0) scale(1); }
            25% { transform: translate(50px, -50px) scale(1.1); }
            50% { transform: translate(-30px, 30px) scale(0.9); }
            75% { transform: translate(-50px, -30px) scale(1.05); }
        }

        .grid-overlay {
            position: absolute;
            width: 100%; height: 100%;
            background-image: 
                linear-gradient(rgba(168, 85, 247, 0.03) 1px, transparent 1px),
                linear-gradient(90deg, rgba(168, 85, 247, 0.03) 1px, transparent 1px);
            background-size: 50px 50px;
        }

        /* ===== NAVIGATION ===== */
        nav {
            position: fixed;
            top: 20px;
            left: 50%;
            transform: translateX(-50%);
            background: var(--glass-bg);
            backdrop-filter: blur(30px);
            -webkit-backdrop-filter: blur(30px);
            border: 1px solid var(--glass-border);
            border-radius: 100px;
            padding: 15px 50px;
            z-index: 1000;
            display: flex;
            gap: 40px;
            box-shadow: 0 10px 40px rgba(0,0,0,0.3);
        }
        nav a {
            font-size: 0.9rem;
            font-weight: 500;
            color: rgba(255,255,255,0.6);
            transition: 0.3s;
            position: relative;
        }
        nav a:hover { color: var(--primary); text-shadow: 0 0 20px var(--primary); }
        nav a::after {
            content: '';
            position: absolute;
            bottom: -8px; left: 50%;
            transform: translateX(-50%);
            width: 0; height: 3px;
            background: linear-gradient(90deg, var(--primary), var(--secondary));
            border-radius: 10px;
            transition: 0.3s;
        }
        nav a:hover::after { width: 100%; }

        /* ===== HERO SECTION ===== */
        .hero {
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            position: relative;
            z-index: 2;
            padding: 120px 20px;
        }

        .hero-content {
            display: flex;
            align-items: center;
            gap: 80px;
            max-width: 1200px;
        }

        .hero-anime { position: relative; }
        
        .anime-frame {
            width: 350px; height: 450px;
            background: var(--glass-bg);
            backdrop-filter: blur(20px);
            border: 1px solid var(--glass-border);
            border-radius: 30px;
            padding: 15px;
            position: relative;
            overflow: hidden;
            box-shadow: 
                0 25px 50px rgba(0,0,0,0.5),
                inset 0 0 30px rgba(168, 85, 247, 0.1);
        }
        .anime-frame::before {
            content: '';
            position: absolute;
            top: 0; left: 0;
            width: 100%; height: 100%;
            background: linear-gradient(135deg, rgba(168,85,247,0.2) 0%, transparent 50%, rgba(236,72,153,0.2) 100%);
            pointer-events: none;
        }
        .anime-img {
            width: 100%; height: 100%;
            object-fit: cover;
            border-radius: 20px;
        }

        .badge {
            position: absolute;
            background: var(--glass-strong);
            backdrop-filter: blur(20px);
            border: 1px solid var(--glass-border);
            padding: 10px 20px;
            border-radius: 50px;
            font-size: 0.8rem;
            display: flex;
            align-items: center;
            gap: 8px;
            box-shadow: 0 10px 30px rgba(0,0,0,0.3);
            animation: floatBadge 3s ease-in-out infinite;
        }
        .badge i { color: var(--primary); }
        .badge-1 { top: 20px; right: -60px; }
        .badge-2 { bottom: 80px; left: -80px; animation-delay: -1s; }
        .badge-3 { bottom: 20px; right: -40px; animation-delay: -2s; }
        @keyframes floatBadge {
            0%, 100% { transform: translateY(0); }
            50% { transform: translateY(-10px); }
        }

        .hero-text { max-width: 500px; }
        
        .hero-subtitle {
            display: inline-block;
            background: var(--glass-bg);
            backdrop-filter: blur(20px);
            border: 1px solid var(--glass-border);
            padding: 10px 25px;
            border-radius: 50px;
            font-size: 0.85rem;
            color: var(--primary);
            margin-bottom: 20px;
        }

        .hero-title {
            font-family: 'Orbitron', sans-serif;
            font-size: 4rem;
            font-weight: 900;
            line-height: 1.1;
            margin-bottom: 10px;
        }
        .hero-title span {
            background: linear-gradient(90deg, var(--primary), var(--secondary), var(--accent));
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
        }

        .hero-japanese {
            font-size: 1.5rem;
            color: rgba(255,255,255,0.3);
            margin-bottom: 20px;
            letter-spacing: 10px;
        }

        .typing-container {
            font-size: 1.1rem;
            color: rgba(255,255,255,0.6);
            margin-bottom: 30px;
            min-height: 30px;
        }
        .typing-text {
            border-right: 2px solid var(--secondary);
            padding-right: 5px;
            animation: blink 0.7s infinite;
        }
        @keyframes blink { 0%, 100% { border-color: var(--secondary); } 50% { border-color: transparent; } }

        .hero-btns { display: flex; gap: 20px; flex-wrap: wrap; }

        .btn-glass {
            padding: 15px 35px;
            background: var(--glass-bg);
            backdrop-filter: blur(20px);
            border: 1px solid var(--glass-border);
            border-radius: 50px;
            color: white;
            font-weight: 600;
            transition: 0.3s;
            cursor: pointer;
            position: relative;
            overflow: hidden;
        }
        .btn-glass::before {
            content: '';
            position: absolute;
            top: 0; left: -100%;
            width: 100%; height: 100%;
            background: linear-gradient(90deg, transparent, rgba(255,255,255,0.2), transparent);
            transition: 0.5s;
        }
        .btn-glass:hover::before { left: 100%; }
        .btn-glass:hover {
            border-color: var(--primary);
            box-shadow: 0 0 30px rgba(168, 85, 247, 0.3);
            transform: translateY(-3px);
        }

        .btn-glow {
            padding: 15px 35px;
            background: linear-gradient(90deg, var(--primary), var(--secondary));
            border: none;
            border-radius: 50px;
            color: white;
            font-weight: 600;
            cursor: pointer;
            transition: 0.3s;
            box-shadow: 0 10px 30px rgba(168, 85, 247, 0.4);
        }
        .btn-glow:hover {
            transform: translateY(-3px);
            box-shadow: 0 15px 40px rgba(168, 85, 247, 0.6);
        }

        /* ===== SECTIONS ===== */
        section {
            position: relative;
            z-index: 2;
            padding: 100px 20px;
            max-width: 1200px;
            margin: 0 auto;
        }

        .section-title {
            text-align: center;
            margin-bottom: 60px;
        }
        .section-title h2 {
            font-family: 'Orbitron', sans-serif;
            font-size: 2.5rem;
            font-weight: 700;
        }
        .section-title h2 span {
            background: linear-gradient(90deg, var(--primary), var(--secondary));
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
        }
        .section-title p { color: rgba(255,255,255,0.5); margin-top: 10px; }
        .section-title .jp { color: rgba(255,255,255,0.2); letter-spacing: 5px; margin-top: 5px; }

        .reveal {
            opacity: 0;
            transform: translateY(60px);
            transition: all 1s cubic-bezier(0.5, 0, 0, 1);
        }
        .reveal.active { opacity: 1; transform: translateY(0); }

        /* ===== ABOUT ===== */
        .about-grid {
            display: grid;
            grid-template-columns: 1fr 1.5fr;
            gap: 50px;
            align-items: center;
        }

        .about-anime-img {
            width: 100%;
            border-radius: 30px;
            border: 1px solid var(--glass-border);
            box-shadow: 0 30px 60px rgba(0,0,0,0.5);
        }

        .about-content {
            background: var(--glass-bg);
            backdrop-filter: blur(30px);
            border: 1px solid var(--glass-border);
            border-radius: 30px;
            padding: 40px;
            box-shadow: 0 20px 50px rgba(0,0,0,0.3);
        }
        .about-content h3 {
            font-size: 1.8rem;
            margin-bottom: 20px;
            color: var(--primary);
        }
        .about-content p {
            color: rgba(255,255,255,0.7);
            line-height: 1.9;
            margin-bottom: 20px;
        }

        .stats-grid {
            display: grid;
            grid-template-columns: repeat(3, 1fr);
            gap: 20px;
            margin-top: 30px;
        }
        .stat-glass {
            background: rgba(168, 85, 247, 0.1);
            border: 1px solid rgba(168, 85, 247, 0.2);
            border-radius: 20px;
            padding: 25px;
            text-align: center;
            transition: 0.3s;
        }
        .stat-glass:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 30px rgba(168, 85, 247, 0.2);
        }
        .stat-glass h4 {
            font-size: 2.5rem;
            font-family: 'Orbitron', sans-serif;
            background: linear-gradient(90deg, var(--primary), var(--secondary));
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
        }
        .stat-glass p { font-size: 0.85rem; color: rgba(255,255,255,0.5); margin-top: 5px; }

        /* ===== SKILLS ===== */
        .skills-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(280px, 1fr));
            gap: 25px;
        }

        .skill-holo {
            background: linear-gradient(135deg, 
                rgba(168, 85, 247, 0.1) 0%, 
                rgba(236, 72, 153, 0.05) 50%, 
                rgba(6, 182, 212, 0.1) 100%);
            backdrop-filter: blur(30px);
            border: 1px solid var(--glass-border);
            border-radius: 25px;
            padding: 35px;
            position: relative;
            overflow: hidden;
            transition: 0.4s;
        }
        .skill-holo::before {
            content: '';
            position: absolute;
            top: -50%; left: -50%;
            width: 200%; height: 200%;
            background: linear-gradient(45deg, transparent 40%, rgba(255,255,255,0.1) 50%, transparent 60%);
            transform: rotate(45deg);
            animation: holoShine 3s infinite;
        }
        @keyframes holoShine {
            0% { transform: translateX(-100%) rotate(45deg); }
            100% { transform: translateX(100%) rotate(45deg); }
        }

        .skill-holo:hover {
            transform: translateY(-10px) scale(1.02);
            border-color: var(--primary);
            box-shadow: 0 20px 40px rgba(168, 85, 247, 0.2);
        }

        .skill-icon {
            width: 70px; height: 70px;
            background: linear-gradient(135deg, var(--primary), var(--secondary));
            border-radius: 20px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 1.8rem;
            margin-bottom: 20px;
            box-shadow: 0 10px 30px rgba(168, 85, 247, 0.3);
        }

        .skill-holo h4 { font-size: 1.3rem; margin-bottom: 10px; }
        .skill-holo p { font-size: 0.9rem; color: rgba(255,255,255,0.6); margin-bottom: 20px; }

        .skill-bar-container {
            background: rgba(255,255,255,0.1);
            border-radius: 10px;
            height: 8px;
            overflow: hidden;
        }
        .skill-bar-fill {
            height: 100%;
            background: linear-gradient(90deg, var(--primary), var(--secondary), var(--accent));
            border-radius: 10px;
            width: 0;
            transition: width 2s ease;
            box-shadow: 0 0 20px var(--primary);
        }

        /* ===== PORTFOLIO ===== */
        .portfolio-grid {
            display: grid;
            grid-template-columns: repeat(3, 1fr);
            gap: 20px;
        }

        .portfolio-glass {
            position: relative;
            height: 300px;
            border-radius: 25px;
            overflow: hidden;
            cursor: pointer;
            border: 1px solid var(--glass-border);
        }
        .portfolio-glass img {
            width: 100%; height: 100%;
            object-fit: cover;
            transition: 0.5s;
        }
        .portfolio-glass:hover img {
            transform: scale(1.1);
            filter: brightness(0.4);
        }

        .portfolio-overlay {
            position: absolute;
            inset: 0;
            background: linear-gradient(to top, rgba(0,0,0,0.9) 0%, transparent 50%);
            display: flex;
            flex-direction: column;
            justify-content: flex-end;
            padding: 30px;
            opacity: 0;
            transition: 0.4s;
        }
        .portfolio-glass:hover .portfolio-overlay { opacity: 1; }
        .portfolio-overlay h4 { font-size: 1.3rem; margin-bottom: 5px; }
        .portfolio-overlay p { color: var(--primary); font-size: 0.9rem; }

        .portfolio-glass.featured {
            grid-column: span 2;
            grid-row: span 2;
            height: auto;
        }

        /* ===== TESTIMONIALS ===== */
        .testimonial-container { max-width: 800px; margin: 0 auto; }

        .testimonial-glass {
            background: var(--glass-bg);
            backdrop-filter: blur(30px);
            border: 1px solid var(--glass-border);
            border-radius: 30px;
            padding: 50px;
            text-align: center;
            position: relative;
            overflow: hidden;
        }
        .testimonial-glass::before {
            content: '"';
            position: absolute;
            top: 20px; left: 40px;
            font-size: 8rem;
            color: rgba(168, 85, 247, 0.1);
            font-family: serif;
            line-height: 1;
        }

        .testimonial-slider { display: flex; transition: transform 0.5s; }
        .testimonial-slide { min-width: 100%; padding: 0 20px; }

        .testimonial-avatar {
            width: 100px; height: 100px;
            border-radius: 50%;
            object-fit: cover;
            border: 3px solid var(--primary);
            margin: 0 auto 20px;
            box-shadow: 0 0 30px rgba(168, 85, 247, 0.3);
        }
        .testimonial-slide p {
            font-size: 1.2rem;
            font-style: italic;
            color: rgba(255,255,255,0.8);
            line-height: 1.9;
            margin-bottom: 20px;
        }
        .testimonial-slide h4 { color: var(--primary); font-size: 1.1rem; }
        .testimonial-slide span { color: rgba(255,255,255,0.4); font-size: 0.9rem; }

        .testimonial-dots {
            display: flex;
            justify-content: center;
            gap: 10px;
            margin-top: 30px;
        }
        .t-dot {
            width: 12px; height: 12px;
            border-radius: 50%;
            background: rgba(255,255,255,0.2);
            cursor: pointer;
            transition: 0.3s;
        }
        .t-dot.active {
            background: var(--primary);
            box-shadow: 0 0 15px var(--primary);
            width: 40px;
            border-radius: 10px;
        }

        /* ===== CONTACT ===== */
        .contact-grid {
            display: grid;
            grid-template-columns: 1fr 1.2fr;
            gap: 50px;
        }

        .contact-info-glass {
            background: var(--glass-bg);
            backdrop-filter: blur(30px);
            border: 1px solid var(--glass-border);
            border-radius: 30px;
            padding: 40px;
        }
        .contact-info-glass h3 {
            font-size: 2rem;
            margin-bottom: 15px;
            background: linear-gradient(90deg, var(--primary), var(--secondary));
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
        }
        .contact-info-glass > p {
            color: rgba(255,255,255,0.6);
            line-height: 1.8;
            margin-bottom: 30px;
        }

        .contact-item {
            display: flex;
            align-items: center;
            gap: 20px;
            margin-bottom: 25px;
        }
        .contact-icon {
            width: 55px; height: 55px;
            background: rgba(168, 85, 247, 0.1);
            border: 1px solid rgba(168, 85, 247, 0.3);
            border-radius: 15px;
            display: flex;
            align-items: center;
            justify-content: center;
            color: var(--primary);
            font-size: 1.2rem;
        }
        .contact-item-text span { display: block; color: rgba(255,255,255,0.5); font-size: 0.85rem; }
        .contact-item-text p { color: white; font-size: 1rem; }

        .form-glass {
            background: var(--glass-bg);
            backdrop-filter: blur(30px);
            border: 1px solid var(--glass-border);
            border-radius: 30px;
            padding: 40px;
        }

        .form-row { display: flex; gap: 20px; }
        .form-group { margin-bottom: 20px; flex: 1; }
        .form-group label {
            display: block;
            margin-bottom: 8px;
            color: rgba(255,255,255,0.6);
            font-size: 0.9rem;
        }
        .form-group input, .form-group textarea {
            width: 100%;
            padding: 15px 20px;
            background: rgba(255,255,255,0.05);
            border: 1px solid var(--glass-border);
            border-radius: 15px;
            color: white;
            font-family: inherit;
            font-size: 1rem;
            outline: none;
            transition: 0.3s;
        }
        .form-group input:focus, .form-group textarea:focus {
            border-color: var(--primary);
            box-shadow: 0 0 20px rgba(168, 85, 247, 0.2);
        }
        .form-group textarea { min-height: 150px; resize: none; }

        .form-glass .btn-glow { width: 100%; padding: 18px; font-size: 1rem; }

        /* ===== FOOTER ===== */
        footer {
            position: relative;
            z-index: 2;
            text-align: center;
            padding: 60px 20px;
            border-top: 1px solid var(--glass-border);
            background: var(--glass-bg);
            backdrop-filter: blur(20px);
        }

        .social-glass {
            display: flex;
            justify-content: center;
            gap: 15px;
            margin-bottom: 30px;
        }
        .social-glass a {
            width: 55px; height: 55px;
            background: var(--glass-bg);
            border: 1px solid var(--glass-border);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 1.2rem;
            transition: 0.3s;
        }
        .social-glass a:hover {
            background: var(--primary);
            color: var(--dark);
            transform: translateY(-5px);
            box-shadow: 0 10px 30px rgba(168, 85, 247, 0.4);
        }

        footer p { color: rgba(255,255,255,0.4); font-size: 0.9rem; }
        footer p span { color: var(--primary); }

        /* ===== MUSIC PLAYER ===== */
        .music-float {
            position: fixed;
            bottom: 30px;
            right: 30px;
            z-index: 1000;
            display: flex;
            align-items: center;
            gap: 15px;
            background: var(--glass-bg);
            backdrop-filter: blur(30px);
            border: 1px solid var(--glass-border);
            padding: 12px 20px;
            border-radius: 60px;
            box-shadow: 0 10px 40px rgba(0,0,0,0.3);
        }
        .music-btn {
            width: 45px; height: 45px;
            background: linear-gradient(135deg, var(--primary), var(--secondary));
            border: none;
            border-radius: 50%;
            color: white;
            cursor: pointer;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 1rem;
            transition: 0.3s;
        }
        .music-btn:hover { transform: scale(1.1); }
        .music-info strong { display: block; font-size: 0.9rem; }
        .music-info span { font-size: 0.75rem; color: rgba(255,255,255,0.5); }
        .eq {
            display: flex;
            gap: 3px;
            height: 25px;
            align-items: flex-end;
        }
        .eq-bar {
            width: 4px;
            background: linear-gradient(to top, var(--primary), var(--secondary));
            border-radius: 5px;
            animation: eqMove 0.8s infinite;
        }
        .eq-bar:nth-child(2) { animation-delay: 0.1s; }
        .eq-bar:nth-child(3) { animation-delay: 0.2s; }
        .eq-bar:nth-child(4) { animation-delay: 0.3s; }
        .eq-bar:nth-child(5) { animation-delay: 0.15s; }
        .eq-bar.paused { height: 4px !important; animation: none; }
        @keyframes eqMove {
            0%, 100% { height: 5px; }
            50% { height: 25px; }
        }

        /* ===== RESPONSIVE ===== */
        @media (max-width: 1000px) {
            .hero-content { flex-direction: column; text-align: center; }
            .anime-frame { width: 280px; height: 360px; }
            .badge { display: none; }
            .hero-title { font-size: 2.8rem; }
            .hero-btns { justify-content: center; }
            .about-grid, .contact-grid { grid-template-columns: 1fr; }
            .portfolio-grid { grid-template-columns: 1fr 1fr; }
            .portfolio-glass.featured { grid-column: span 2; }
            nav { padding: 12px 25px; gap: 20px; }
            nav a { font-size: 0.8rem; }
        }
        @media (max-width: 600px) {
            .portfolio-grid { grid-template-columns: 1fr; }
            .portfolio-glass.featured { grid-column: span 1; }
            .stats-grid { grid-template-columns: 1fr; }
            .hero-title { font-size: 2.2rem; }
            nav { display: none; }
            .loader-text { font-size: 1.5rem; }
            .loader-avatar-container { width: 150px; height: 150px; }
            .loader-anime { width: 80px; height: 80px; }
            .ring-1 { width: 110px; height: 110px; }
            .ring-2 { width: 130px; height: 130px; }
            .ring-3 { width: 150px; height: 150px; }
        }
    </style>
</head>
<body>

    <!-- CUSTOM CURSOR -->
    <div class="cursor"></div>
    <div class="cursor-dot"></div>

    <!-- EPIC LOADING SCREEN -->
    <div class="loader" id="loader">
        <!-- Animated Background -->
        <div class="loader-bg"></div>
        
        <!-- Floating Particles -->
        <div class="loader-particles" id="loaderParticles"></div>
        
        <!-- Scan Line Effect -->
        <div class="scan-line"></div>
        
        <!-- Corner Decorations -->
        <div class="loader-corner corner-tl"></div>
        <div class="loader-corner corner-tr"></div>
        <div class="loader-corner corner-bl"></div>
        <div class="loader-corner corner-br"></div>

        <!-- Main Content -->
        <div class="loader-content">
            <!-- Avatar with Energy Rings -->
            <div class="loader-avatar-container">
                <div class="loader-anime"></div>
                <div class="energy-ring ring-1"></div>
                <div class="energy-ring ring-2"></div>
                <div class="energy-ring ring-3"></div>
                <div class="orbit-dot"></div>
                <div class="orbit-dot"></div>
                <div class="orbit-dot"></div>
                <div class="orbit-dot"></div>
            </div>
            
            <!-- Glitch Text -->
            <h1 class="loader-text">SUMAL</h1>
            
            <!-- Status -->
            <p class="loader-status" id="loaderStatus">Initializing System...</p>
            
            <!-- Progress Bar -->
            <div class="loader-progress-container">
                <span class="loader-percentage" id="loaderPercent">0%</span>
                <div class="loader-bar">
                    <div class="loader-progress" id="loaderProgress"></div>
                </div>
            </div>
            
            <!-- Tips -->
            <div class="loader-tips">
                <i class="fas fa-info-circle"></i>
                <span id="loaderTip">Crafting digital experiences...</span>
            </div>
        </div>
    </div>

    <!-- CHERRY BLOSSOM CONTAINER -->
    <div id="sakura-container"></div>

    <!-- ANIMATED BACKGROUND -->
    <div class="bg-container">
        <div class="orb orb-1"></div>
        <div class="orb orb-2"></div>
        <div class="orb orb-3"></div>
        <div class="grid-overlay"></div>
    </div>

    <!-- NAVIGATION -->
    <nav>
        <a href="#home">Home</a>
        <a href="#about">About</a>
        <a href="#skills">Skills</a>
        <a href="#portfolio">Work</a>
        <a href="#contact">Contact</a>
    </nav>

    <!-- HERO SECTION -->
    <section class="hero" id="home">
        <div class="hero-content">
            <div class="hero-anime">
                <div class="anime-frame">
                    <img src="https://files.catbox.moe/nu8sfy.jfif" class="anime-img">
                </div>
                <div class="badge badge-1"><i class="fas fa-star"></i> Top Creator</div>
                <div class="badge badge-2"><i class="fas fa-fire"></i> Cool</div>
                <div class="badge badge-3"><i class="fas fa-heart"></i> Verified</div>
            </div>

            <div class="hero-text">
                <div class="hero-subtitle">Welcome to my site</div>
                <h1 class="hero-title">I'm <span>SUMAL</span></h1>
                <p class="hero-japanese">スマル • デザイナー</p>
                <div class="typing-container">
                    <span class="typing-text"></span>
                </div>
                <div class="hero-btns">
                    <a href="#contact" class="btn-glow">Let's Connect <i class="fas fa-arrow-right"></i></a>
                    <a href="#portfolio" class="btn-glass">View Portfolio</a>
                </div>
            </div>
        </div>
    </section>

    <!-- ABOUT SECTION -->
    <section id="about">
        <div class="section-title reveal">
            <h2>About <span>Me</span></h2>
            <p>Get to know the person behind the screen</p>
            <p class="jp">私について</p>
        </div>

        <div class="about-grid">
            <div class="about-anime reveal">
                <img src="https://files.catbox.moe/a7pf56.jpeg" alt="Anime About" class="about-anime-img">
            </div>
            <div class="about-content reveal">
                <h3>Creative Soul & Digital Artist</h3>
                <p>Hey there! I'm Sumal — a passionate creator who lives at the intersection of art and technology.</p>
                <p>When I'm not designing or coding, you'll find me watching anime, exploring new art styles, or creating content that inspires others.</p>
                
                <div class="stats-grid">
                    <div class="stat-glass">
                        <h4 data-target="100">0</h4>
                        <p>Projects Done</p>
                    </div>
                    <div class="stat-glass">
                        <h4 data-target="50">0</h4>
                        <p>Happy Clients</p>
                    </div>
                    <div class="stat-glass">
                        <h4 data-target="10">0</h4>
                        <p>Awards Won</p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- SKILLS SECTION -->
    <section id="skills">
        <div class="section-title reveal">
            <h2>My <span>Skills</span></h2>
            <p>Technologies & Tools I Master</p>
            <p class="jp">スキル</p>
        </div>

        <div class="skills-grid">
            <div class="skill-holo reveal">
                <div class="skill-icon"><i class="fas fa-palette"></i></div>
                <h4>UI/UX Design</h4>
                <p>Creating beautiful, intuitive interfaces.</p>
                <div class="skill-bar-container">
                    <div class="skill-bar-fill" data-width="95%"></div>
                </div>
            </div>
            <div class="skill-holo reveal">
                <div class="skill-icon"><i class="fas fa-code"></i></div>
                <h4>Web Development</h4>
                <p>Building responsive, modern websites.</p>
                <div class="skill-bar-container">
                    <div class="skill-bar-fill" data-width="90%"></div>
                </div>
            </div>
            <div class="skill-holo reveal">
                <div class="skill-icon"><i class="fas fa-film"></i></div>
                <h4>Motion Graphics</h4>
                <p>Stunning animations and effects.</p>
                <div class="skill-bar-container">
                    <div class="skill-bar-fill" data-width="85%"></div>
                </div>
            </div>
        </div>
    </section>

    <!-- PORTFOLIO SECTION -->
    <section id="portfolio">
        <div class="section-title reveal">
            <h2>My <span>Work</span></h2>
            <p>Selected projects I'm proud of</p>
            <p class="jp">ポートフォリオ</p>
        </div>

        <div class="portfolio-grid">
            <div class="portfolio-glass featured reveal">
                <img src="https://i.pinimg.com/736x/c1/d2/e3/c1d2e3f4a5b6c7d8e9f0a1b2c3d4e5f6.jpg" alt="Work">
                <div class="portfolio-overlay">
                    <h4>Anime Dashboard</h4>
                    <p>UI/UX Design</p>
                </div>
            </div>
            <div class="portfolio-glass reveal">
                <img src="https://i.pinimg.com/originals/5e/6f/7a/5e6f7a8b9c0d1e2f3a4b5c6d7e8f9a0b.jpg" alt="Work">
                <div class="portfolio-overlay">
                    <h4>Gaming App</h4>
                    <p>Mobile Design</p>
                </div>
            </div>
            <div class="portfolio-glass reveal">
                <img src="https://i.pinimg.com/736x/2a/3b/4c/2a3b4c5d6e7f8a9b0c1d2e3f4a5b6c7d.jpg" alt="Work">
                <div class="portfolio-overlay">
                    <h4>Brand Identity</h4>
                    <p>Branding</p>
                </div>
            </div>
        </div>
    </section>

    <!-- CONTACT SECTION -->
    <section id="contact">
        <div class="section-title reveal">
            <h2>Get In <span>Touch</span></h2>
            <p>Let's create something amazing together</p>
            <p class="jp">お問い合わせ</p>
        </div>

        <div class="contact-grid">
            <div class="contact-info-glass reveal">
                <h3>Let's Talk!</h3>
                <p>Have a project in mind? I'd love to hear from you!</p>

                <div class="contact-item">
                    <div class="contact-icon"><i class="fas fa-envelope"></i></div>
                    <div class="contact-item-text">
                        <span>Email Me</span>
                        <p>hello@sumal.design</p>
                    </div>
                </div>
                <div class="contact-item">
                    <div class="contact-icon"><i class="fab fa-discord"></i></div>
                    <div class="contact-item-text">
                        <span>Discord</span>
                        <p>sumal#0001</p>
                    </div>
                </div>
            </div>

            <form class="form-glass reveal">
                <div class="form-row">
                    <div class="form-group">
                        <label>Your Name</label>
                        <input type="text" placeholder="John Doe" required>
                    </div>
                    <div class="form-group">
                        <label>Your Email</label>
                        <input type="email" placeholder="john@example.com" required>
                    </div>
                </div>
                <div class="form-group">
                    <label>Message</label>
                    <textarea placeholder="Tell me about your project..."></textarea>
                </div>
                <button type="submit" class="btn-glow">Send Message <i class="fas fa-paper-plane"></i></button>
            </form>
        </div>
    </section>

    <!-- FOOTER -->
    <footer>
        <div class="social-glass">
            <a href="#"><i class="fab fa-instagram"></i></a>
            <a href="#"><i class="fab fa-twitter"></i></a>
            <a href="#"><i class="fab fa-discord"></i></a>
            <a href="#"><i class="fab fa-github"></i></a>
        </div>
        <p>© 2024 <span>SUMAL</span>. Made with 💜</p>
    </footer>

    <!-- MUSIC PLAYER -->
    <div class="music-float">
        <button class="music-btn" onclick="toggleMusic()">
            <i class="fas fa-play" id="playIcon"></i>
        </button>
        <div class="music-info">
            <strong>Lofi Vibes</strong>
            <span>Anime Beats</span>
        </div>
        <div class="eq">
            <div class="eq-bar paused"></div>
            <div class="eq-bar paused"></div>
            <div class="eq-bar paused"></div>
            <div class="eq-bar paused"></div>
            <div class="eq-bar paused"></div>
        </div>
    </div>
    <audio id="bgMusic" loop>
        <source src="https://www.soundhelix.com/examples/mp3/SoundHelix-Song-3.mp3" type="audio/mpeg">
    </audio>

    <script>
        // ===== EPIC LOADER =====
        const statusMessages = [
            'Initializing System...',
            'Loading Assets...',
            'Connecting to Matrix...',
            'Syncing Data...',
            'Preparing Interface...',
            'Almost Ready...',
            'Welcome!'
        ];
        
        const tips = [
            'Crafting digital experiences...',
            'Blending art with technology...',
            'Creating pixel-perfect designs...',
            'Brewing creative magic...',
            'Loading awesome content...'
        ];
        
        let progress = 0;
        let statusIndex = 0;
        let tipIndex = 0;
        
        // Create loader particles
        const particleContainer = document.getElementById('loaderParticles');
        for (let i = 0; i < 30; i++) {
            const particle = document.createElement('div');
            particle.className = 'l-particle';
            particle.style.left = Math.random() * 100 + '%';
            particle.style.animationDelay = Math.random() * 3 + 's';
            particle.style.animationDuration = (Math.random() * 2 + 2) + 's';
            particleContainer.appendChild(particle);
        }
        
        // Animate progress
        const progressBar = document.getElementById('loaderProgress');
        const percentText = document.getElementById('loaderPercent');
        const statusText = document.getElementById('loaderStatus');
        const tipText = document.getElementById('loaderTip');
        
        const progressInterval = setInterval(() => {
            progress += Math.random() * 3 + 1;
            if (progress > 100) progress = 100;
            
            progressBar.style.width = progress + '%';
            percentText.textContent = Math.floor(progress) + '%';
            
            // Update status based on progress
            const newStatusIndex = Math.floor(progress / 15);
            if (newStatusIndex !== statusIndex && newStatusIndex < statusMessages.length) {
                statusIndex = newStatusIndex;
                statusText.textContent = statusMessages[statusIndex];
            }
            
            if (progress >= 100) {
                clearInterval(progressInterval);
                statusText.textContent = 'Welcome!';
                setTimeout(() => {
                    document.getElementById('loader').classList.add('hidden');
                }, 500);
            }
        }, 50);
        
        // Rotate tips
        setInterval(() => {
            tipIndex = (tipIndex + 1) % tips.length;
            tipText.style.opacity = 0;
            setTimeout(() => {
                tipText.textContent = tips[tipIndex];
                tipText.style.opacity = 1;
            }, 300);
        }, 2500);

        // ===== SAKURA PARTICLES =====
        function createSakura() {
            const container = document.getElementById('sakura-container');
            const sakura = document.createElement('div');
            sakura.classList.add('sakura');
            sakura.style.left = Math.random() * 100 + 'vw';
            sakura.style.animationDuration = Math.random() * 5 + 8 + 's';
            sakura.style.opacity = Math.random() * 0.5 + 0.3;
            container.appendChild(sakura);
            setTimeout(() => sakura.remove(), 13000);
        }
        setInterval(createSakura, 300);

        // ===== CURSOR =====
        const cursor = document.querySelector('.cursor');
        const cursorDot = document.querySelector('.cursor-dot');

        document.addEventListener('mousemove', (e) => {
            cursor.style.left = e.clientX + 'px';
            cursor.style.top = e.clientY + 'px';
            cursorDot.style.left = e.clientX + 'px';
            cursorDot.style.top = e.clientY + 'px';
        });

        document.querySelectorAll('a, button, .portfolio-glass, .skill-holo').forEach(el => {
            el.addEventListener('mouseenter', () => cursor.classList.add('hover'));
            el.addEventListener('mouseleave', () => cursor.classList.remove('hover'));
        });

        // ===== TYPING EFFECT =====
        const typingEl = document.querySelector('.typing-text');
        const words = ['Digital Artist ✨', 'UI/UX Designer 🎨', 'Creative 💜', 'Web Developer 💻'];
        let wordIdx = 0, charIdx = 0, isDeleting = false;

        function typeEffect() {
            const currentWord = words[wordIdx];
            typingEl.textContent = isDeleting 
                ? currentWord.substring(0, charIdx--) 
                : currentWord.substring(0, charIdx++);

            if (!isDeleting && charIdx === currentWord.length) {
                setTimeout(() => isDeleting = true, 2000);
            } else if (isDeleting && charIdx === 0) {
                isDeleting = false;
                wordIdx = (wordIdx + 1) % words.length;
            }
            setTimeout(typeEffect, isDeleting ? 50 : 100);
        }
        setTimeout(typeEffect, 3500);

        // ===== SCROLL REVEAL =====
        const reveals = document.querySelectorAll('.reveal');
        function revealScroll() {
            reveals.forEach(el => {
                if (el.getBoundingClientRect().top < window.innerHeight - 100) {
                    el.classList.add('active');
                }
            });
        }
        window.addEventListener('scroll', revealScroll);
        revealScroll();

        // ===== SKILL BARS =====
        window.addEventListener('scroll', () => {
            document.querySelectorAll('.skill-bar-fill').forEach(bar => {
                if (bar.getBoundingClientRect().top < window.innerHeight && !bar.style.width) {
                    bar.style.width = bar.getAttribute('data-width');
                }
            });
        });

        // ===== STATS COUNTER =====
        let counted = false;
        window.addEventListener('scroll', () => {
            if (counted) return;
            const aboutSection = document.getElementById('about');
            if (aboutSection.getBoundingClientRect().top < window.innerHeight - 200) {
                counted = true;
                document.querySelectorAll('.stat-glass h4').forEach(num => {
                    const target = +num.getAttribute('data-target');
                    let count = 0;
                    const increment = target / 80;
                    const updateCount = () => {
                        if (count < target) {
                            count += increment;
                            num.textContent = Math.ceil(count);
                            requestAnimationFrame(updateCount);
                        } else {
                            num.textContent = target + '+';
                        }
                    };
                    updateCount();
                });
            }
        });

        // ===== MUSIC PLAYER =====
        const audio = document.getElementById('bgMusic');
        const playIcon = document.getElementById('playIcon');
        const eqBars = document.querySelectorAll('.eq-bar');
        let isPlaying = false;

        function toggleMusic() {
            if (isPlaying) {
                audio.pause();
                playIcon.classList.replace('fa-pause', 'fa-play');
                eqBars.forEach(b => b.classList.add('paused'));
            } else {
                audio.play();
                playIcon.classList.replace('fa-play', 'fa-pause');
                eqBars.forEach(b => b.classList.remove('paused'));
            }
            isPlaying = !isPlaying;
        }

        // ===== SMOOTH SCROLL =====
        document.querySelectorAll('nav a').forEach(link => {
            link.addEventListener('click', e => {
                e.preventDefault();
                document.querySelector(link.getAttribute('href')).scrollIntoView({ behavior: 'smooth' });
            });
        });
    </script>
</body>
</html>