<?php
// bot.php - Telegram Bot with Webhook Support (FIXED VERSION)

// ===== ERROR REPORTING =====
error_reporting(E_ALL);
ini_set('display_errors', 1);

// ===== CONFIGURATION =====
define('BOT_TOKEN', '8569654657:AAFQlb2Llt6FvKtbftNV1FwdklT-TKv5VxM');
define('TARGET_GROUP_ID', -1003248802557);
define('ADMIN_ID', [7595358595, 8137611408]);
define('DATABASE_FILE', 'users_db.json');
define('PAYMENT_FILE', 'payments.json'); // NEW: Persistent payment storage
define('PENDING_FILE', 'pending_payments.json'); // NEW: Pending payments
define('UPI_ID', 'sumal.somu@ptyes');
define('PAYMENT_QR', 'https://files.catbox.moe/lmal2k.jpg');
define('ADMIN_USERNAME', '@Are_lqdaa');

// ===== PRICING =====
$PACKAGES = [
    20 => 100,
    50 => 500,
    80 => 1000,
    300 => 5000
];

// ===== STORAGE =====
$users_db = [];
$payment_data = [];
$pending_payments = [];

// ===== LOGGING =====
function log_message($level, $message) {
    $log_entry = date('Y-m-d H:i:s') . " - $level - $message\n";
    file_put_contents('bot.log', $log_entry, FILE_APPEND);
    
    if ($level === 'ERROR' || $level === 'INFO') {
        echo $log_entry;
    }
}

// ===== DATABASE FUNCTIONS =====
function load_db() {
    if (file_exists(DATABASE_FILE)) {
        try {
            $content = file_get_contents(DATABASE_FILE);
            return json_decode($content, true) ?: [];
        } catch (Exception $e) {
            log_message('ERROR', "Error loading database: " . $e->getMessage());
            return [];
        }
    }
    return [];
}

function save_db($db) {
    try {
        file_put_contents(DATABASE_FILE, json_encode($db, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
        return true;
    } catch (Exception $e) {
        log_message('ERROR', "Error saving database: " . $e->getMessage());
        return false;
    }
}

// ===== PAYMENT DATA FUNCTIONS (FIX) =====
function load_payment_data() {
    if (file_exists(PAYMENT_FILE)) {
        try {
            $content = file_get_contents(PAYMENT_FILE);
            return json_decode($content, true) ?: [];
        } catch (Exception $e) {
            log_message('ERROR', "Error loading payment data: " . $e->getMessage());
            return [];
        }
    }
    return [];
}

function save_payment_data($data) {
    try {
        file_put_contents(PAYMENT_FILE, json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
        return true;
    } catch (Exception $e) {
        log_message('ERROR', "Error saving payment data: " . $e->getMessage());
        return false;
    }
}

// ===== PENDING PAYMENTS FUNCTIONS (NEW) =====
function load_pending_payments() {
    if (file_exists(PENDING_FILE)) {
        try {
            $content = file_get_contents(PENDING_FILE);
            return json_decode($content, true) ?: [];
        } catch (Exception $e) {
            log_message('ERROR', "Error loading pending payments: " . $e->getMessage());
            return [];
        }
    }
    return [];
}

function save_pending_payments($data) {
    try {
        file_put_contents(PENDING_FILE, json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
        return true;
    } catch (Exception $e) {
        log_message('ERROR', "Error saving pending payments: " . $e->getMessage());
        return false;
    }
}

// ===== CHECK DUPLICATE UTR (NEW) =====
function check_duplicate_utr($utr) {
    $pending = load_pending_payments();
    foreach ($pending as $payment) {
        if (isset($payment['utr']) && strtolower($payment['utr']) === strtolower($utr)) {
            return true;
        }
    }
    return false;
}

function init_user($user_id, $name) {
    global $users_db;
    
    if (!isset($users_db[$user_id])) {
        $users_db[$user_id] = [
            "name" => $name,
            "posts" => 0,
            "sent" => 0,
            "purchased" => 0,
            "joined" => date('c'),
            "payment_history" => [] // NEW: Track payment history
        ];
        save_db($users_db);
    }
}

// ===== TELEGRAM API =====
function send_message($chat_id, $text, $reply_markup = null, $parse_mode = 'HTML') {
    $url = "https://api.telegram.org/bot" . BOT_TOKEN . "/sendMessage";
    
    $data = [
        'chat_id' => $chat_id,
        'text' => $text,
        'parse_mode' => $parse_mode,
        'disable_web_page_preview' => true
    ];
    
    if ($reply_markup) {
        $data['reply_markup'] = json_encode($reply_markup);
    }
    
    return make_request($url, $data);
}

function send_photo($chat_id, $photo, $caption = '', $reply_markup = null, $parse_mode = 'HTML') {
    $url = "https://api.telegram.org/bot" . BOT_TOKEN . "/sendPhoto";
    
    $data = [
        'chat_id' => $chat_id,
        'photo' => $photo,
        'caption' => $caption,
        'parse_mode' => $parse_mode
    ];
    
    if ($reply_markup) {
        $data['reply_markup'] = json_encode($reply_markup);
    }
    
    return make_request($url, $data);
}

function forward_message($from_chat_id, $message_id) {
    $url = "https://api.telegram.org/bot" . BOT_TOKEN . "/forwardMessage";
    
    $data = [
        'chat_id' => TARGET_GROUP_ID,
        'from_chat_id' => $from_chat_id,
        'message_id' => $message_id
    ];
    
    return make_request($url, $data);
}

function answer_callback_query($callback_query_id, $text = '') {
    $url = "https://api.telegram.org/bot" . BOT_TOKEN . "/answerCallbackQuery";
    
    $data = [
        'callback_query_id' => $callback_query_id,
        'text' => $text
    ];
    
    return make_request($url, $data);
}

function delete_message($chat_id, $message_id) {
    $url = "https://api.telegram.org/bot" . BOT_TOKEN . "/deleteMessage";
    
    $data = [
        'chat_id' => $chat_id,
        'message_id' => $message_id
    ];
    
    return make_request($url, $data);
}

function make_request($url, $data) {
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 10);
    
    $response = curl_exec($ch);
    curl_close($ch);
    
    return json_decode($response, true);
}

// ===== KEYBOARDS =====
function main_menu() {
    return [
        'keyboard' => [
            [
                ['text' => '💰 My Balance'],
                ['text' => '🛒 Buy Posts']
            ],
            [
                ['text' => '📜 Payment History'],
                ['text' => '❓ Help']
            ],
            [
                ['text' => '📞 Support']
            ]
        ],
        'resize_keyboard' => true,
        'one_time_keyboard' => false
    ];
}

function buy_menu() {
    return [
        'inline_keyboard' => [
            [
                ['text' => '💳 Pay Now (UPI)', 'callback_data' => 'pay']
            ],
            [
                ['text' => '💬 Contact Admin', 'callback_data' => 'admin']
            ],
            [
                ['text' => '🔙 Back', 'callback_data' => 'back']
            ]
        ]
    ];
}

// ===== START =====
function handle_start($chat_id, $user_id, $name) {
    global $users_db;
    
    if (!isset($users_db[$user_id])) {
        init_user($user_id, $name);
    }
    
    $welcome = "━━━━━━━━━━━━━━━━━━━━
🚀 <b>MESSAGE FORWARD BOT</b> 🚀
━━━━━━━━━━━━━━━━━━━━

<b>✨ What We Do:</b>
Forward your messages to our exclusive group instantly!

<b>💰 Pricing Plans:</b>

┏━━━━━━━━━━━━━┓
┃  100 Posts → ₹20
┃  500 Posts → ₹50
┃ 1000 Posts → ₹80
┃ 5000 Posts → ₹300
┗━━━━━━━━━━━━━┛

<b>⚡ How It Works:</b>
1️⃣ Buy post credits
2️⃣ Send any message here
3️⃣ We forward to group
4️⃣ Everyone sees it!

<b>📱 Supported:</b>
✓ Text  ✓ Photos  ✓ Videos  ✓ Docs

━━━━━━━━━━━━━━━━━━━━
👇 <i>Use buttons below to start</i> 👇";
    
    send_message($chat_id, $welcome, main_menu());
}

// ===== MY BALANCE =====
function handle_balance($chat_id, $user_id, $name) {
    global $users_db;
    
    if (!isset($users_db[$user_id])) {
        init_user($user_id, $name);
    }
    
    $user = $users_db[$user_id];
    $posts = $user['posts'] ?? 0;
    $sent = $user['sent'] ?? 0;
    $purchased = $user['purchased'] ?? 0;
    
    if ($posts > 50) {
        $status = "🟢";
        $status_text = "Active";
    } elseif ($posts > 0) {
        $status = "🟡";
        $status_text = "Low Balance";
    } else {
        $status = "🔴";
        $status_text = "Out of Credits";
    }
    
    $balance = "━━━━━━━━━━━━━━━━━━━━
💰 <b>MY BALANCE</b> 💰
━━━━━━━━━━━━━━━━━━━━

$status <b>Status:</b> $status_text

━━━━━━━━━━━━━━━━━━━━

💎 <b>Posts Remaining:</b>
<code>$posts</code>

📨 <b>Messages Sent:</b>
$sent

🛒 <b>Total Purchased:</b>
{$purchased} posts

━━━━━━━━━━━━━━━━━━━━";
    
    if ($posts <= 0) {
        $balance .= "\n\n⚠️ <b>Out of credits!</b>\n👇 Buy more to continue posting";
    } elseif ($posts <= 10) {
        $balance .= "\n\n⚠️ <b>Low balance warning!</b>\n👇 Consider buying more";
    } else {
        $balance .= "\n\n✅ <b>You're all set!</b>\nJust forward messages to post.";
    }
    
    $keyboard = [
        'inline_keyboard' => [
            [
                ['text' => '🛒 Buy More Posts', 'callback_data' => 'pay']
            ],
            [
                ['text' => '🔙 Back to Menu', 'callback_data' => 'back']
            ]
        ]
    ];
    
    send_message($chat_id, $balance, $keyboard);
}

// ===== BUY POSTS =====
function handle_buy_posts($chat_id) {
    global $PACKAGES;
    
    $pricing = "━━━━━━━━━━━━━━━━━━━━
🛒 <b>PRICING PLANS</b> 🛒
━━━━━━━━━━━━━━━━━━━━

<b>Choose Your Package:</b>

┏━━━━━━━━━━━━━━━┓
┃ 🔰 <b>Starter Pack</b>
┃ 100 Posts → ₹20
┃ <i>₹0.20 per post</i>
┗━━━━━━━━━━━━━━━┛

┏━━━━━━━━━━━━━━━┓
┃ ⭐ <b>Basic Pack</b>
┃ 500 Posts → ₹50
┃ <i>₹0.10 per post</i>
┗━━━━━━━━━━━━━━━┛

┏━━━━━━━━━━━━━━━┓
┃ 💎 <b>Pro Pack</b>
┃ 1000 Posts → ₹80
┃ <i>₹0.08 per post</i>
┗━━━━━━━━━━━━━━━┛

┏━━━━━━━━━━━━━━━┓
┃ 👑 <b>Premium Pack</b>
┃ 5000 Posts → ₹300
┃ <i>₹0.06 per post</i>
┗━━━━━━━━━━━━━━━┛

━━━━━━━━━━━━━━━━━━━━
💳 <i>Instant activation!</i>
💡 <i>Custom amounts also accepted!</i>";
    
    send_message($chat_id, $pricing, buy_menu());
}

// ===== PAYMENT HISTORY (NEW) =====
function handle_payment_history($chat_id, $user_id, $name) {
    global $users_db;
    
    if (!isset($users_db[$user_id])) {
        init_user($user_id, $name);
    }
    
    $history = $users_db[$user_id]['payment_history'] ?? [];
    
    if (empty($history)) {
        $msg = "━━━━━━━━━━━━━━━━━━━━
📜 <b>PAYMENT HISTORY</b> 📜
━━━━━━━━━━━━━━━━━━━━

📭 No payment history yet!

Make your first purchase to see it here.

━━━━━━━━━━━━━━━━━━━━";
        
        $keyboard = [
            'inline_keyboard' => [
                [
                    ['text' => '🛒 Buy Posts', 'callback_data' => 'pay']
                ],
                [
                    ['text' => '🔙 Back', 'callback_data' => 'back']
                ]
            ]
        ];
    } else {
        $msg = "━━━━━━━━━━━━━━━━━━━━
📜 <b>PAYMENT HISTORY</b> 📜
━━━━━━━━━━━━━━━━━━━━

";
        
        $count = 1;
        foreach (array_reverse($history) as $payment) {
            $status_icon = $payment['status'] == 'approved' ? '✅' : ($payment['status'] == 'rejected' ? '❌' : '⏳');
            $msg .= "<b>$count. $status_icon " . ucfirst($payment['status']) . "</b>\n";
            $msg .= "   Amount: ₹{$payment['amount']}\n";
            $msg .= "   Posts: {$payment['posts']}\n";
            $msg .= "   Date: {$payment['date']}\n";
            if (isset($payment['utr'])) {
                $msg .= "   UTR: {$payment['utr']}\n";
            }
            $msg .= "\n";
            $count++;
            
            if ($count > 10) break; // Show last 10 payments
        }
        
        $msg .= "━━━━━━━━━━━━━━━━━━━━";
        
        $keyboard = [
            'inline_keyboard' => [
                [
                    ['text' => '🔙 Back', 'callback_data' => 'back']
                ]
            ]
        ];
    }
    
    send_message($chat_id, $msg, $keyboard);
}

// ===== HELP =====
function handle_help($chat_id) {
    $help_text = "━━━━━━━━━━━━━━━━━━━━
❓ <b>HELP GUIDE</b> ❓
━━━━━━━━━━━━━━━━━━━━

<b>🎯 Getting Started:</b>

1️⃣ <b>Buy Credits</b>
   Click \"🛒 Buy Posts\"
   Choose a package
   Complete payment

2️⃣ <b>Post Messages</b>
   Just send any message here
   We'll forward to group
   1 message = 1 credit

3️⃣ <b>Check Balance</b>
   Click \"💰 My Balance\"
   View remaining posts

━━━━━━━━━━━━━━━━━━━━

<b>💳 Payment Steps:</b>

• Click \"Pay Now\"
• Scan QR / Use UPI
• Pay the amount
• Send screenshot
• Enter amount & UTR
• Wait for approval (1-2h)

━━━━━━━━━━━━━━━━━━━━

<b>📞 Need Help?</b>
Contact: " . ADMIN_USERNAME;
    
    $keyboard = [
        'inline_keyboard' => [
            [
                ['text' => '🔙 Back to Menu', 'callback_data' => 'back']
            ]
        ]
    ];
    
    send_message($chat_id, $help_text, $keyboard);
}

// ===== SUPPORT =====
function handle_support($chat_id) {
    $support_text = "━━━━━━━━━━━━━━━━━━━━
📞 <b>SUPPORT</b> 📞
━━━━━━━━━━━━━━━━━━━━

<b>👤 Admin Contact:</b>
" . ADMIN_USERNAME . "

<b>⏰ Response Time:</b>
Usually within 1-2 hours

<b>💬 We Help With:</b>
✓ Payment issues
✓ Technical problems  
✓ Bulk orders
✓ Custom packages

━━━━━━━━━━━━━━━━━━━━";
    
    $keyboard = [
        'inline_keyboard' => [
            [
                ['text' => '💬 Message Admin', 'url' => 'https://t.me/' . substr(ADMIN_USERNAME, 1)]
            ],
            [
                ['text' => '🔙 Back to Menu', 'callback_data' => 'back']
            ]
        ]
    ];
    
    send_message($chat_id, $support_text, $keyboard);
}

// ===== CALLBACK HANDLERS =====
function handle_callback($callback_query, $chat_id, $user_id, $message_id) {
    global $payment_data;
    
    $data = $callback_query['data'];
    answer_callback_query($callback_query['id']);
    
    if ($data == 'back') {
        // Clear payment session
        $payment_data = load_payment_data();
        if (isset($payment_data[$user_id])) {
            unset($payment_data[$user_id]);
            save_payment_data($payment_data);
        }
        
        try {
            delete_message($chat_id, $message_id);
        } catch (Exception $e) {
            // Ignore
        }
        
        $welcome = "━━━━━━━━━━━━━━━━━━━━
🚀 <b>MESSAGE FORWARD BOT</b> 🚀
━━━━━━━━━━━━━━━━━━━━

<b>✨ What We Do:</b>
Forward your messages to our exclusive group instantly!

<b>💰 Pricing Plans:</b>

┏━━━━━━━━━━━━━┓
┃  100 Posts → ₹20
┃  500 Posts → ₹50
┃ 1000 Posts → ₹80
┃ 5000 Posts → ₹300
┗━━━━━━━━━━━━━┛

<b>⚡ How It Works:</b>
1️⃣ Buy post credits
2️⃣ Send any message here
3️⃣ We forward to group
4️⃣ Everyone sees it!

<b>📱 Supported:</b>
✓ Text  ✓ Photos  ✓ Videos  ✓ Docs

━━━━━━━━━━━━━━━━━━━━
👇 <i>Use buttons below to start</i> 👇";
        
        send_message($chat_id, $welcome, main_menu());
        
    } elseif ($data == 'pay') {
        // Start payment session
        $payment_data = load_payment_data();
        $payment_data[$user_id] = [
            "step" => 1,
            "started_at" => time()
        ];
        save_payment_data($payment_data);
        
        $payment_info = "━━━━━━━━━━━━━━━━━━━━
💳 <b>UPI PAYMENT</b> 💳
━━━━━━━━━━━━━━━━━━━━

<b>UPI ID:</b> <code>" . UPI_ID . "</code>
<i>(Tap to copy)</i>

<b>📱 Steps:</b>

1️⃣ Scan QR or copy UPI ID
2️⃣ Enter amount (any amount ₹10+)
3️⃣ Complete payment
4️⃣ Send screenshot HERE
5️⃣ Enter amount
6️⃣ Enter UTR number

━━━━━━━━━━━━━━━━━━━━

⏳ <b>Waiting for screenshot...</b>

Type /cancel to cancel payment";
        
        try {
            delete_message($chat_id, $message_id);
            send_photo($chat_id, PAYMENT_QR, $payment_info, main_menu());
        } catch (Exception $e) {
            log_message('ERROR', "Error showing payment: " . $e->getMessage());
            send_message($chat_id, $payment_info, main_menu());
        }
        
    } elseif ($data == 'admin') {
        $keyboard = [
            'inline_keyboard' => [
                [
                    ['text' => '💬 Open Chat', 'url' => 'https://t.me/' . substr(ADMIN_USERNAME, 1)]
                ],
                [
                    ['text' => '🔙 Back', 'callback_data' => 'back']
                ]
            ]
        ];
        
        send_message(
            $chat_id,
            "📞 <b>Contact Admin:</b> " . ADMIN_USERNAME . "\n\nSay: <i>Hi! I want to buy posts</i>",
            $keyboard
        );
    }
}

// ===== CANCEL PAYMENT =====
function handle_cancel($chat_id, $user_id) {
    $payment_data = load_payment_data();
    
    if (isset($payment_data[$user_id])) {
        unset($payment_data[$user_id]);
        save_payment_data($payment_data);
        send_message(
            $chat_id,
            "❌ <b>Payment Cancelled</b>\n\nYou can start again anytime by clicking 🛒 Buy Posts",
            main_menu()
        );
    } else {
        send_message($chat_id, "No active payment to cancel.", main_menu());
    }
}

// ===== PAYMENT PROCESSING (FIXED) =====
function process_payment($chat_id, $user_id, $name, $message) {
    global $users_db, $PACKAGES;
    
    // Load payment data from file
    $payment_data = load_payment_data();
    
    if (!isset($payment_data[$user_id])) {
        return false;
    }
    
    $step = $payment_data[$user_id]['step'] ?? 0;
    
    // Step 1: Screenshot
    if ($step == 1) {
        if (isset($message['photo'])) {
            $photos = $message['photo'];
            $last_photo = end($photos);
            $file_id = $last_photo['file_id'];
            
            $payment_data[$user_id]["screenshot"] = $file_id;
            $payment_data[$user_id]["step"] = 2;
            save_payment_data($payment_data); // SAVE STATE
            
            send_message(
                $chat_id,
                "✅ <b>Screenshot Received!</b>\n\n━━━━━━━━━━━━━━━━━━━━\n\n📝 Now send the <b>amount</b> you paid\n\nExample: <code>50</code> or <code>45</code>\n\n━━━━━━━━━━━━━━━━━━━━\n\n💡 <i>You can pay any amount ₹10-₹10,000!</i>\n\nType /cancel to cancel",
                main_menu()
            );
            return true;
        } else {
            send_message(
                $chat_id,
                "❌ Please send a screenshot image!\n\nType /cancel to cancel payment",
                main_menu()
            );
            return true;
        }
    
    // Step 2: Amount
    } elseif ($step == 2) {
        if (isset($message['text'])) {
            $text = trim($message['text']);
            $text = preg_replace('/[₹Rsrs]/', '', $text);
            $text = trim($text);
            
            if (!is_numeric($text)) {
                send_message(
                    $chat_id,
                    "❌ Please send only numbers!\nExample: 50\n\nType /cancel to cancel",
                    main_menu()
                );
                return true;
            }
            
            $amount = (int)$text;
            
            if ($amount < 10 || $amount > 10000) {
                send_message(
                    $chat_id,
                    "❌ Invalid amount! Enter between ₹10-₹10,000\n\nType /cancel to cancel",
                    main_menu()
                );
                return true;
            }
            
            // Calculate posts
            if (isset($PACKAGES[$amount])) {
                $posts = $PACKAGES[$amount];
                $package_names = [20 => "🔰 Starter", 50 => "⭐ Basic", 80 => "💎 Pro", 300 => "👑 Premium"];
                $package_info = "\n📦 <b>Package:</b> " . $package_names[$amount] . "\n";
            } else {
                $posts = (int)($amount / 0.20);
                $package_info = "\n📦 <b>Package:</b> Custom Amount\n";
            }
            
            $payment_data[$user_id]["amount"] = $amount;
            $payment_data[$user_id]["posts"] = $posts;
            $payment_data[$user_id]["step"] = 3;
            save_payment_data($payment_data); // SAVE STATE
            
            send_message(
                $chat_id,
                "✅ <b>Amount: ₹$amount</b>$package_info📊 <b>Posts You'll Get: $posts</b>\n\n━━━━━━━━━━━━━━━━━━━━\n\n📝 Now send the <b>UTR/Transaction ID</b>\n\nExample: <code>123456789012</code>\n\n━━━━━━━━━━━━━━━━━━━━\n\nType /cancel to cancel",
                main_menu()
            );
            return true;
        } else {
            send_message(
                $chat_id,
                "❌ Please send the amount as text!\n\nType /cancel to cancel",
                main_menu()
            );
            return true;
        }
    
    // Step 3: UTR
    } elseif ($step == 3) {
        if (isset($message['text'])) {
            $utr = trim($message['text']);
            
            if (strlen($utr) < 6) {
                send_message(
                    $chat_id,
                    "❌ UTR too short! Please check and send again.\n\nType /cancel to cancel",
                    main_menu()
                );
                return true;
            }
            
            // Check duplicate UTR
            if (check_duplicate_utr($utr)) {
                send_message(
                    $chat_id,
                    "❌ <b>Duplicate UTR!</b>\n\nThis transaction ID has already been submitted.\n\nIf this is a mistake, contact: " . ADMIN_USERNAME,
                    main_menu()
                );
                
                // Clear payment session
                unset($payment_data[$user_id]);
                save_payment_data($payment_data);
                return true;
            }
            
            $payment_data[$user_id]["utr"] = $utr;
            $amount = $payment_data[$user_id]["amount"] ?? 0;
            $screenshot = $payment_data[$user_id]["screenshot"] ?? null;
            $posts = $payment_data[$user_id]["posts"] ?? 0;
            
            // Create unique payment ID
            $payment_id = time() . '_' . $user_id;
            
            // Save to pending payments
            $pending = load_pending_payments();
            $pending[$payment_id] = [
                'user_id' => $user_id,
                'user_name' => $name,
                'amount' => $amount,
                'posts' => $posts,
                'utr' => $utr,
                'screenshot' => $screenshot,
                'timestamp' => time(),
                'date' => date('d M Y, H:i'),
                'status' => 'pending'
            ];
            save_pending_payments($pending);
            
            // Notify admins
            $admin_msg = "━━━━━━━━━━━━━━━━━━━━
🔔 <b>NEW PAYMENT REQUEST</b>
━━━━━━━━━━━━━━━━━━━━

👤 <b>User:</b> $name
🆔 <b>ID:</b> <code>$user_id</code>

💰 <b>Amount:</b> ₹$amount
🔢 <b>UTR:</b> <code>$utr</code>
📦 <b>Posts:</b> $posts

🆔 <b>Payment ID:</b> <code>$payment_id</code>

⏰ " . date('d M Y, H:i') . "

━━━━━━━━━━━━━━━━━━━━

<b>Quick Actions:</b>
/approve $user_id $posts
/reject $payment_id";
            
            $sent_count = 0;
            foreach (ADMIN_ID as $admin_id) {
                try {
                    if ($screenshot) {
                        send_photo($admin_id, $screenshot, $admin_msg);
                    } else {
                        send_message($admin_id, $admin_msg);
                    }
                    $sent_count++;
                    log_message('INFO', "Payment notification sent to admin $admin_id");
                } catch (Exception $e) {
                    log_message('ERROR', "Failed to send to admin $admin_id: " . $e->getMessage());
                }
            }
            
            // Clear payment session
            unset($payment_data[$user_id]);
            save_payment_data($payment_data);
            
            if ($sent_count > 0) {
                send_message(
                    $chat_id,
                    "✅ <b>Payment Submitted Successfully!</b>\n\n━━━━━━━━━━━━━━━━━━━━\n\n📋 <b>Your Details:</b>\n• Payment ID: <code>$payment_id</code>\n• Amount: ₹$amount\n• UTR: $utr\n• Posts: $posts\n\n━━━━━━━━━━━━━━━━━━━━\n\n⏳ <b>What's Next?</b>\n\n✓ Admin will verify payment\n✓ Posts will be added\n✓ You'll get notification\n\n⏱️ Processing: 30 min - 2 hours\n\n━━━━━━━━━━━━━━━━━━━━\n\nThank you for your patience! 🙏",
                    main_menu()
                );
            } else {
                send_message(
                    $chat_id,
                    "⚠️ <b>Submission Saved</b>\n\nYour payment details:\n• Payment ID: <code>$payment_id</code>\n• Amount: ₹$amount\n• UTR: $utr\n\n⚠️ Could not reach admin automatically.\nPlease contact: " . ADMIN_USERNAME . "\n\nShow them these details.",
                    main_menu()
                );
            }
            
            log_message('INFO', "Payment process completed for user $user_id, payment ID: $payment_id");
            return true;
        } else {
            send_message(
                $chat_id,
                "❌ Please send UTR as text!\n\nType /cancel to cancel",
                main_menu()
            );
            return true;
        }
    }
    
    return false;
}

// ===== FORWARD MESSAGE =====
function forward_message_handler($chat_id, $user_id, $name, $message_id) {
    global $users_db;
    
    if (!isset($users_db[$user_id])) {
        init_user($user_id, $name);
    }
    
    $user = $users_db[$user_id];
    
    if (($user['posts'] ?? 0) <= 0) {
        $keyboard = [
            'inline_keyboard' => [
                [
                    ['text' => '🛒 Buy Posts', 'callback_data' => 'pay']
                ]
            ]
        ];
        
        send_message(
            $chat_id,
            "━━━━━━━━━━━━━━━━━━━━\n❌ <b>No credits left!</b>\n\n💰 Balance: <b>0 posts</b>\n\n━━━━━━━━━━━━━━━━━━━━\n\n👇 Click below to buy more",
            $keyboard
        );
        return;
    }
    
    try {
        $result = forward_message($chat_id, $message_id);
        
        if (isset($result['ok']) && $result['ok']) {
            $users_db[$user_id]['posts'] -= 1;
            $users_db[$user_id]['sent'] += 1;
            save_db($users_db);
            
            $remaining = $users_db[$user_id]['posts'];
            
            $msg = "━━━━━━━━━━━━━━━━━━━━\n✅ <b>Posted Successfully!</b>\n\n💰 Remaining: <b>$remaining posts</b>\n━━━━━━━━━━━━━━━━━━━━";
            
            if ($remaining <= 5) {
                $msg .= "\n\n⚠️ Low balance!";
                $keyboard = [
                    'inline_keyboard' => [
                        [
                            ['text' => '🛒 Buy More', 'callback_data' => 'pay']
                        ]
                    ]
                ];
                $markup = $keyboard;
            } else {
                $markup = main_menu();
            }
            
            send_message($chat_id, $msg, $markup);
        } else {
            throw new Exception($result['description'] ?? 'Unknown error');
        }
        
    } catch (Exception $e) {
        log_message('ERROR', "Forward error: " . $e->getMessage());
        send_message(
            $chat_id,
            "━━━━━━━━━━━━━━━━━━━━\n❌ <b>Failed to post</b>\n\n⚠️ Please make sure the bot is added to the target group.\n\n━━━━━━━━━━━━━━━━━━━━\n\nContact: " . ADMIN_USERNAME,
            main_menu()
        );
    }
}

// ===== MESSAGE HANDLER =====
function handle_message($chat_id, $user_id, $name, $message) {
    global $users_db;
    
    // Check if in payment process
    $payment_data = load_payment_data();
    if (isset($payment_data[$user_id])) {
        log_message('INFO', "User $user_id in payment process, step: " . ($payment_data[$user_id]['step'] ?? 0));
        process_payment($chat_id, $user_id, $name, $message);
        return;
    }
    
    if (isset($message['text'])) {
        $text = $message['text'];
        
        if ($text == "💰 My Balance") {
            handle_balance($chat_id, $user_id, $name);
        } elseif ($text == "🛒 Buy Posts") {
            handle_buy_posts($chat_id);
        } elseif ($text == "📜 Payment History") {
            handle_payment_history($chat_id, $user_id, $name);
        } elseif ($text == "❓ Help") {
            handle_help($chat_id);
        } elseif ($text == "📞 Support") {
            handle_support($chat_id);
        } else {
            // Try to forward as message
            forward_message_handler($chat_id, $user_id, $name, $message['message_id']);
        }
    } else {
        // Forward non-text messages
        forward_message_handler($chat_id, $user_id, $name, $message['message_id']);
    }
}

// ===== ADMIN: APPROVE (IMPROVED) =====
function handle_approve($chat_id, $user_id, $args) {
    global $users_db;
    
    if (!in_array($user_id, ADMIN_ID)) {
        return;
    }
    
    if (count($args) < 2) {
        send_message(
            $chat_id,
            "❌ <b>Usage:</b>\n<code>/approve user_id posts</code>\n\n<b>Example:</b>\n<code>/approve 123456789 100</code>"
        );
        return;
    }
    
    $target_user_id = $args[0];
    $posts = (int)$args[1];
    
    if (!isset($users_db[$target_user_id])) {
        $users_db[$target_user_id] = [
            "name" => "Unknown",
            "posts" => $posts,
            "sent" => 0,
            "purchased" => $posts,
            "joined" => date('c'),
            "payment_history" => []
        ];
    } else {
        $users_db[$target_user_id]['posts'] += $posts;
        $users_db[$target_user_id]['purchased'] = ($users_db[$target_user_id]['purchased'] ?? 0) + $posts;
    }
    
    // Add to payment history
    $users_db[$target_user_id]['payment_history'][] = [
        'amount' => 0, // Unknown if approved manually
        'posts' => $posts,
        'status' => 'approved',
        'date' => date('d M Y, H:i')
    ];
    
    save_db($users_db);
    
    try {
        send_message(
            $target_user_id,
            "━━━━━━━━━━━━━━━━━━━━
🎉 <b>Payment Approved!</b>
━━━━━━━━━━━━━━━━━━━━

✅ <b>{$posts} Posts</b> added!

💰 <b>Total Balance:</b> {$users_db[$target_user_id]['posts']} posts

━━━━━━━━━━━━━━━━━━━━

🚀 Start posting now!
Just send any message here.

Thank you! 🙏",
            main_menu()
        );
        $notification_status = "✅ User notified";
    } catch (Exception $e) {
        log_message('ERROR', "Error notifying user: " . $e->getMessage());
        $notification_status = "⚠️ Could not notify user";
    }
    
    send_message(
        $chat_id,
        "✅ <b>Approved Successfully!</b>\n\n👤 User: <code>$target_user_id</code>\n📦 Posts Added: $posts\n💰 Total Balance: {$users_db[$target_user_id]['posts']}\n\n$notification_status"
    );
}

// ===== ADMIN: REJECT PAYMENT (NEW) =====
function handle_reject($chat_id, $user_id, $args) {
    global $users_db;
    
    if (!in_array($user_id, ADMIN_ID)) {
        return;
    }
    
    if (count($args) < 1) {
        send_message(
            $chat_id,
            "❌ <b>Usage:</b>\n<code>/reject payment_id [reason]</code>\n\n<b>Example:</b>\n<code>/reject 1234567890_123456789 Invalid screenshot</code>"
        );
        return;
    }
    
    $payment_id = $args[0];
    $reason = implode(' ', array_slice($args, 1)) ?: "Payment verification failed";
    
    $pending = load_pending_payments();
    
    if (!isset($pending[$payment_id])) {
        send_message($chat_id, "❌ Payment ID not found!");
        return;
    }
    
    $payment = $pending[$payment_id];
    $target_user_id = $payment['user_id'];
    
    // Update pending payment status
    $pending[$payment_id]['status'] = 'rejected';
    $pending[$payment_id]['rejected_at'] = time();
    $pending[$payment_id]['reject_reason'] = $reason;
    save_pending_payments($pending);
    
    // Add to user payment history
    if (isset($users_db[$target_user_id])) {
        $users_db[$target_user_id]['payment_history'][] = [
            'amount' => $payment['amount'],
            'posts' => $payment['posts'],
            'utr' => $payment['utr'],
            'status' => 'rejected',
            'reason' => $reason,
            'date' => date('d M Y, H:i')
        ];
        save_db($users_db);
    }
    
    // Notify user
    try {
        send_message(
            $target_user_id,
            "━━━━━━━━━━━━━━━━━━━━
❌ <b>Payment Rejected</b>
━━━━━━━━━━━━━━━━━━━━

<b>Reason:</b> $reason

<b>Payment Details:</b>
• Amount: ₹{$payment['amount']}
• UTR: {$payment['utr']}

━━━━━━━━━━━━━━━━━━━━

Please contact admin for clarification:
" . ADMIN_USERNAME,
            main_menu()
        );
        $notification_status = "✅ User notified";
    } catch (Exception $e) {
        log_message('ERROR', "Error notifying user: " . $e->getMessage());
        $notification_status = "⚠️ Could not notify user";
    }
    
    send_message(
        $chat_id,
        "✅ <b>Payment Rejected!</b>\n\n👤 User: {$payment['user_name']}\n🆔 ID: <code>$target_user_id</code>\n💰 Amount: ₹{$payment['amount']}\n📝 Reason: $reason\n\n$notification_status"
    );
}

// ===== ADMIN: PENDING PAYMENTS (NEW) =====
function handle_pending($chat_id, $user_id) {
    if (!in_array($user_id, ADMIN_ID)) {
        return;
    }
    
    $pending = load_pending_payments();
    
    if (empty($pending)) {
        send_message($chat_id, "📭 No pending payments!");
        return;
    }
    
    $pending_list = [];
    $approved_list = [];
    $rejected_list = [];
    
    foreach ($pending as $payment_id => $payment) {
        if ($payment['status'] == 'pending') {
            $pending_list[$payment_id] = $payment;
        } elseif ($payment['status'] == 'approved') {
            $approved_list[$payment_id] = $payment;
        } elseif ($payment['status'] == 'rejected') {
            $rejected_list[$payment_id] = $payment;
        }
    }
    
    $msg = "━━━━━━━━━━━━━━━━━━━━
💳 <b>PENDING PAYMENTS</b> 💳
━━━━━━━━━━━━━━━━━━━━

📊 <b>Summary:</b>
⏳ Pending: " . count($pending_list) . "
✅ Approved: " . count($approved_list) . "
❌ Rejected: " . count($rejected_list) . "

━━━━━━━━━━━━━━━━━━━━

";
    
    if (!empty($pending_list)) {
        $msg .= "<b>⏳ PENDING REQUESTS:</b>\n\n";
        
        $count = 1;
        foreach ($pending_list as $payment_id => $payment) {
            $age = time() - $payment['timestamp'];
            $age_text = $age < 3600 ? floor($age/60) . ' min ago' : floor($age/3600) . ' hrs ago';
            
            $msg .= "<b>$count.</b> {$payment['user_name']}\n";
            $msg .= "   Amount: ₹{$payment['amount']} | Posts: {$payment['posts']}\n";
            $msg .= "   UTR: <code>{$payment['utr']}</code>\n";
            $msg .= "   Time: $age_text\n";
            $msg .= "   ID: <code>$payment_id</code>\n";
            $msg .= "   User: <code>{$payment['user_id']}</code>\n";
            $msg .= "\n";
            $count++;
        }
    } else {
        $msg .= "✅ No pending payments!\n\n";
    }
    
    $msg .= "━━━━━━━━━━━━━━━━━━━━\n\n";
    $msg .= "<b>Commands:</b>\n";
    $msg .= "/approve user_id posts\n";
    $msg .= "/reject payment_id [reason]";
    
    send_message($chat_id, $msg);
}

// ===== ADMIN: USER LIST =====
function handle_user_list($chat_id) {
    global $users_db;
    
    if (!count($users_db)) {
        send_message($chat_id, "📭 No users yet!");
        return;
    }
    
    $total_posts = 0;
    $total_sent = 0;
    $active = 0;
    
    foreach ($users_db as $user) {
        $total_posts += $user['posts'] ?? 0;
        $total_sent += $user['sent'] ?? 0;
        if (($user['posts'] ?? 0) > 0) {
            $active++;
        }
    }
    
    $msg = "━━━━━━━━━━━━━━━━━━━━
📊 <b>USER DATABASE</b> 📊
━━━━━━━━━━━━━━━━━━━━

<b>📈 Stats:</b>
• Total Users: " . count($users_db) . "
• Active: $active
• Inactive: " . (count($users_db) - $active) . "
• Posts Available: $total_posts
• Messages Sent: $total_sent

━━━━━━━━━━━━━━━━━━━━

<b>👥 Top 20 Users:</b>

";
    
    uasort($users_db, function($a, $b) {
        return ($b['posts'] ?? 0) <=> ($a['posts'] ?? 0);
    });
    
    $count = 0;
    foreach ($users_db as $uid => $data) {
        if ($count >= 20) break;
        
        $status = (($data['posts'] ?? 0) > 0) ? "🟢" : "🔴";
        $msg .= "$status <b>{$data['name']}</b>\n";
        $msg .= "   Posts: " . ($data['posts'] ?? 0) . " | Sent: " . ($data['sent'] ?? 0) . "\n";
        $msg .= "   ID: <code>$uid</code>\n\n";
        $count++;
    }
    
    $msg .= "━━━━━━━━━━━━━━━━━━━━\n\n";
    $msg .= "💡 <i>Use /listall for complete list</i>\n";
    $msg .= "📄 <i>Use /export for downloadable file</i>";
    
    send_message($chat_id, $msg);
}

// ===== ADMIN: LIST ALL =====
function handle_list_all($chat_id, $user_id) {
    global $users_db;
    
    if (!in_array($user_id, ADMIN_ID)) {
        return;
    }
    
    if (!count($users_db)) {
        send_message($chat_id, "📭 No users yet!");
        return;
    }
    
    $status_msg = send_message($chat_id, "🔄 Loading all users...");
    
    $total_posts = 0;
    $total_sent = 0;
    $active = 0;
    
    foreach ($users_db as $user) {
        $total_posts += $user['posts'] ?? 0;
        $total_sent += $user['sent'] ?? 0;
        if (($user['posts'] ?? 0) > 0) {
            $active++;
        }
    }
    
    $messages = [];
    $current_msg = "━━━━━━━━━━━━━━━━━━━━
📊 <b>COMPLETE USER LIST</b> 📊
━━━━━━━━━━━━━━━━━━━━

<b>📈 Overview:</b>
• Total Users: " . count($users_db) . "
• Active: $active
• Inactive: " . (count($users_db) - $active) . "
• Posts Available: $total_posts
• Messages Sent: $total_sent

━━━━━━━━━━━━━━━━━━━━

<b>👥 All Users:</b>

";
    
    uasort($users_db, function($a, $b) {
        return ($b['posts'] ?? 0) <=> ($a['posts'] ?? 0);
    });
    
    $idx = 1;
    foreach ($users_db as $uid => $data) {
        $status = (($data['posts'] ?? 0) > 0) ? "🟢" : "🔴";
        $user_info = "$status <b>$idx. {$data['name']}</b>\n";
        $user_info .= "   Posts: " . ($data['posts'] ?? 0) . " | Sent: " . ($data['sent'] ?? 0) . "\n";
        $user_info .= "   ID: <code>$uid</code>\n\n";
        
        if (strlen($current_msg . $user_info) > 4000) {
            $messages[] = $current_msg;
            $current_msg = $user_info;
        } else {
            $current_msg .= $user_info;
        }
        $idx++;
    }
    
    if ($current_msg) {
        $messages[] = $current_msg;
    }
    
    delete_message($chat_id, $status_msg['result']['message_id']);
    
    $last_index = count($messages) - 1;
    for ($i = 0; $i <= $last_index; $i++) {
        if ($i == $last_index) {
            $messages[$i] .= "━━━━━━━━━━━━━━━━━━━━\n📄 Total: " . count($users_db) . " users";
        }
        send_message($chat_id, $messages[$i]);
    }
}

// ===== ADMIN: EXPORT =====
function handle_export($chat_id, $user_id) {
    global $users_db;
    
    if (!in_array($user_id, ADMIN_ID)) {
        return;
    }
    
    if (!count($users_db)) {
        send_message($chat_id, "📭 The user database is empty.");
        return;
    }

    $status_msg = send_message($chat_id, "🔄 Generating user data file...");
    
    $filename = "users_export_" . date('Ymd_His') . ".txt";
    
    try {
        $total_users = count($users_db);
        $active_users = 0;
        $total_posts = 0;
        $total_sent = 0;
        $total_purchased = 0;
        
        foreach ($users_db as $user) {
            if (($user['posts'] ?? 0) > 0) {
                $active_users++;
            }
            $total_posts += $user['posts'] ?? 0;
            $total_sent += $user['sent'] ?? 0;
            $total_purchased += $user['purchased'] ?? 0;
        }
        
        $content = "=" . str_repeat("=", 58) . "\n";
        $content .= "USER DATABASE EXPORT\n";
        $content .= "Generated: " . date('Y-m-d H:i:s') . "\n";
        $content .= "=" . str_repeat("=", 58) . "\n\n";
        
        $content .= "📊 SUMMARY STATISTICS\n";
        $content .= "-" . str_repeat("-", 60) . "\n";
        $content .= "Total Users:        " . str_pad($total_users, 10) . "\n";
        $content .= "Active Users:       " . str_pad($active_users, 10) . "\n";
        $content .= "Inactive Users:     " . str_pad($total_users - $active_users, 10) . "\n";
        $content .= "Posts Available:    " . str_pad($total_posts, 10) . "\n";
        $content .= "Messages Sent:      " . str_pad($total_sent, 10) . "\n";
        $content .= "Total Purchased:    " . str_pad($total_purchased, 10) . "\n";
        $content .= "\n" . "=" . str_repeat("=", 60) . "\n\n";
        
        $content .= "👥 COMPLETE USER LIST\n";
        $content .= "=" . str_repeat("=", 60) . "\n\n";
        
        uasort($users_db, function($a, $b) {
            return ($b['posts'] ?? 0) <=> ($a['posts'] ?? 0);
        });

        $idx = 1;
        foreach ($users_db as $uid => $data) {
            $status = (($data['posts'] ?? 0) > 0) ? "ACTIVE" : "INACTIVE";
            
            $content .= "[$idx] {$data['name']}\n";
            $content .= "    User ID:          $uid\n";
            $content .= "    Status:           " . str_pad($status, 10) . "\n";
            $content .= "    Posts Remaining:  " . str_pad($data['posts'] ?? 0, 10) . "\n";
            $content .= "    Messages Sent:    " . str_pad($data['sent'] ?? 0, 10) . "\n";
            $content .= "    Total Purchased:  " . str_pad($data['purchased'] ?? 0, 10) . "\n";
            $content .= "    Joined On:        " . ($data['joined'] ?? 'N/A') . "\n";
            $content .= "-" . str_repeat("-", 60) . "\n\n";
            $idx++;
        }
        
        $content .= "=" . str_repeat("=", 60) . "\n";
        $content .= "END OF REPORT - $total_users Users Listed\n";
        $content .= "=" . str_repeat("=", 60) . "\n";
        
        file_put_contents($filename, $content);
        
        $document = new CURLFile($filename);
        $url = "https://api.telegram.org/bot" . BOT_TOKEN . "/sendDocument";
        
        $data = [
            'chat_id' => $chat_id,
            'document' => $document,
            'caption' => "✅ <b>User Database Export</b>\n\n📊 Total Users: $total_users\n🟢 Active: $active_users\n🔴 Inactive: " . ($total_users - $active_users) . "\n\n📅 " . date('d M Y, H:i'),
            'parse_mode' => 'HTML'
        ];
        
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: multipart/form-data']);
        
        curl_exec($ch);
        curl_close($ch);
        
        delete_message($chat_id, $status_msg['result']['message_id']);

    } catch (Exception $e) {
        log_message('ERROR', "Error exporting users: " . $e->getMessage());
        send_message($chat_id, "❌ An error occurred while creating the file.");
    }
    
    if (file_exists($filename)) {
        unlink($filename);
    }
}

// ===== ADMIN: ADD POSTS =====
function handle_addposts($chat_id, $user_id, $args) {
    global $users_db;
    
    if (!in_array($user_id, ADMIN_ID)) {
        return;
    }
    
    if (count($args) < 2) {
        send_message(
            $chat_id,
            "❌ <b>Usage:</b>\n<code>/addposts user_id posts</code>\n\n<b>Example:</b>\n<code>/addposts 123456789 50</code>"
        );
        return;
    }
    
    $target_user_id = $args[0];
    $posts = (int)$args[1];
    
    if (!isset($users_db[$target_user_id])) {
        send_message($chat_id, "❌ User not found in database!");
        return;
    }
    
    $users_db[$target_user_id]['posts'] += $posts;
    save_db($users_db);
    
    send_message(
        $chat_id,
        "✅ <b>Posts Added!</b>\n\nUser: <code>$target_user_id</code>\nAdded: $posts\nTotal: {$users_db[$target_user_id]['posts']}"
    );
}

// ===== ADMIN: REMOVE POSTS =====
function handle_removeposts($chat_id, $user_id, $args) {
    global $users_db;
    
    if (!in_array($user_id, ADMIN_ID)) {
        return;
    }
    
    if (count($args) < 2) {
        send_message(
            $chat_id,
            "❌ <b>Usage:</b>\n<code>/removeposts user_id posts</code>"
        );
        return;
    }
    
    $target_user_id = $args[0];
    $posts = (int)$args[1];
    
    if (!isset($users_db[$target_user_id])) {
        send_message($chat_id, "❌ User not found!");
        return;
    }
    
    $users_db[$target_user_id]['posts'] = max(0, ($users_db[$target_user_id]['posts'] ?? 0) - $posts);
    save_db($users_db);
    
    send_message(
        $chat_id,
        "✅ <b>Posts Removed!</b>\n\nUser: <code>$target_user_id</code>\nRemoved: $posts\nRemaining: {$users_db[$target_user_id]['posts']}"
    );
}

// ===== ADMIN: REMOVE USER =====
function handle_remove($chat_id, $user_id, $args) {
    global $users_db;
    
    if (!in_array($user_id, ADMIN_ID)) {
        return;
    }
    
    if (count($args) < 1) {
        send_message($chat_id, "❌ <b>Usage:</b>\n<code>/remove user_id</code>");
        return;
    }
    
    $target_user_id = $args[0];
    
    if (isset($users_db[$target_user_id])) {
        $name = $users_db[$target_user_id]['name'] ?? 'Unknown';
        unset($users_db[$target_user_id]);
        save_db($users_db);
        send_message(
            $chat_id,
            "✅ <b>User Removed!</b>\n\nName: $name\nID: <code>$target_user_id</code>"
        );
    } else {
        send_message($chat_id, "❌ User not found!");
    }
}

// ===== ADMIN: BROADCAST =====
function handle_broadcast($chat_id, $user_id, $args) {
    global $users_db;
    
    if (!in_array($user_id, ADMIN_ID)) {
        return;
    }
    
    if (!count($args)) {
        send_message($chat_id, "❌ <b>Usage:</b>\n<code>/broadcast your message here</code>");
        return;
    }
    
    $msg = implode(' ', $args);
    $success = 0;
    $failed = 0;
    
    $status_msg = send_message($chat_id, "📤 Broadcasting...");
    
    foreach ($users_db as $uid => $data) {
        try {
            send_message(
                $uid,
                "━━━━━━━━━━━━━━━━━━━━\n📢 <b>ANNOUNCEMENT</b>\n━━━━━━━━━━━━━━━━━━━━\n\n$msg\n\n━━━━━━━━━━━━━━━━━━━━"
            );
            $success++;
        } catch (Exception $e) {
            $failed++;
            log_message('ERROR', "Broadcast error for $uid: " . $e->getMessage());
        }
    }
    
    delete_message($chat_id, $status_msg['result']['message_id']);
    
    send_message(
        $chat_id,
        "✅ <b>Broadcast Complete!</b>\n\n✓ Sent: $success\n✗ Failed: $failed"
    );
}

// ===== ADMIN: STATS =====
function handle_stats($chat_id, $user_id) {
    global $users_db, $PACKAGES;
    
    if (!in_array($user_id, ADMIN_ID)) {
        return;
    }
    
    $total = count($users_db);
    $active = 0;
    $posts = 0;
    $sent = 0;
    $purchased = 0;
    
    foreach ($users_db as $user) {
        if (($user['posts'] ?? 0) > 0) {
            $active++;
        }
        $posts += $user['posts'] ?? 0;
        $sent += $user['sent'] ?? 0;
        $purchased += $user['purchased'] ?? 0;
    }
    
    $pending = load_pending_payments();
    $pending_count = 0;
    foreach ($pending as $payment) {
        if ($payment['status'] == 'pending') {
            $pending_count++;
        }
    }
    
    $revenue = 0;
    foreach ($PACKAGES as $amount => $post_count) {
        $revenue += (int)($purchased / $post_count) * $amount;
    }
    
    $stats = "━━━━━━━━━━━━━━━━━━━━
📊 <b>BOT STATISTICS</b> 📊
━━━━━━━━━━━━━━━━━━━━

<b>👥 Users:</b>
• Total: $total
• Active: $active
• Inactive: " . ($total - $active) . "

<b>💰 Posts:</b>
• Available: $posts
• Sent: $sent
• Purchased: $purchased

<b>💳 Payments:</b>
• Pending: $pending_count

<b>💵 Est. Revenue:</b>
• ~₹$revenue

━━━━━━━━━━━━━━━━━━━━

<b>Admin Commands:</b>
/pending - View pending payments
/approve user_id posts
/reject payment_id [reason]
/list - Top 20 users
/broadcast message";
    
    send_message($chat_id, $stats);
}

// ===== WEBHOOK HANDLER =====
function webhook_handler() {
    global $users_db;
    
    // Load databases
    $users_db = load_db();
    
    // Get input data
    $input = file_get_contents('php://input');
    $update = json_decode($input, true);
    
    if (!$update) {
        log_message('ERROR', 'Invalid update received');
        return;
    }
    
    log_message('INFO', 'Update received: ' . json_encode($update));
    
    // Handle callback queries
    if (isset($update['callback_query'])) {
        $callback = $update['callback_query'];
        $chat_id = $callback['message']['chat']['id'];
        $user_id = $callback['from']['id'];
        $message_id = $callback['message']['message_id'];
        
        handle_callback($callback, $chat_id, $user_id, $message_id);
        return;
    }
    
    // Handle messages
    if (isset($update['message'])) {
        $message = $update['message'];
        $chat_id = $message['chat']['id'];
        $user_id = $message['from']['id'];
        $name = $message['from']['first_name'] . ' ' . ($message['from']['last_name'] ?? '');
        $name = trim($name);
        
        // Handle commands
        if (isset($message['text']) && strpos($message['text'], '/') === 0) {
            $text = $message['text'];
            $parts = explode(' ', $text);
            $command = strtolower(substr($parts[0], 1));
            $args = array_slice($parts, 1);
            
            switch ($command) {
                case 'start':
                    handle_start($chat_id, $user_id, $name);
                    break;
                case 'cancel':
                    handle_cancel($chat_id, $user_id);
                    break;
                case 'approve':
                    handle_approve($chat_id, $user_id, $args);
                    break;
                case 'reject':
                    handle_reject($chat_id, $user_id, $args);
                    break;
                case 'pending':
                    handle_pending($chat_id, $user_id);
                    break;
                case 'addposts':
                    handle_addposts($chat_id, $user_id, $args);
                    break;
                case 'removeposts':
                    handle_removeposts($chat_id, $user_id, $args);
                    break;
                case 'list':
                    handle_user_list($chat_id);
                    break;
                case 'listall':
                    handle_list_all($chat_id, $user_id);
                    break;
                case 'export':
                    handle_export($chat_id, $user_id);
                    break;
                case 'remove':
                    handle_remove($chat_id, $user_id, $args);
                    break;
                case 'broadcast':
                    handle_broadcast($chat_id, $user_id, $args);
                    break;
                case 'stats':
                    handle_stats($chat_id, $user_id);
                    break;
                default:
                    handle_message($chat_id, $user_id, $name, $message);
            }
        } else {
            handle_message($chat_id, $user_id, $name, $message);
        }
    }
}

// ===== WEBHOOK SETUP =====
function set_webhook($url) {
    $api_url = "https://api.telegram.org/bot" . BOT_TOKEN . "/setWebhook";
    $data = ['url' => $url];
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $api_url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    
    $response = curl_exec($ch);
    curl_close($ch);
    
    return json_decode($response, true);
}

// ===== MAIN EXECUTION =====
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Handle webhook request
    webhook_handler();
} elseif (isset($_GET['action'])) {
    // Handle setup actions
    if ($_GET['action'] === 'setwebhook') {
        $url = $_GET['url'] ?? 'https://' . $_SERVER['HTTP_HOST'] . $_SERVER['SCRIPT_NAME'];
        $result = set_webhook($url);
        
        if ($result['ok']) {
            echo "✅ Webhook set successfully to: $url";
        } else {
            echo "❌ Failed to set webhook: " . $result['description'];
        }
    } elseif ($_GET['action'] === 'removewebhook') {
        $api_url = "https://api.telegram.org/bot" . BOT_TOKEN . "/deleteWebhook";
        
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $api_url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        
        $response = curl_exec($ch);
        curl_close($ch);
        
        $result = json_decode($response, true);
        
        if ($result['ok']) {
            echo "✅ Webhook removed successfully";
        } else {
            echo "❌ Failed to remove webhook: " . $result['description'];
        }
    } elseif ($_GET['action'] === 'info') {
        $api_url = "https://api.telegram.org/bot" . BOT_TOKEN . "/getWebhookInfo";
        
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $api_url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        
        $response = curl_exec($ch);
        curl_close($ch);
        
        $result = json_decode($response, true);
        
        echo "<pre>";
        print_r($result);
        echo "</pre>";
    }
} else {
    // Display setup instructions
    $current_url = 'https://' . $_SERVER['HTTP_HOST'] . $_SERVER['SCRIPT_NAME'];
    
    echo <<<HTML
<!DOCTYPE html>
<html>
<head>
    <title>Telegram Bot Setup - FIXED VERSION</title>
    <style>
        body { font-family: Arial, sans-serif; max-width: 800px; margin: 0 auto; padding: 20px; background: #f0f2f5; }
        .container { background: #fff; padding: 30px; border-radius: 10px; box-shadow: 0 2px 10px rgba(0,0,0,0.1); }
        h1 { color: #333; border-bottom: 3px solid #0088cc; padding-bottom: 10px; }
        h3 { color: #0088cc; margin-top: 25px; }
        .url { background: #f5f5f5; padding: 15px; border-radius: 5px; font-family: monospace; border-left: 4px solid #0088cc; margin: 15px 0; }
        .btn { display: inline-block; padding: 12px 25px; margin: 10px 5px; background: #0088cc; color: white; text-decoration: none; border-radius: 5px; font-weight: bold; }
        .btn:hover { background: #006699; }
        .btn-danger { background: #dc3545; }
        .btn-danger:hover { background: #c82333; }
        .btn-success { background: #28a745; }
        .btn-success:hover { background: #218838; }
        .btn-info { background: #17a2b8; }
        .btn-info:hover { background: #138496; }
        .features { background: #e7f5ff; padding: 15px; border-radius: 5px; margin: 15px 0; }
        .features ul { margin: 10px 0; }
        .features li { margin: 5px 0; }
        .warning { background: #fff3cd; border-left: 4px solid #ffc107; padding: 15px; margin: 15px 0; }
        .success { background: #d4edda; border-left: 4px solid #28a745; padding: 15px; margin: 15px 0; }
    </style>
</head>
<body>
    <div class="container">
        <h1>🤖 Telegram Bot Setup - FIXED VERSION ✅</h1>
        
        <div class="success">
            <strong>✅ What's Fixed:</strong>
            <ul>
                <li>✅ Payment state persistence (data saved between requests)</li>
                <li>✅ Duplicate UTR checking</li>
                <li>✅ Payment history tracking</li>
                <li>✅ Pending payments management</li>
                <li>✅ Reject payment functionality</li>
                <li>✅ Better error handling</li>
            </ul>
        </div>
        
        <div class="features">
            <strong>🎉 New Features:</strong>
            <ul>
                <li>📜 Payment History for users</li>
                <li>💳 Pending payments list for admins</li>
                <li>❌ Reject payment with reason</li>
                <li>🔒 UTR duplicate detection</li>
                <li>📊 Enhanced admin stats</li>
                <li>⏰ Payment age tracking</li>
            </ul>
        </div>
        
        <p><strong>Current URL:</strong></p>
        <div class="url">$current_url</div>
        
        <p><strong>Actions:</strong></p>
        <a href="?action=setwebhook" class="btn btn-success">✅ Set Webhook</a>
        <a href="?action=removewebhook" class="btn btn-danger">❌ Remove Webhook</a>
        <a href="?action=info" class="btn btn-info">ℹ️ Webhook Info</a>
        
        <h3>📋 Setup Instructions:</h3>
        <ol>
            <li>Upload this file to your web server (PHP 7.4+ required)</li>
            <li>Make sure the server has write permissions for:
                <ul>
                    <li>users_db.json</li>
                    <li>payments.json (NEW)</li>
                    <li>pending_payments.json (NEW)</li>
                    <li>bot.log</li>
                </ul>
            </li>
            <li>Click "✅ Set Webhook" to configure Telegram</li>
            <li>Start your bot by sending /start to it on Telegram</li>
        </ol>
        
        <h3>🔧 Required Permissions:</h3>
        <ul>
            <li>Write permission for JSON files</li>
            <li>Write permission for log file</li>
            <li>SSL certificate (HTTPS required for webhook)</li>
        </ul>
        
        <h3>👨‍💼 Admin Commands:</h3>
        <div class="url">
/start - Start bot<br>
/stats - View statistics<br>
/pending - View pending payments<br>
/approve user_id posts - Approve payment<br>
/reject payment_id [reason] - Reject payment<br>
/list - Top 20 users<br>
/listall - All users<br>
/export - Export users to file<br>
/addposts user_id posts - Add posts<br>
/removeposts user_id posts - Remove posts<br>
/remove user_id - Remove user<br>
/broadcast message - Send announcement
        </div>
        
        <div class="warning">
            <strong>⚠️ Important:</strong> This bot uses webhook mode. The payment bug has been fixed by implementing persistent storage for payment sessions.
        </div>
    </div>
</body>
</html>
HTML;
}
?>