<?php
// Telegram Bot Configuration
define('BOT_TOKEN', '8313568243:AAFRQXeygOGBacv1Bi3zFidaw2EKn_8AQgA');
define('API_URL', 'https://api.telegram.org/bot' . BOT_TOKEN);
define('BOMBER_API', 'https://vipxofficial.sbs/bomber/start');

// Enable error logging for debugging
error_log("Telegram Bot Started");
file_put_contents('debug.log', date('Y-m-d H:i:s') . " - Bot started\n", FILE_APPEND);

// Get incoming message
$content = file_get_contents("php://input");

// Log incoming data
file_put_contents('debug.log', date('Y-m-d H:i:s') . " - Raw input: " . $content . "\n", FILE_APPEND);

if (empty($content)) {
    error_log("No content received");
    exit;
}

$update = json_decode($content, true);

// Check if callback query (button press)
if (isset($update['callback_query'])) {
    $callback_query = $update['callback_query'];
    $chat_id = $callback_query['from']['id'];
    $callback_data = $callback_query['data'];
    $message_id = $callback_query['message']['message_id'];
    
    handleCallbackQuery($callback_data, $chat_id, $message_id);
    exit;
}

// Check if message exists
if (!isset($update['message'])) {
    error_log("No message in update");
    exit;
}

$message = $update['message'];
$chat_id = $message['chat']['id'];
$text = isset($message['text']) ? $message['text'] : '';
$user_name = isset($message['from']['first_name']) ? $message['from']['first_name'] : 'User';

// Log received message
error_log("Received from $chat_id: $text");

// Handle commands and messages
$response = handleMessage($text, $user_name, $chat_id);

// Send response
sendMessage($chat_id, $response['text'], isset($response['keyboard']) ? $response['keyboard'] : null);

/**
 * Handle callback queries (button presses)
 */
function handleCallbackQuery($callback_data, $chat_id, $message_id) {
    error_log("Callback received: $callback_data");
    
    if (strpos($callback_data, 'confirm_bomb_') === 0) {
        $phone = substr($callback_data, 13);
        
        // Send initial processing message
        editMessage($chat_id, $message_id, "⏳ <b>Processing...</b>\n\nPhone: <code>$phone</code>\n\nPlease wait...");
        
        // Call the bomber API
        $result = callBomberAPI($phone);
        
        if ($result['success']) {
            $text = "✅ <b>SMS Sent Successfully!</b>\n\nPhone: <code>$phone</code>\n" . $result['message'];
        } else {
            $text = "❌ <b>Failed to Send SMS</b>\n\nPhone: <code>$phone</code>\nError: " . $result['message'];
        }
        
        // Edit the message to remove buttons and show result
        editMessage($chat_id, $message_id, $text);
    } elseif ($callback_data === 'cancel_bomb') {
        // Delete the message
        deleteMessage($chat_id, $message_id);
        // Send confirmation
        sendMessage($chat_id, "❌ Operation cancelled.");
    }
}

/**
 * Edit message in Telegram
 */
function editMessage($chat_id, $message_id, $text) {
    $url = API_URL . '/editMessageText';
    
    $data = [
        'chat_id' => $chat_id,
        'message_id' => $message_id,
        'text' => $text,
        'parse_mode' => 'HTML',
        'disable_web_page_preview' => true
    ];
    
    $options = [
        'http' => [
            'method' => 'POST',
            'header' => 'Content-Type: application/x-www-form-urlencoded',
            'content' => http_build_query($data),
            'timeout' => 5
        ]
    ];
    
    $context = stream_context_create($options);
    $result = @file_get_contents($url, false, $context);
    
    if ($result === FALSE) {
        error_log("Failed to edit message: " . error_get_last()['message']);
    }
}

/**
 * Delete message from Telegram
 */
function deleteMessage($chat_id, $message_id) {
    $url = API_URL . '/deleteMessage';
    
    $data = [
        'chat_id' => $chat_id,
        'message_id' => $message_id
    ];
    
    $options = [
        'http' => [
            'method' => 'POST',
            'header' => 'Content-Type: application/x-www-form-urlencoded',
            'content' => http_build_query($data),
            'timeout' => 5
        ]
    ];
    
    $context = stream_context_create($options);
    @file_get_contents($url, false, $context);
}

/**
 * Handle incoming messages
 */
function handleMessage($text, $user_name, $chat_id) {
    $text = trim($text);
    
    // Start command
    if ($text === '/start') {
        return [
            'text' => "👋 Hello $user_name! Welcome to SMS Bomber Bot.\n\n<b>Available commands:</b>\n/start - Show this message\n/help - Get help\n/bomb <phone> - Send SMS to phone number\n\n<b>Example:</b>\n<code>/bomb 9876543210</code>",
            'parse_mode' => 'HTML'
        ];
    }
    
    // Help command
    if ($text === '/help') {
        return [
            'text' => "ℹ️ <b>SMS Bomber Bot Help</b>\n\n📱 <b>Usage:</b>\nSend: <code>/bomb 9876543210</code>\n\n<b>Description:</b>\nThis bot sends SMS blasts using the bomber API.\n\n⚠️ <b>Warning:</b>\nUse responsibly and only for testing purposes.",
            'parse_mode' => 'HTML'
        ];
    }
    
    // Bomb command
    if (strpos($text, '/bomb ') === 0) {
        $phone = substr($text, 6);
        $phone = trim($phone);
        
        // Validate phone number (basic validation)
        if (empty($phone)) {
            return [
                'text' => "❌ Please provide a phone number.\nUsage: /bomb 9876543210"
            ];
        }
        
        // Remove any non-numeric characters
        $phone = preg_replace('/[^0-9]/', '', $phone);
        
        if (strlen($phone) < 10) {
            return [
                'text' => "❌ Invalid phone number format.\nPlease provide a valid phone number with at least 10 digits.\n\nExample: <code>/bomb 9876543210</code>",
                'parse_mode' => 'HTML'
            ];
        }
        
        // Create inline keyboard with confirm and cancel buttons
        $keyboard = [
            [
                ['text' => '✅ Confirm', 'callback_data' => 'confirm_bomb_' . $phone],
                ['text' => '❌ Cancel', 'callback_data' => 'cancel_bomb']
            ]
        ];
        
        return [
            'text' => "📱 <b>Confirm SMS Blast</b>\n\nPhone: <code>$phone</code>\n\nAre you sure you want to proceed?",
            'keyboard' => $keyboard,
            'parse_mode' => 'HTML'
        ];
    }
    
    // Default response for unknown commands
    if (!empty($text)) {
        return [
            'text' => "❌ Unknown command: <code>$text</code>\n\nType /help for available commands.",
            'parse_mode' => 'HTML'
        ];
    }
    
    return [
        'text' => "Send a command to get started. Type /help for available commands."
    ];
}

/**
 * Call the Bomber API using cURL (more reliable)
 */
function callBomberAPI($phone) {
    $data = json_encode(['phone' => $phone]);
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, BOMBER_API);
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Content-Type: application/json',
        'Content-Length: ' . strlen($data)
    ]);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 10);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
    
    $response = curl_exec($ch);
    $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $error = curl_error($ch);
    curl_close($ch);
    
    error_log("Bomber API Response - HTTP Code: $http_code, Response: $response");
    
    if ($error) {
        return [
            'success' => false,
            'message' => "Connection error: $error"
        ];
    }
    
    if ($http_code !== 200) {
        return [
            'success' => false,
            'message' => "HTTP Error: $http_code"
        ];
    }
    
    $result = json_decode($response, true);
    
    if (json_last_error() !== JSON_ERROR_NONE) {
        return [
            'success' => false,
            'message' => "Invalid JSON response"
        ];
    }
    
    return [
        'success' => true,
        'message' => isset($result['message']) ? $result['message'] : "API call successful"
    ];
}

/**
 * Send message to Telegram
 */
function sendMessage($chat_id, $text, $keyboard = null) {
    $url = API_URL . '/sendMessage';
    
    $data = [
        'chat_id' => $chat_id,
        'text' => $text,
        'parse_mode' => 'HTML',
        'disable_web_page_preview' => true
    ];
    
    // Add inline keyboard if provided
    if ($keyboard) {
        $data['reply_markup'] = json_encode([
            'inline_keyboard' => $keyboard
        ]);
    }
    
    $options = [
        'http' => [
            'method' => 'POST',
            'header' => 'Content-Type: application/x-www-form-urlencoded',
            'content' => http_build_query($data),
            'timeout' => 5
        ]
    ];
    
    $context = stream_context_create($options);
    $result = @file_get_contents($url, false, $context);
    
    if ($result === FALSE) {
        error_log("Failed to send message to $chat_id: " . error_get_last()['message']);
        // Try alternative method
        sendMessageCurl($chat_id, $text, $keyboard);
    } else {
        error_log("Message sent successfully to $chat_id");
    }
}

/**
 * Alternative send message using cURL
 */
function sendMessageCurl($chat_id, $text, $keyboard = null) {
    $url = API_URL . '/sendMessage';
    
    $data = [
        'chat_id' => $chat_id,
        'text' => $text,
        'parse_mode' => 'HTML',
        'disable_web_page_preview' => true
    ];
    
    if ($keyboard) {
        $data['reply_markup'] = json_encode([
            'inline_keyboard' => $keyboard
        ]);
    }
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 5);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
    
    $result = curl_exec($ch);
    curl_close($ch);
    
    return $result;
}

// Add webhook setup endpoint for testing
if (isset($_GET['setup'])) {
    $webhook_url = "https://" . $_SERVER['HTTP_HOST'] . $_SERVER['SCRIPT_NAME'];
    $set_webhook = API_URL . '/setWebhook?url=' . urlencode($webhook_url);
    $result = file_get_contents($set_webhook);
    echo "Webhook setup result: " . $result;
    exit;
}

// Add webhook delete endpoint
if (isset($_GET['delete'])) {
    $delete_webhook = API_URL . '/deleteWebhook';
    $result = file_get_contents($delete_webhook);
    echo "Webhook deleted: " . $result;
    exit;
}
?>